/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.InputColumn;
import software.amazon.awssdk.services.quicksight.model.InputColumnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParentDataSet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParentDataSet> {
    private static final SdkField<String> DATA_SET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSetArn").getter(ParentDataSet.getter(ParentDataSet::dataSetArn)).setter(ParentDataSet.setter(Builder::dataSetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetArn").build()}).build();
    private static final SdkField<List<InputColumn>> INPUT_COLUMNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InputColumns").getter(ParentDataSet.getter(ParentDataSet::inputColumns)).setter(ParentDataSet.setter(Builder::inputColumns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputColumns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputColumn::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SET_ARN_FIELD, INPUT_COLUMNS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ParentDataSet.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String dataSetArn;
    private final List<InputColumn> inputColumns;

    private ParentDataSet(BuilderImpl builder) {
        this.dataSetArn = builder.dataSetArn;
        this.inputColumns = builder.inputColumns;
    }

    public final String dataSetArn() {
        return this.dataSetArn;
    }

    public final boolean hasInputColumns() {
        return this.inputColumns != null && !(this.inputColumns instanceof SdkAutoConstructList);
    }

    public final List<InputColumn> inputColumns() {
        return this.inputColumns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputColumns() ? this.inputColumns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParentDataSet)) {
            return false;
        }
        ParentDataSet other = (ParentDataSet)obj;
        return Objects.equals(this.dataSetArn(), other.dataSetArn()) && this.hasInputColumns() == other.hasInputColumns() && Objects.equals(this.inputColumns(), other.inputColumns());
    }

    public final String toString() {
        return ToString.builder((String)"ParentDataSet").add("DataSetArn", (Object)this.dataSetArn()).add("InputColumns", this.hasInputColumns() ? this.inputColumns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSetArn": {
                return Optional.ofNullable(clazz.cast(this.dataSetArn()));
            }
            case "InputColumns": {
                return Optional.ofNullable(clazz.cast(this.inputColumns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DataSetArn", DATA_SET_ARN_FIELD);
        map.put("InputColumns", INPUT_COLUMNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParentDataSet, T> g) {
        return obj -> g.apply((ParentDataSet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataSetArn;
        private List<InputColumn> inputColumns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ParentDataSet model) {
            this.dataSetArn(model.dataSetArn);
            this.inputColumns(model.inputColumns);
        }

        public final String getDataSetArn() {
            return this.dataSetArn;
        }

        public final void setDataSetArn(String dataSetArn) {
            this.dataSetArn = dataSetArn;
        }

        @Override
        public final Builder dataSetArn(String dataSetArn) {
            this.dataSetArn = dataSetArn;
            return this;
        }

        public final List<InputColumn.Builder> getInputColumns() {
            List<InputColumn.Builder> result = InputColumnListCopier.copyToBuilder(this.inputColumns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputColumns(Collection<InputColumn.BuilderImpl> inputColumns) {
            this.inputColumns = InputColumnListCopier.copyFromBuilder(inputColumns);
        }

        @Override
        public final Builder inputColumns(Collection<InputColumn> inputColumns) {
            this.inputColumns = InputColumnListCopier.copy(inputColumns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputColumns(InputColumn ... inputColumns) {
            this.inputColumns(Arrays.asList(inputColumns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputColumns(Consumer<InputColumn.Builder> ... inputColumns) {
            this.inputColumns(Stream.of(inputColumns).map(c -> (InputColumn)((InputColumn.Builder)InputColumn.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ParentDataSet build() {
            return new ParentDataSet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParentDataSet> {
        public Builder dataSetArn(String var1);

        public Builder inputColumns(Collection<InputColumn> var1);

        public Builder inputColumns(InputColumn ... var1);

        public Builder inputColumns(Consumer<InputColumn.Builder> ... var1);
    }
}

