/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.quicksight.model.SensitiveStringListCopier;
import software.amazon.awssdk.services.quicksight.model.TypeParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SemanticType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SemanticType> {
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeName").getter(SemanticType.getter(SemanticType::typeName)).setter(SemanticType.setter(Builder::typeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()}).build();
    private static final SdkField<String> SUB_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubTypeName").getter(SemanticType.getter(SemanticType::subTypeName)).setter(SemanticType.setter(Builder::subTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubTypeName").build()}).build();
    private static final SdkField<Map<String, String>> TYPE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("TypeParameters").getter(SemanticType.getter(SemanticType::typeParameters)).setter(SemanticType.setter(Builder::typeParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TRUTHY_CELL_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TruthyCellValue").getter(SemanticType.getter(SemanticType::truthyCellValue)).setter(SemanticType.setter(Builder::truthyCellValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TruthyCellValue").build()}).build();
    private static final SdkField<List<String>> TRUTHY_CELL_VALUE_SYNONYMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TruthyCellValueSynonyms").getter(SemanticType.getter(SemanticType::truthyCellValueSynonyms)).setter(SemanticType.setter(Builder::truthyCellValueSynonyms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TruthyCellValueSynonyms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FALSEY_CELL_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FalseyCellValue").getter(SemanticType.getter(SemanticType::falseyCellValue)).setter(SemanticType.setter(Builder::falseyCellValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FalseyCellValue").build()}).build();
    private static final SdkField<List<String>> FALSEY_CELL_VALUE_SYNONYMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FalseyCellValueSynonyms").getter(SemanticType.getter(SemanticType::falseyCellValueSynonyms)).setter(SemanticType.setter(Builder::falseyCellValueSynonyms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FalseyCellValueSynonyms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_NAME_FIELD, SUB_TYPE_NAME_FIELD, TYPE_PARAMETERS_FIELD, TRUTHY_CELL_VALUE_FIELD, TRUTHY_CELL_VALUE_SYNONYMS_FIELD, FALSEY_CELL_VALUE_FIELD, FALSEY_CELL_VALUE_SYNONYMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SemanticType.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String typeName;
    private final String subTypeName;
    private final Map<String, String> typeParameters;
    private final String truthyCellValue;
    private final List<String> truthyCellValueSynonyms;
    private final String falseyCellValue;
    private final List<String> falseyCellValueSynonyms;

    private SemanticType(BuilderImpl builder) {
        this.typeName = builder.typeName;
        this.subTypeName = builder.subTypeName;
        this.typeParameters = builder.typeParameters;
        this.truthyCellValue = builder.truthyCellValue;
        this.truthyCellValueSynonyms = builder.truthyCellValueSynonyms;
        this.falseyCellValue = builder.falseyCellValue;
        this.falseyCellValueSynonyms = builder.falseyCellValueSynonyms;
    }

    public final String typeName() {
        return this.typeName;
    }

    public final String subTypeName() {
        return this.subTypeName;
    }

    public final boolean hasTypeParameters() {
        return this.typeParameters != null && !(this.typeParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> typeParameters() {
        return this.typeParameters;
    }

    public final String truthyCellValue() {
        return this.truthyCellValue;
    }

    public final boolean hasTruthyCellValueSynonyms() {
        return this.truthyCellValueSynonyms != null && !(this.truthyCellValueSynonyms instanceof SdkAutoConstructList);
    }

    public final List<String> truthyCellValueSynonyms() {
        return this.truthyCellValueSynonyms;
    }

    public final String falseyCellValue() {
        return this.falseyCellValue;
    }

    public final boolean hasFalseyCellValueSynonyms() {
        return this.falseyCellValueSynonyms != null && !(this.falseyCellValueSynonyms instanceof SdkAutoConstructList);
    }

    public final List<String> falseyCellValueSynonyms() {
        return this.falseyCellValueSynonyms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.subTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTypeParameters() ? this.typeParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.truthyCellValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTruthyCellValueSynonyms() ? this.truthyCellValueSynonyms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.falseyCellValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFalseyCellValueSynonyms() ? this.falseyCellValueSynonyms() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SemanticType)) {
            return false;
        }
        SemanticType other = (SemanticType)obj;
        return Objects.equals(this.typeName(), other.typeName()) && Objects.equals(this.subTypeName(), other.subTypeName()) && this.hasTypeParameters() == other.hasTypeParameters() && Objects.equals(this.typeParameters(), other.typeParameters()) && Objects.equals(this.truthyCellValue(), other.truthyCellValue()) && this.hasTruthyCellValueSynonyms() == other.hasTruthyCellValueSynonyms() && Objects.equals(this.truthyCellValueSynonyms(), other.truthyCellValueSynonyms()) && Objects.equals(this.falseyCellValue(), other.falseyCellValue()) && this.hasFalseyCellValueSynonyms() == other.hasFalseyCellValueSynonyms() && Objects.equals(this.falseyCellValueSynonyms(), other.falseyCellValueSynonyms());
    }

    public final String toString() {
        return ToString.builder((String)"SemanticType").add("TypeName", (Object)this.typeName()).add("SubTypeName", (Object)this.subTypeName()).add("TypeParameters", this.hasTypeParameters() ? this.typeParameters() : null).add("TruthyCellValue", (Object)(this.truthyCellValue() == null ? null : "*** Sensitive Data Redacted ***")).add("TruthyCellValueSynonyms", (Object)(this.truthyCellValueSynonyms() == null ? null : "*** Sensitive Data Redacted ***")).add("FalseyCellValue", (Object)(this.falseyCellValue() == null ? null : "*** Sensitive Data Redacted ***")).add("FalseyCellValueSynonyms", (Object)(this.falseyCellValueSynonyms() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TypeName": {
                return Optional.ofNullable(clazz.cast(this.typeName()));
            }
            case "SubTypeName": {
                return Optional.ofNullable(clazz.cast(this.subTypeName()));
            }
            case "TypeParameters": {
                return Optional.ofNullable(clazz.cast(this.typeParameters()));
            }
            case "TruthyCellValue": {
                return Optional.ofNullable(clazz.cast(this.truthyCellValue()));
            }
            case "TruthyCellValueSynonyms": {
                return Optional.ofNullable(clazz.cast(this.truthyCellValueSynonyms()));
            }
            case "FalseyCellValue": {
                return Optional.ofNullable(clazz.cast(this.falseyCellValue()));
            }
            case "FalseyCellValueSynonyms": {
                return Optional.ofNullable(clazz.cast(this.falseyCellValueSynonyms()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TypeName", TYPE_NAME_FIELD);
        map.put("SubTypeName", SUB_TYPE_NAME_FIELD);
        map.put("TypeParameters", TYPE_PARAMETERS_FIELD);
        map.put("TruthyCellValue", TRUTHY_CELL_VALUE_FIELD);
        map.put("TruthyCellValueSynonyms", TRUTHY_CELL_VALUE_SYNONYMS_FIELD);
        map.put("FalseyCellValue", FALSEY_CELL_VALUE_FIELD);
        map.put("FalseyCellValueSynonyms", FALSEY_CELL_VALUE_SYNONYMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SemanticType, T> g) {
        return obj -> g.apply((SemanticType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String typeName;
        private String subTypeName;
        private Map<String, String> typeParameters = DefaultSdkAutoConstructMap.getInstance();
        private String truthyCellValue;
        private List<String> truthyCellValueSynonyms = DefaultSdkAutoConstructList.getInstance();
        private String falseyCellValue;
        private List<String> falseyCellValueSynonyms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SemanticType model) {
            this.typeName(model.typeName);
            this.subTypeName(model.subTypeName);
            this.typeParameters(model.typeParameters);
            this.truthyCellValue(model.truthyCellValue);
            this.truthyCellValueSynonyms(model.truthyCellValueSynonyms);
            this.falseyCellValue(model.falseyCellValue);
            this.falseyCellValueSynonyms(model.falseyCellValueSynonyms);
        }

        public final String getTypeName() {
            return this.typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getSubTypeName() {
            return this.subTypeName;
        }

        public final void setSubTypeName(String subTypeName) {
            this.subTypeName = subTypeName;
        }

        @Override
        public final Builder subTypeName(String subTypeName) {
            this.subTypeName = subTypeName;
            return this;
        }

        public final Map<String, String> getTypeParameters() {
            if (this.typeParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.typeParameters;
        }

        public final void setTypeParameters(Map<String, String> typeParameters) {
            this.typeParameters = TypeParametersCopier.copy(typeParameters);
        }

        @Override
        public final Builder typeParameters(Map<String, String> typeParameters) {
            this.typeParameters = TypeParametersCopier.copy(typeParameters);
            return this;
        }

        public final String getTruthyCellValue() {
            return this.truthyCellValue;
        }

        public final void setTruthyCellValue(String truthyCellValue) {
            this.truthyCellValue = truthyCellValue;
        }

        @Override
        public final Builder truthyCellValue(String truthyCellValue) {
            this.truthyCellValue = truthyCellValue;
            return this;
        }

        public final Collection<String> getTruthyCellValueSynonyms() {
            if (this.truthyCellValueSynonyms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.truthyCellValueSynonyms;
        }

        public final void setTruthyCellValueSynonyms(Collection<String> truthyCellValueSynonyms) {
            this.truthyCellValueSynonyms = SensitiveStringListCopier.copy(truthyCellValueSynonyms);
        }

        @Override
        public final Builder truthyCellValueSynonyms(Collection<String> truthyCellValueSynonyms) {
            this.truthyCellValueSynonyms = SensitiveStringListCopier.copy(truthyCellValueSynonyms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder truthyCellValueSynonyms(String ... truthyCellValueSynonyms) {
            this.truthyCellValueSynonyms(Arrays.asList(truthyCellValueSynonyms));
            return this;
        }

        public final String getFalseyCellValue() {
            return this.falseyCellValue;
        }

        public final void setFalseyCellValue(String falseyCellValue) {
            this.falseyCellValue = falseyCellValue;
        }

        @Override
        public final Builder falseyCellValue(String falseyCellValue) {
            this.falseyCellValue = falseyCellValue;
            return this;
        }

        public final Collection<String> getFalseyCellValueSynonyms() {
            if (this.falseyCellValueSynonyms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.falseyCellValueSynonyms;
        }

        public final void setFalseyCellValueSynonyms(Collection<String> falseyCellValueSynonyms) {
            this.falseyCellValueSynonyms = SensitiveStringListCopier.copy(falseyCellValueSynonyms);
        }

        @Override
        public final Builder falseyCellValueSynonyms(Collection<String> falseyCellValueSynonyms) {
            this.falseyCellValueSynonyms = SensitiveStringListCopier.copy(falseyCellValueSynonyms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder falseyCellValueSynonyms(String ... falseyCellValueSynonyms) {
            this.falseyCellValueSynonyms(Arrays.asList(falseyCellValueSynonyms));
            return this;
        }

        public SemanticType build() {
            return new SemanticType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SemanticType> {
        public Builder typeName(String var1);

        public Builder subTypeName(String var1);

        public Builder typeParameters(Map<String, String> var1);

        public Builder truthyCellValue(String var1);

        public Builder truthyCellValueSynonyms(Collection<String> var1);

        public Builder truthyCellValueSynonyms(String ... var1);

        public Builder falseyCellValue(String var1);

        public Builder falseyCellValueSynonyms(Collection<String> var1);

        public Builder falseyCellValueSynonyms(String ... var1);
    }
}

