/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.OtherCategories;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ItemsLimitConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ItemsLimitConfiguration> {
    private static final SdkField<Long> ITEMS_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ItemsLimit").getter(ItemsLimitConfiguration.getter(ItemsLimitConfiguration::itemsLimit)).setter(ItemsLimitConfiguration.setter(Builder::itemsLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemsLimit").build()}).build();
    private static final SdkField<String> OTHER_CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OtherCategories").getter(ItemsLimitConfiguration.getter(ItemsLimitConfiguration::otherCategoriesAsString)).setter(ItemsLimitConfiguration.setter(Builder::otherCategories)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtherCategories").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEMS_LIMIT_FIELD, OTHER_CATEGORIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ItemsLimitConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long itemsLimit;
    private final String otherCategories;

    private ItemsLimitConfiguration(BuilderImpl builder) {
        this.itemsLimit = builder.itemsLimit;
        this.otherCategories = builder.otherCategories;
    }

    public final Long itemsLimit() {
        return this.itemsLimit;
    }

    public final OtherCategories otherCategories() {
        return OtherCategories.fromValue(this.otherCategories);
    }

    public final String otherCategoriesAsString() {
        return this.otherCategories;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.itemsLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.otherCategoriesAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ItemsLimitConfiguration)) {
            return false;
        }
        ItemsLimitConfiguration other = (ItemsLimitConfiguration)obj;
        return Objects.equals(this.itemsLimit(), other.itemsLimit()) && Objects.equals(this.otherCategoriesAsString(), other.otherCategoriesAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ItemsLimitConfiguration").add("ItemsLimit", (Object)this.itemsLimit()).add("OtherCategories", (Object)this.otherCategoriesAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ItemsLimit": {
                return Optional.ofNullable(clazz.cast(this.itemsLimit()));
            }
            case "OtherCategories": {
                return Optional.ofNullable(clazz.cast(this.otherCategoriesAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ItemsLimit", ITEMS_LIMIT_FIELD);
        map.put("OtherCategories", OTHER_CATEGORIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ItemsLimitConfiguration, T> g) {
        return obj -> g.apply((ItemsLimitConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long itemsLimit;
        private String otherCategories;

        private BuilderImpl() {
        }

        private BuilderImpl(ItemsLimitConfiguration model) {
            this.itemsLimit(model.itemsLimit);
            this.otherCategories(model.otherCategories);
        }

        public final Long getItemsLimit() {
            return this.itemsLimit;
        }

        public final void setItemsLimit(Long itemsLimit) {
            this.itemsLimit = itemsLimit;
        }

        @Override
        public final Builder itemsLimit(Long itemsLimit) {
            this.itemsLimit = itemsLimit;
            return this;
        }

        public final String getOtherCategories() {
            return this.otherCategories;
        }

        public final void setOtherCategories(String otherCategories) {
            this.otherCategories = otherCategories;
        }

        @Override
        public final Builder otherCategories(String otherCategories) {
            this.otherCategories = otherCategories;
            return this;
        }

        @Override
        public final Builder otherCategories(OtherCategories otherCategories) {
            this.otherCategories(otherCategories == null ? null : otherCategories.toString());
            return this;
        }

        public ItemsLimitConfiguration build() {
            return new ItemsLimitConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ItemsLimitConfiguration> {
        public Builder itemsLimit(Long var1);

        public Builder otherCategories(String var1);

        public Builder otherCategories(OtherCategories var1);
    }
}

