/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.JoinOperandProperties;
import software.amazon.awssdk.services.quicksight.model.JoinOperationType;
import software.amazon.awssdk.services.quicksight.model.TransformOperationSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JoinOperation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JoinOperation> {
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Alias").getter(JoinOperation.getter(JoinOperation::alias)).setter(JoinOperation.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()}).build();
    private static final SdkField<TransformOperationSource> LEFT_OPERAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LeftOperand").getter(JoinOperation.getter(JoinOperation::leftOperand)).setter(JoinOperation.setter(Builder::leftOperand)).constructor(TransformOperationSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LeftOperand").build()}).build();
    private static final SdkField<TransformOperationSource> RIGHT_OPERAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RightOperand").getter(JoinOperation.getter(JoinOperation::rightOperand)).setter(JoinOperation.setter(Builder::rightOperand)).constructor(TransformOperationSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RightOperand").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(JoinOperation.getter(JoinOperation::typeAsString)).setter(JoinOperation.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> ON_CLAUSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OnClause").getter(JoinOperation.getter(JoinOperation::onClause)).setter(JoinOperation.setter(Builder::onClause)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnClause").build()}).build();
    private static final SdkField<JoinOperandProperties> LEFT_OPERAND_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LeftOperandProperties").getter(JoinOperation.getter(JoinOperation::leftOperandProperties)).setter(JoinOperation.setter(Builder::leftOperandProperties)).constructor(JoinOperandProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LeftOperandProperties").build()}).build();
    private static final SdkField<JoinOperandProperties> RIGHT_OPERAND_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RightOperandProperties").getter(JoinOperation.getter(JoinOperation::rightOperandProperties)).setter(JoinOperation.setter(Builder::rightOperandProperties)).constructor(JoinOperandProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RightOperandProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_FIELD, LEFT_OPERAND_FIELD, RIGHT_OPERAND_FIELD, TYPE_FIELD, ON_CLAUSE_FIELD, LEFT_OPERAND_PROPERTIES_FIELD, RIGHT_OPERAND_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = JoinOperation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String alias;
    private final TransformOperationSource leftOperand;
    private final TransformOperationSource rightOperand;
    private final String type;
    private final String onClause;
    private final JoinOperandProperties leftOperandProperties;
    private final JoinOperandProperties rightOperandProperties;

    private JoinOperation(BuilderImpl builder) {
        this.alias = builder.alias;
        this.leftOperand = builder.leftOperand;
        this.rightOperand = builder.rightOperand;
        this.type = builder.type;
        this.onClause = builder.onClause;
        this.leftOperandProperties = builder.leftOperandProperties;
        this.rightOperandProperties = builder.rightOperandProperties;
    }

    public final String alias() {
        return this.alias;
    }

    public final TransformOperationSource leftOperand() {
        return this.leftOperand;
    }

    public final TransformOperationSource rightOperand() {
        return this.rightOperand;
    }

    public final JoinOperationType type() {
        return JoinOperationType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String onClause() {
        return this.onClause;
    }

    public final JoinOperandProperties leftOperandProperties() {
        return this.leftOperandProperties;
    }

    public final JoinOperandProperties rightOperandProperties() {
        return this.rightOperandProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        hashCode = 31 * hashCode + Objects.hashCode(this.leftOperand());
        hashCode = 31 * hashCode + Objects.hashCode(this.rightOperand());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.onClause());
        hashCode = 31 * hashCode + Objects.hashCode(this.leftOperandProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.rightOperandProperties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JoinOperation)) {
            return false;
        }
        JoinOperation other = (JoinOperation)obj;
        return Objects.equals(this.alias(), other.alias()) && Objects.equals(this.leftOperand(), other.leftOperand()) && Objects.equals(this.rightOperand(), other.rightOperand()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.onClause(), other.onClause()) && Objects.equals(this.leftOperandProperties(), other.leftOperandProperties()) && Objects.equals(this.rightOperandProperties(), other.rightOperandProperties());
    }

    public final String toString() {
        return ToString.builder((String)"JoinOperation").add("Alias", (Object)this.alias()).add("LeftOperand", (Object)this.leftOperand()).add("RightOperand", (Object)this.rightOperand()).add("Type", (Object)this.typeAsString()).add("OnClause", (Object)(this.onClause() == null ? null : "*** Sensitive Data Redacted ***")).add("LeftOperandProperties", (Object)this.leftOperandProperties()).add("RightOperandProperties", (Object)this.rightOperandProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
            case "LeftOperand": {
                return Optional.ofNullable(clazz.cast(this.leftOperand()));
            }
            case "RightOperand": {
                return Optional.ofNullable(clazz.cast(this.rightOperand()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "OnClause": {
                return Optional.ofNullable(clazz.cast(this.onClause()));
            }
            case "LeftOperandProperties": {
                return Optional.ofNullable(clazz.cast(this.leftOperandProperties()));
            }
            case "RightOperandProperties": {
                return Optional.ofNullable(clazz.cast(this.rightOperandProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Alias", ALIAS_FIELD);
        map.put("LeftOperand", LEFT_OPERAND_FIELD);
        map.put("RightOperand", RIGHT_OPERAND_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("OnClause", ON_CLAUSE_FIELD);
        map.put("LeftOperandProperties", LEFT_OPERAND_PROPERTIES_FIELD);
        map.put("RightOperandProperties", RIGHT_OPERAND_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JoinOperation, T> g) {
        return obj -> g.apply((JoinOperation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String alias;
        private TransformOperationSource leftOperand;
        private TransformOperationSource rightOperand;
        private String type;
        private String onClause;
        private JoinOperandProperties leftOperandProperties;
        private JoinOperandProperties rightOperandProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(JoinOperation model) {
            this.alias(model.alias);
            this.leftOperand(model.leftOperand);
            this.rightOperand(model.rightOperand);
            this.type(model.type);
            this.onClause(model.onClause);
            this.leftOperandProperties(model.leftOperandProperties);
            this.rightOperandProperties(model.rightOperandProperties);
        }

        public final String getAlias() {
            return this.alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final TransformOperationSource.Builder getLeftOperand() {
            return this.leftOperand != null ? this.leftOperand.toBuilder() : null;
        }

        public final void setLeftOperand(TransformOperationSource.BuilderImpl leftOperand) {
            this.leftOperand = leftOperand != null ? leftOperand.build() : null;
        }

        @Override
        public final Builder leftOperand(TransformOperationSource leftOperand) {
            this.leftOperand = leftOperand;
            return this;
        }

        public final TransformOperationSource.Builder getRightOperand() {
            return this.rightOperand != null ? this.rightOperand.toBuilder() : null;
        }

        public final void setRightOperand(TransformOperationSource.BuilderImpl rightOperand) {
            this.rightOperand = rightOperand != null ? rightOperand.build() : null;
        }

        @Override
        public final Builder rightOperand(TransformOperationSource rightOperand) {
            this.rightOperand = rightOperand;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(JoinOperationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getOnClause() {
            return this.onClause;
        }

        public final void setOnClause(String onClause) {
            this.onClause = onClause;
        }

        @Override
        public final Builder onClause(String onClause) {
            this.onClause = onClause;
            return this;
        }

        public final JoinOperandProperties.Builder getLeftOperandProperties() {
            return this.leftOperandProperties != null ? this.leftOperandProperties.toBuilder() : null;
        }

        public final void setLeftOperandProperties(JoinOperandProperties.BuilderImpl leftOperandProperties) {
            this.leftOperandProperties = leftOperandProperties != null ? leftOperandProperties.build() : null;
        }

        @Override
        public final Builder leftOperandProperties(JoinOperandProperties leftOperandProperties) {
            this.leftOperandProperties = leftOperandProperties;
            return this;
        }

        public final JoinOperandProperties.Builder getRightOperandProperties() {
            return this.rightOperandProperties != null ? this.rightOperandProperties.toBuilder() : null;
        }

        public final void setRightOperandProperties(JoinOperandProperties.BuilderImpl rightOperandProperties) {
            this.rightOperandProperties = rightOperandProperties != null ? rightOperandProperties.build() : null;
        }

        @Override
        public final Builder rightOperandProperties(JoinOperandProperties rightOperandProperties) {
            this.rightOperandProperties = rightOperandProperties;
            return this;
        }

        public JoinOperation build() {
            return new JoinOperation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JoinOperation> {
        public Builder alias(String var1);

        public Builder leftOperand(TransformOperationSource var1);

        default public Builder leftOperand(Consumer<TransformOperationSource.Builder> leftOperand) {
            return this.leftOperand((TransformOperationSource)((TransformOperationSource.Builder)TransformOperationSource.builder().applyMutation(leftOperand)).build());
        }

        public Builder rightOperand(TransformOperationSource var1);

        default public Builder rightOperand(Consumer<TransformOperationSource.Builder> rightOperand) {
            return this.rightOperand((TransformOperationSource)((TransformOperationSource.Builder)TransformOperationSource.builder().applyMutation(rightOperand)).build());
        }

        public Builder type(String var1);

        public Builder type(JoinOperationType var1);

        public Builder onClause(String var1);

        public Builder leftOperandProperties(JoinOperandProperties var1);

        default public Builder leftOperandProperties(Consumer<JoinOperandProperties.Builder> leftOperandProperties) {
            return this.leftOperandProperties((JoinOperandProperties)((JoinOperandProperties.Builder)JoinOperandProperties.builder().applyMutation(leftOperandProperties)).build());
        }

        public Builder rightOperandProperties(JoinOperandProperties var1);

        default public Builder rightOperandProperties(Consumer<JoinOperandProperties.Builder> rightOperandProperties) {
            return this.rightOperandProperties((JoinOperandProperties)((JoinOperandProperties.Builder)JoinOperandProperties.builder().applyMutation(rightOperandProperties)).build());
        }
    }
}

