/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KeyPairCredentials
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KeyPairCredentials> {
    private static final SdkField<String> KEY_PAIR_USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyPairUsername").getter(KeyPairCredentials.getter(KeyPairCredentials::keyPairUsername)).setter(KeyPairCredentials.setter(Builder::keyPairUsername)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPairUsername").build()}).build();
    private static final SdkField<String> PRIVATE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivateKey").getter(KeyPairCredentials.getter(KeyPairCredentials::privateKey)).setter(KeyPairCredentials.setter(Builder::privateKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateKey").build()}).build();
    private static final SdkField<String> PRIVATE_KEY_PASSPHRASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivateKeyPassphrase").getter(KeyPairCredentials.getter(KeyPairCredentials::privateKeyPassphrase)).setter(KeyPairCredentials.setter(Builder::privateKeyPassphrase)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateKeyPassphrase").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_PAIR_USERNAME_FIELD, PRIVATE_KEY_FIELD, PRIVATE_KEY_PASSPHRASE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KeyPairCredentials.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String keyPairUsername;
    private final String privateKey;
    private final String privateKeyPassphrase;

    private KeyPairCredentials(BuilderImpl builder) {
        this.keyPairUsername = builder.keyPairUsername;
        this.privateKey = builder.privateKey;
        this.privateKeyPassphrase = builder.privateKeyPassphrase;
    }

    public final String keyPairUsername() {
        return this.keyPairUsername;
    }

    public final String privateKey() {
        return this.privateKey;
    }

    public final String privateKeyPassphrase() {
        return this.privateKeyPassphrase;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPairUsername());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateKeyPassphrase());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyPairCredentials)) {
            return false;
        }
        KeyPairCredentials other = (KeyPairCredentials)obj;
        return Objects.equals(this.keyPairUsername(), other.keyPairUsername()) && Objects.equals(this.privateKey(), other.privateKey()) && Objects.equals(this.privateKeyPassphrase(), other.privateKeyPassphrase());
    }

    public final String toString() {
        return ToString.builder((String)"KeyPairCredentials").add("KeyPairUsername", (Object)this.keyPairUsername()).add("PrivateKey", (Object)(this.privateKey() == null ? null : "*** Sensitive Data Redacted ***")).add("PrivateKeyPassphrase", (Object)(this.privateKeyPassphrase() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyPairUsername": {
                return Optional.ofNullable(clazz.cast(this.keyPairUsername()));
            }
            case "PrivateKey": {
                return Optional.ofNullable(clazz.cast(this.privateKey()));
            }
            case "PrivateKeyPassphrase": {
                return Optional.ofNullable(clazz.cast(this.privateKeyPassphrase()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("KeyPairUsername", KEY_PAIR_USERNAME_FIELD);
        map.put("PrivateKey", PRIVATE_KEY_FIELD);
        map.put("PrivateKeyPassphrase", PRIVATE_KEY_PASSPHRASE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KeyPairCredentials, T> g) {
        return obj -> g.apply((KeyPairCredentials)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String keyPairUsername;
        private String privateKey;
        private String privateKeyPassphrase;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyPairCredentials model) {
            this.keyPairUsername(model.keyPairUsername);
            this.privateKey(model.privateKey);
            this.privateKeyPassphrase(model.privateKeyPassphrase);
        }

        public final String getKeyPairUsername() {
            return this.keyPairUsername;
        }

        public final void setKeyPairUsername(String keyPairUsername) {
            this.keyPairUsername = keyPairUsername;
        }

        @Override
        public final Builder keyPairUsername(String keyPairUsername) {
            this.keyPairUsername = keyPairUsername;
            return this;
        }

        public final String getPrivateKey() {
            return this.privateKey;
        }

        public final void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        @Override
        public final Builder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public final String getPrivateKeyPassphrase() {
            return this.privateKeyPassphrase;
        }

        public final void setPrivateKeyPassphrase(String privateKeyPassphrase) {
            this.privateKeyPassphrase = privateKeyPassphrase;
        }

        @Override
        public final Builder privateKeyPassphrase(String privateKeyPassphrase) {
            this.privateKeyPassphrase = privateKeyPassphrase;
            return this;
        }

        public KeyPairCredentials build() {
            return new KeyPairCredentials(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KeyPairCredentials> {
        public Builder keyPairUsername(String var1);

        public Builder privateKey(String var1);

        public Builder privateKeyPassphrase(String var1);
    }
}

