/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.LabelOptions;
import software.amazon.awssdk.services.quicksight.model.SheetControlInfoIconLabelOptions;
import software.amazon.awssdk.services.quicksight.model.TextControlPlaceholderOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TextAreaControlDisplayOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TextAreaControlDisplayOptions> {
    private static final SdkField<LabelOptions> TITLE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TitleOptions").getter(TextAreaControlDisplayOptions.getter(TextAreaControlDisplayOptions::titleOptions)).setter(TextAreaControlDisplayOptions.setter(Builder::titleOptions)).constructor(LabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TitleOptions").build()}).build();
    private static final SdkField<TextControlPlaceholderOptions> PLACEHOLDER_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PlaceholderOptions").getter(TextAreaControlDisplayOptions.getter(TextAreaControlDisplayOptions::placeholderOptions)).setter(TextAreaControlDisplayOptions.setter(Builder::placeholderOptions)).constructor(TextControlPlaceholderOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaceholderOptions").build()}).build();
    private static final SdkField<SheetControlInfoIconLabelOptions> INFO_ICON_LABEL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InfoIconLabelOptions").getter(TextAreaControlDisplayOptions.getter(TextAreaControlDisplayOptions::infoIconLabelOptions)).setter(TextAreaControlDisplayOptions.setter(Builder::infoIconLabelOptions)).constructor(SheetControlInfoIconLabelOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InfoIconLabelOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_OPTIONS_FIELD, PLACEHOLDER_OPTIONS_FIELD, INFO_ICON_LABEL_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TextAreaControlDisplayOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final LabelOptions titleOptions;
    private final TextControlPlaceholderOptions placeholderOptions;
    private final SheetControlInfoIconLabelOptions infoIconLabelOptions;

    private TextAreaControlDisplayOptions(BuilderImpl builder) {
        this.titleOptions = builder.titleOptions;
        this.placeholderOptions = builder.placeholderOptions;
        this.infoIconLabelOptions = builder.infoIconLabelOptions;
    }

    public final LabelOptions titleOptions() {
        return this.titleOptions;
    }

    public final TextControlPlaceholderOptions placeholderOptions() {
        return this.placeholderOptions;
    }

    public final SheetControlInfoIconLabelOptions infoIconLabelOptions() {
        return this.infoIconLabelOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.titleOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.placeholderOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.infoIconLabelOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextAreaControlDisplayOptions)) {
            return false;
        }
        TextAreaControlDisplayOptions other = (TextAreaControlDisplayOptions)obj;
        return Objects.equals(this.titleOptions(), other.titleOptions()) && Objects.equals(this.placeholderOptions(), other.placeholderOptions()) && Objects.equals(this.infoIconLabelOptions(), other.infoIconLabelOptions());
    }

    public final String toString() {
        return ToString.builder((String)"TextAreaControlDisplayOptions").add("TitleOptions", (Object)this.titleOptions()).add("PlaceholderOptions", (Object)this.placeholderOptions()).add("InfoIconLabelOptions", (Object)this.infoIconLabelOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TitleOptions": {
                return Optional.ofNullable(clazz.cast(this.titleOptions()));
            }
            case "PlaceholderOptions": {
                return Optional.ofNullable(clazz.cast(this.placeholderOptions()));
            }
            case "InfoIconLabelOptions": {
                return Optional.ofNullable(clazz.cast(this.infoIconLabelOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TitleOptions", TITLE_OPTIONS_FIELD);
        map.put("PlaceholderOptions", PLACEHOLDER_OPTIONS_FIELD);
        map.put("InfoIconLabelOptions", INFO_ICON_LABEL_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TextAreaControlDisplayOptions, T> g) {
        return obj -> g.apply((TextAreaControlDisplayOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private LabelOptions titleOptions;
        private TextControlPlaceholderOptions placeholderOptions;
        private SheetControlInfoIconLabelOptions infoIconLabelOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(TextAreaControlDisplayOptions model) {
            this.titleOptions(model.titleOptions);
            this.placeholderOptions(model.placeholderOptions);
            this.infoIconLabelOptions(model.infoIconLabelOptions);
        }

        public final LabelOptions.Builder getTitleOptions() {
            return this.titleOptions != null ? this.titleOptions.toBuilder() : null;
        }

        public final void setTitleOptions(LabelOptions.BuilderImpl titleOptions) {
            this.titleOptions = titleOptions != null ? titleOptions.build() : null;
        }

        @Override
        public final Builder titleOptions(LabelOptions titleOptions) {
            this.titleOptions = titleOptions;
            return this;
        }

        public final TextControlPlaceholderOptions.Builder getPlaceholderOptions() {
            return this.placeholderOptions != null ? this.placeholderOptions.toBuilder() : null;
        }

        public final void setPlaceholderOptions(TextControlPlaceholderOptions.BuilderImpl placeholderOptions) {
            this.placeholderOptions = placeholderOptions != null ? placeholderOptions.build() : null;
        }

        @Override
        public final Builder placeholderOptions(TextControlPlaceholderOptions placeholderOptions) {
            this.placeholderOptions = placeholderOptions;
            return this;
        }

        public final SheetControlInfoIconLabelOptions.Builder getInfoIconLabelOptions() {
            return this.infoIconLabelOptions != null ? this.infoIconLabelOptions.toBuilder() : null;
        }

        public final void setInfoIconLabelOptions(SheetControlInfoIconLabelOptions.BuilderImpl infoIconLabelOptions) {
            this.infoIconLabelOptions = infoIconLabelOptions != null ? infoIconLabelOptions.build() : null;
        }

        @Override
        public final Builder infoIconLabelOptions(SheetControlInfoIconLabelOptions infoIconLabelOptions) {
            this.infoIconLabelOptions = infoIconLabelOptions;
            return this;
        }

        public TextAreaControlDisplayOptions build() {
            return new TextAreaControlDisplayOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TextAreaControlDisplayOptions> {
        public Builder titleOptions(LabelOptions var1);

        default public Builder titleOptions(Consumer<LabelOptions.Builder> titleOptions) {
            return this.titleOptions((LabelOptions)((LabelOptions.Builder)LabelOptions.builder().applyMutation(titleOptions)).build());
        }

        public Builder placeholderOptions(TextControlPlaceholderOptions var1);

        default public Builder placeholderOptions(Consumer<TextControlPlaceholderOptions.Builder> placeholderOptions) {
            return this.placeholderOptions((TextControlPlaceholderOptions)((TextControlPlaceholderOptions.Builder)TextControlPlaceholderOptions.builder().applyMutation(placeholderOptions)).build());
        }

        public Builder infoIconLabelOptions(SheetControlInfoIconLabelOptions var1);

        default public Builder infoIconLabelOptions(Consumer<SheetControlInfoIconLabelOptions.Builder> infoIconLabelOptions) {
            return this.infoIconLabelOptions((SheetControlInfoIconLabelOptions)((SheetControlInfoIconLabelOptions.Builder)SheetControlInfoIconLabelOptions.builder().applyMutation(infoIconLabelOptions)).build());
        }
    }
}

