/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.AuthConfig;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateActionConnectorRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, UpdateActionConnectorRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(UpdateActionConnectorRequest.getter(UpdateActionConnectorRequest::awsAccountId)).setter(UpdateActionConnectorRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> ACTION_CONNECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActionConnectorId").getter(UpdateActionConnectorRequest.getter(UpdateActionConnectorRequest::actionConnectorId)).setter(UpdateActionConnectorRequest.setter(Builder::actionConnectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ActionConnectorId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateActionConnectorRequest.getter(UpdateActionConnectorRequest::name)).setter(UpdateActionConnectorRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<AuthConfig> AUTHENTICATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AuthenticationConfig").getter(UpdateActionConnectorRequest.getter(UpdateActionConnectorRequest::authenticationConfig)).setter(UpdateActionConnectorRequest.setter(Builder::authenticationConfig)).constructor(AuthConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationConfig").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateActionConnectorRequest.getter(UpdateActionConnectorRequest::description)).setter(UpdateActionConnectorRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> VPC_CONNECTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcConnectionArn").getter(UpdateActionConnectorRequest.getter(UpdateActionConnectorRequest::vpcConnectionArn)).setter(UpdateActionConnectorRequest.setter(Builder::vpcConnectionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConnectionArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, ACTION_CONNECTOR_ID_FIELD, NAME_FIELD, AUTHENTICATION_CONFIG_FIELD, DESCRIPTION_FIELD, VPC_CONNECTION_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateActionConnectorRequest.memberNameToFieldInitializer();
    private final String awsAccountId;
    private final String actionConnectorId;
    private final String name;
    private final AuthConfig authenticationConfig;
    private final String description;
    private final String vpcConnectionArn;

    private UpdateActionConnectorRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.actionConnectorId = builder.actionConnectorId;
        this.name = builder.name;
        this.authenticationConfig = builder.authenticationConfig;
        this.description = builder.description;
        this.vpcConnectionArn = builder.vpcConnectionArn;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String actionConnectorId() {
        return this.actionConnectorId;
    }

    public final String name() {
        return this.name;
    }

    public final AuthConfig authenticationConfig() {
        return this.authenticationConfig;
    }

    public final String description() {
        return this.description;
    }

    public final String vpcConnectionArn() {
        return this.vpcConnectionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionConnectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConnectionArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateActionConnectorRequest)) {
            return false;
        }
        UpdateActionConnectorRequest other = (UpdateActionConnectorRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.actionConnectorId(), other.actionConnectorId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.authenticationConfig(), other.authenticationConfig()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.vpcConnectionArn(), other.vpcConnectionArn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateActionConnectorRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("ActionConnectorId", (Object)this.actionConnectorId()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("AuthenticationConfig", (Object)this.authenticationConfig()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("VpcConnectionArn", (Object)this.vpcConnectionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "ActionConnectorId": {
                return Optional.ofNullable(clazz.cast(this.actionConnectorId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "AuthenticationConfig": {
                return Optional.ofNullable(clazz.cast(this.authenticationConfig()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "VpcConnectionArn": {
                return Optional.ofNullable(clazz.cast(this.vpcConnectionArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AwsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("ActionConnectorId", ACTION_CONNECTOR_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("AuthenticationConfig", AUTHENTICATION_CONFIG_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("VpcConnectionArn", VPC_CONNECTION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateActionConnectorRequest, T> g) {
        return obj -> g.apply((UpdateActionConnectorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String actionConnectorId;
        private String name;
        private AuthConfig authenticationConfig;
        private String description;
        private String vpcConnectionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateActionConnectorRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.actionConnectorId(model.actionConnectorId);
            this.name(model.name);
            this.authenticationConfig(model.authenticationConfig);
            this.description(model.description);
            this.vpcConnectionArn(model.vpcConnectionArn);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getActionConnectorId() {
            return this.actionConnectorId;
        }

        public final void setActionConnectorId(String actionConnectorId) {
            this.actionConnectorId = actionConnectorId;
        }

        @Override
        public final Builder actionConnectorId(String actionConnectorId) {
            this.actionConnectorId = actionConnectorId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final AuthConfig.Builder getAuthenticationConfig() {
            return this.authenticationConfig != null ? this.authenticationConfig.toBuilder() : null;
        }

        public final void setAuthenticationConfig(AuthConfig.BuilderImpl authenticationConfig) {
            this.authenticationConfig = authenticationConfig != null ? authenticationConfig.build() : null;
        }

        @Override
        public final Builder authenticationConfig(AuthConfig authenticationConfig) {
            this.authenticationConfig = authenticationConfig;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getVpcConnectionArn() {
            return this.vpcConnectionArn;
        }

        public final void setVpcConnectionArn(String vpcConnectionArn) {
            this.vpcConnectionArn = vpcConnectionArn;
        }

        @Override
        public final Builder vpcConnectionArn(String vpcConnectionArn) {
            this.vpcConnectionArn = vpcConnectionArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateActionConnectorRequest build() {
            return new UpdateActionConnectorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateActionConnectorRequest> {
        public Builder awsAccountId(String var1);

        public Builder actionConnectorId(String var1);

        public Builder name(String var1);

        public Builder authenticationConfig(AuthConfig var1);

        default public Builder authenticationConfig(Consumer<AuthConfig.Builder> authenticationConfig) {
            return this.authenticationConfig((AuthConfig)((AuthConfig.Builder)AuthConfig.builder().applyMutation(authenticationConfig)).build());
        }

        public Builder description(String var1);

        public Builder vpcConnectionArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

