/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.DescribeFolderPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeFolderPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.ResourcePermission;

public class DescribeFolderPermissionsIterable
implements SdkIterable<DescribeFolderPermissionsResponse> {
    private final QuickSightClient client;
    private final DescribeFolderPermissionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeFolderPermissionsIterable(QuickSightClient client, DescribeFolderPermissionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeFolderPermissionsResponseFetcher();
    }

    public Iterator<DescribeFolderPermissionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ResourcePermission> permissions() {
        Function<DescribeFolderPermissionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.permissions() != null) {
                return response.permissions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeFolderPermissionsResponseFetcher
    implements SyncPageFetcher<DescribeFolderPermissionsResponse> {
        private DescribeFolderPermissionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeFolderPermissionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeFolderPermissionsResponse nextPage(DescribeFolderPermissionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeFolderPermissionsIterable.this.client.describeFolderPermissions(DescribeFolderPermissionsIterable.this.firstRequest);
            }
            return DescribeFolderPermissionsIterable.this.client.describeFolderPermissions((DescribeFolderPermissionsRequest)((Object)DescribeFolderPermissionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

