/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.ActionConnectorSummary;
import software.amazon.awssdk.services.quicksight.model.ListActionConnectorsRequest;
import software.amazon.awssdk.services.quicksight.model.ListActionConnectorsResponse;

public class ListActionConnectorsIterable
implements SdkIterable<ListActionConnectorsResponse> {
    private final QuickSightClient client;
    private final ListActionConnectorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListActionConnectorsIterable(QuickSightClient client, ListActionConnectorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListActionConnectorsResponseFetcher();
    }

    public Iterator<ListActionConnectorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ActionConnectorSummary> actionConnectorSummaries() {
        Function<ListActionConnectorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.actionConnectorSummaries() != null) {
                return response.actionConnectorSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListActionConnectorsResponseFetcher
    implements SyncPageFetcher<ListActionConnectorsResponse> {
        private ListActionConnectorsResponseFetcher() {
        }

        public boolean hasNextPage(ListActionConnectorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListActionConnectorsResponse nextPage(ListActionConnectorsResponse previousPage) {
            if (previousPage == null) {
                return ListActionConnectorsIterable.this.client.listActionConnectors(ListActionConnectorsIterable.this.firstRequest);
            }
            return ListActionConnectorsIterable.this.client.listActionConnectors((ListActionConnectorsRequest)((Object)ListActionConnectorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

