/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.FlowSummary;
import software.amazon.awssdk.services.quicksight.model.ListFlowsRequest;
import software.amazon.awssdk.services.quicksight.model.ListFlowsResponse;

public class ListFlowsIterable
implements SdkIterable<ListFlowsResponse> {
    private final QuickSightClient client;
    private final ListFlowsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFlowsIterable(QuickSightClient client, ListFlowsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFlowsResponseFetcher();
    }

    public Iterator<ListFlowsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FlowSummary> flowSummaryList() {
        Function<ListFlowsResponse, Iterator> getIterator = response -> {
            if (response != null && response.flowSummaryList() != null) {
                return response.flowSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFlowsResponseFetcher
    implements SyncPageFetcher<ListFlowsResponse> {
        private ListFlowsResponseFetcher() {
        }

        public boolean hasNextPage(ListFlowsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFlowsResponse nextPage(ListFlowsResponse previousPage) {
            if (previousPage == null) {
                return ListFlowsIterable.this.client.listFlows(ListFlowsIterable.this.firstRequest);
            }
            return ListFlowsIterable.this.client.listFlows((ListFlowsRequest)((Object)ListFlowsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

