/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ram.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ram.model.RamRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPermissionRequest
extends RamRequest
implements ToCopyableBuilder<Builder, GetPermissionRequest> {
    private static final SdkField<String> PERMISSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("permissionArn").getter(GetPermissionRequest.getter(GetPermissionRequest::permissionArn)).setter(GetPermissionRequest.setter(Builder::permissionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionArn").build()}).build();
    private static final SdkField<Integer> PERMISSION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("permissionVersion").getter(GetPermissionRequest.getter(GetPermissionRequest::permissionVersion)).setter(GetPermissionRequest.setter(Builder::permissionVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("permissionVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERMISSION_ARN_FIELD, PERMISSION_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetPermissionRequest.memberNameToFieldInitializer();
    private final String permissionArn;
    private final Integer permissionVersion;

    private GetPermissionRequest(BuilderImpl builder) {
        super(builder);
        this.permissionArn = builder.permissionArn;
        this.permissionVersion = builder.permissionVersion;
    }

    public final String permissionArn() {
        return this.permissionArn;
    }

    public final Integer permissionVersion() {
        return this.permissionVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPermissionRequest)) {
            return false;
        }
        GetPermissionRequest other = (GetPermissionRequest)((Object)obj);
        return Objects.equals(this.permissionArn(), other.permissionArn()) && Objects.equals(this.permissionVersion(), other.permissionVersion());
    }

    public final String toString() {
        return ToString.builder((String)"GetPermissionRequest").add("PermissionArn", (Object)this.permissionArn()).add("PermissionVersion", (Object)this.permissionVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "permissionArn": {
                return Optional.ofNullable(clazz.cast(this.permissionArn()));
            }
            case "permissionVersion": {
                return Optional.ofNullable(clazz.cast(this.permissionVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("permissionArn", PERMISSION_ARN_FIELD);
        map.put("permissionVersion", PERMISSION_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPermissionRequest, T> g) {
        return obj -> g.apply((GetPermissionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RamRequest.BuilderImpl
    implements Builder {
        private String permissionArn;
        private Integer permissionVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPermissionRequest model) {
            super(model);
            this.permissionArn(model.permissionArn);
            this.permissionVersion(model.permissionVersion);
        }

        public final String getPermissionArn() {
            return this.permissionArn;
        }

        public final void setPermissionArn(String permissionArn) {
            this.permissionArn = permissionArn;
        }

        @Override
        public final Builder permissionArn(String permissionArn) {
            this.permissionArn = permissionArn;
            return this;
        }

        public final Integer getPermissionVersion() {
            return this.permissionVersion;
        }

        public final void setPermissionVersion(Integer permissionVersion) {
            this.permissionVersion = permissionVersion;
        }

        @Override
        public final Builder permissionVersion(Integer permissionVersion) {
            this.permissionVersion = permissionVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetPermissionRequest build() {
            return new GetPermissionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPermissionRequest> {
        public Builder permissionArn(String var1);

        public Builder permissionVersion(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

