/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rdsdata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rdsdata.model.ColumnMetadata;
import software.amazon.awssdk.services.rdsdata.model.MetadataCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResultSetMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResultSetMetadata> {
    private static final SdkField<Long> COLUMN_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("columnCount").getter(ResultSetMetadata.getter(ResultSetMetadata::columnCount)).setter(ResultSetMetadata.setter(Builder::columnCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnCount").build()}).build();
    private static final SdkField<List<ColumnMetadata>> COLUMN_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("columnMetadata").getter(ResultSetMetadata.getter(ResultSetMetadata::columnMetadata)).setter(ResultSetMetadata.setter(Builder::columnMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("columnMetadata").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_COUNT_FIELD, COLUMN_METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResultSetMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long columnCount;
    private final List<ColumnMetadata> columnMetadata;

    private ResultSetMetadata(BuilderImpl builder) {
        this.columnCount = builder.columnCount;
        this.columnMetadata = builder.columnMetadata;
    }

    public final Long columnCount() {
        return this.columnCount;
    }

    public final boolean hasColumnMetadata() {
        return this.columnMetadata != null && !(this.columnMetadata instanceof SdkAutoConstructList);
    }

    public final List<ColumnMetadata> columnMetadata() {
        return this.columnMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.columnCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumnMetadata() ? this.columnMetadata() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultSetMetadata)) {
            return false;
        }
        ResultSetMetadata other = (ResultSetMetadata)obj;
        return Objects.equals(this.columnCount(), other.columnCount()) && this.hasColumnMetadata() == other.hasColumnMetadata() && Objects.equals(this.columnMetadata(), other.columnMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"ResultSetMetadata").add("ColumnCount", (Object)this.columnCount()).add("ColumnMetadata", this.hasColumnMetadata() ? this.columnMetadata() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "columnCount": {
                return Optional.ofNullable(clazz.cast(this.columnCount()));
            }
            case "columnMetadata": {
                return Optional.ofNullable(clazz.cast(this.columnMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("columnCount", COLUMN_COUNT_FIELD);
        map.put("columnMetadata", COLUMN_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResultSetMetadata, T> g) {
        return obj -> g.apply((ResultSetMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long columnCount;
        private List<ColumnMetadata> columnMetadata = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResultSetMetadata model) {
            this.columnCount(model.columnCount);
            this.columnMetadata(model.columnMetadata);
        }

        public final Long getColumnCount() {
            return this.columnCount;
        }

        public final void setColumnCount(Long columnCount) {
            this.columnCount = columnCount;
        }

        @Override
        public final Builder columnCount(Long columnCount) {
            this.columnCount = columnCount;
            return this;
        }

        public final List<ColumnMetadata.Builder> getColumnMetadata() {
            List<ColumnMetadata.Builder> result = MetadataCopier.copyToBuilder(this.columnMetadata);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumnMetadata(Collection<ColumnMetadata.BuilderImpl> columnMetadata) {
            this.columnMetadata = MetadataCopier.copyFromBuilder(columnMetadata);
        }

        @Override
        public final Builder columnMetadata(Collection<ColumnMetadata> columnMetadata) {
            this.columnMetadata = MetadataCopier.copy(columnMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnMetadata(ColumnMetadata ... columnMetadata) {
            this.columnMetadata(Arrays.asList(columnMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnMetadata(Consumer<ColumnMetadata.Builder> ... columnMetadata) {
            this.columnMetadata(Stream.of(columnMetadata).map(c -> (ColumnMetadata)((ColumnMetadata.Builder)ColumnMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ResultSetMetadata build() {
            return new ResultSetMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResultSetMetadata> {
        public Builder columnCount(Long var1);

        public Builder columnMetadata(Collection<ColumnMetadata> var1);

        public Builder columnMetadata(ColumnMetadata ... var1);

        public Builder columnMetadata(Consumer<ColumnMetadata.Builder> ... var1);
    }
}

