/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.services.redshift.model.SnapshotIdentifierListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchModifyClusterSnapshotsRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, BatchModifyClusterSnapshotsRequest> {
    private static final SdkField<List<String>> SNAPSHOT_IDENTIFIER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SnapshotIdentifierList").getter(BatchModifyClusterSnapshotsRequest.getter(BatchModifyClusterSnapshotsRequest::snapshotIdentifierList)).setter(BatchModifyClusterSnapshotsRequest.setter(Builder::snapshotIdentifierList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotIdentifierList").build(), ListTrait.builder().memberLocationName("String").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("String").build()}).build()).build()}).build();
    private static final SdkField<Integer> MANUAL_SNAPSHOT_RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ManualSnapshotRetentionPeriod").getter(BatchModifyClusterSnapshotsRequest.getter(BatchModifyClusterSnapshotsRequest::manualSnapshotRetentionPeriod)).setter(BatchModifyClusterSnapshotsRequest.setter(Builder::manualSnapshotRetentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManualSnapshotRetentionPeriod").build()}).build();
    private static final SdkField<Boolean> FORCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Force").getter(BatchModifyClusterSnapshotsRequest.getter(BatchModifyClusterSnapshotsRequest::force)).setter(BatchModifyClusterSnapshotsRequest.setter(Builder::force)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Force").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_IDENTIFIER_LIST_FIELD, MANUAL_SNAPSHOT_RETENTION_PERIOD_FIELD, FORCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchModifyClusterSnapshotsRequest.memberNameToFieldInitializer();
    private final List<String> snapshotIdentifierList;
    private final Integer manualSnapshotRetentionPeriod;
    private final Boolean force;

    private BatchModifyClusterSnapshotsRequest(BuilderImpl builder) {
        super(builder);
        this.snapshotIdentifierList = builder.snapshotIdentifierList;
        this.manualSnapshotRetentionPeriod = builder.manualSnapshotRetentionPeriod;
        this.force = builder.force;
    }

    public final boolean hasSnapshotIdentifierList() {
        return this.snapshotIdentifierList != null && !(this.snapshotIdentifierList instanceof SdkAutoConstructList);
    }

    public final List<String> snapshotIdentifierList() {
        return this.snapshotIdentifierList;
    }

    public final Integer manualSnapshotRetentionPeriod() {
        return this.manualSnapshotRetentionPeriod;
    }

    public final Boolean force() {
        return this.force;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSnapshotIdentifierList() ? this.snapshotIdentifierList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.manualSnapshotRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.force());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchModifyClusterSnapshotsRequest)) {
            return false;
        }
        BatchModifyClusterSnapshotsRequest other = (BatchModifyClusterSnapshotsRequest)((Object)obj);
        return this.hasSnapshotIdentifierList() == other.hasSnapshotIdentifierList() && Objects.equals(this.snapshotIdentifierList(), other.snapshotIdentifierList()) && Objects.equals(this.manualSnapshotRetentionPeriod(), other.manualSnapshotRetentionPeriod()) && Objects.equals(this.force(), other.force());
    }

    public final String toString() {
        return ToString.builder((String)"BatchModifyClusterSnapshotsRequest").add("SnapshotIdentifierList", this.hasSnapshotIdentifierList() ? this.snapshotIdentifierList() : null).add("ManualSnapshotRetentionPeriod", (Object)this.manualSnapshotRetentionPeriod()).add("Force", (Object)this.force()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnapshotIdentifierList": {
                return Optional.ofNullable(clazz.cast(this.snapshotIdentifierList()));
            }
            case "ManualSnapshotRetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.manualSnapshotRetentionPeriod()));
            }
            case "Force": {
                return Optional.ofNullable(clazz.cast(this.force()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SnapshotIdentifierList", SNAPSHOT_IDENTIFIER_LIST_FIELD);
        map.put("ManualSnapshotRetentionPeriod", MANUAL_SNAPSHOT_RETENTION_PERIOD_FIELD);
        map.put("Force", FORCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchModifyClusterSnapshotsRequest, T> g) {
        return obj -> g.apply((BatchModifyClusterSnapshotsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private List<String> snapshotIdentifierList = DefaultSdkAutoConstructList.getInstance();
        private Integer manualSnapshotRetentionPeriod;
        private Boolean force;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchModifyClusterSnapshotsRequest model) {
            super(model);
            this.snapshotIdentifierList(model.snapshotIdentifierList);
            this.manualSnapshotRetentionPeriod(model.manualSnapshotRetentionPeriod);
            this.force(model.force);
        }

        public final Collection<String> getSnapshotIdentifierList() {
            if (this.snapshotIdentifierList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.snapshotIdentifierList;
        }

        public final void setSnapshotIdentifierList(Collection<String> snapshotIdentifierList) {
            this.snapshotIdentifierList = SnapshotIdentifierListCopier.copy(snapshotIdentifierList);
        }

        @Override
        public final Builder snapshotIdentifierList(Collection<String> snapshotIdentifierList) {
            this.snapshotIdentifierList = SnapshotIdentifierListCopier.copy(snapshotIdentifierList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotIdentifierList(String ... snapshotIdentifierList) {
            this.snapshotIdentifierList(Arrays.asList(snapshotIdentifierList));
            return this;
        }

        public final Integer getManualSnapshotRetentionPeriod() {
            return this.manualSnapshotRetentionPeriod;
        }

        public final void setManualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod) {
            this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
        }

        @Override
        public final Builder manualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod) {
            this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
            return this;
        }

        public final Boolean getForce() {
            return this.force;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchModifyClusterSnapshotsRequest build() {
            return new BatchModifyClusterSnapshotsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchModifyClusterSnapshotsRequest> {
        public Builder snapshotIdentifierList(Collection<String> var1);

        public Builder snapshotIdentifierList(String ... var1);

        public Builder manualSnapshotRetentionPeriod(Integer var1);

        public Builder force(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

