/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthorizeSnapshotAccessRequest extends RedshiftRequest implements
        ToCopyableBuilder<AuthorizeSnapshotAccessRequest.Builder, AuthorizeSnapshotAccessRequest> {
    private static final SdkField<String> SNAPSHOT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotIdentifier").getter(getter(AuthorizeSnapshotAccessRequest::snapshotIdentifier))
            .setter(setter(Builder::snapshotIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotIdentifier").build())
            .build();

    private static final SdkField<String> SNAPSHOT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotArn").getter(getter(AuthorizeSnapshotAccessRequest::snapshotArn))
            .setter(setter(Builder::snapshotArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotArn").build()).build();

    private static final SdkField<String> SNAPSHOT_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotClusterIdentifier").getter(getter(AuthorizeSnapshotAccessRequest::snapshotClusterIdentifier))
            .setter(setter(Builder::snapshotClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotClusterIdentifier").build())
            .build();

    private static final SdkField<String> ACCOUNT_WITH_RESTORE_ACCESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountWithRestoreAccess").getter(getter(AuthorizeSnapshotAccessRequest::accountWithRestoreAccess))
            .setter(setter(Builder::accountWithRestoreAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountWithRestoreAccess").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_IDENTIFIER_FIELD,
            SNAPSHOT_ARN_FIELD, SNAPSHOT_CLUSTER_IDENTIFIER_FIELD, ACCOUNT_WITH_RESTORE_ACCESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String snapshotIdentifier;

    private final String snapshotArn;

    private final String snapshotClusterIdentifier;

    private final String accountWithRestoreAccess;

    private AuthorizeSnapshotAccessRequest(BuilderImpl builder) {
        super(builder);
        this.snapshotIdentifier = builder.snapshotIdentifier;
        this.snapshotArn = builder.snapshotArn;
        this.snapshotClusterIdentifier = builder.snapshotClusterIdentifier;
        this.accountWithRestoreAccess = builder.accountWithRestoreAccess;
    }

    /**
     * <p>
     * The identifier of the snapshot the account is authorized to restore.
     * </p>
     * 
     * @return The identifier of the snapshot the account is authorized to restore.
     */
    public final String snapshotIdentifier() {
        return snapshotIdentifier;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the snapshot to authorize access to.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the snapshot to authorize access to.
     */
    public final String snapshotArn() {
        return snapshotArn;
    }

    /**
     * <p>
     * The identifier of the cluster the snapshot was created from.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>If the snapshot to access doesn't exist and the associated IAM policy doesn't allow access to all (*)
     * snapshots</i> - This parameter is required. Otherwise, permissions aren't available to check if the snapshot
     * exists.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>If the snapshot to access exists</i> - This parameter isn't required. Redshift can retrieve the cluster
     * identifier and use it to validate snapshot authorization.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The identifier of the cluster the snapshot was created from.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <i>If the snapshot to access doesn't exist and the associated IAM policy doesn't allow access to all (*)
     *         snapshots</i> - This parameter is required. Otherwise, permissions aren't available to check if the
     *         snapshot exists.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>If the snapshot to access exists</i> - This parameter isn't required. Redshift can retrieve the
     *         cluster identifier and use it to validate snapshot authorization.
     *         </p>
     *         </li>
     */
    public final String snapshotClusterIdentifier() {
        return snapshotClusterIdentifier;
    }

    /**
     * <p>
     * The identifier of the Amazon Web Services account authorized to restore the specified snapshot.
     * </p>
     * <p>
     * To share a snapshot with Amazon Web Services Support, specify amazon-redshift-support.
     * </p>
     * 
     * @return The identifier of the Amazon Web Services account authorized to restore the specified snapshot.</p>
     *         <p>
     *         To share a snapshot with Amazon Web Services Support, specify amazon-redshift-support.
     */
    public final String accountWithRestoreAccess() {
        return accountWithRestoreAccess;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(snapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotArn());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(accountWithRestoreAccess());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizeSnapshotAccessRequest)) {
            return false;
        }
        AuthorizeSnapshotAccessRequest other = (AuthorizeSnapshotAccessRequest) obj;
        return Objects.equals(snapshotIdentifier(), other.snapshotIdentifier())
                && Objects.equals(snapshotArn(), other.snapshotArn())
                && Objects.equals(snapshotClusterIdentifier(), other.snapshotClusterIdentifier())
                && Objects.equals(accountWithRestoreAccess(), other.accountWithRestoreAccess());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuthorizeSnapshotAccessRequest").add("SnapshotIdentifier", snapshotIdentifier())
                .add("SnapshotArn", snapshotArn()).add("SnapshotClusterIdentifier", snapshotClusterIdentifier())
                .add("AccountWithRestoreAccess", accountWithRestoreAccess()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnapshotIdentifier":
            return Optional.ofNullable(clazz.cast(snapshotIdentifier()));
        case "SnapshotArn":
            return Optional.ofNullable(clazz.cast(snapshotArn()));
        case "SnapshotClusterIdentifier":
            return Optional.ofNullable(clazz.cast(snapshotClusterIdentifier()));
        case "AccountWithRestoreAccess":
            return Optional.ofNullable(clazz.cast(accountWithRestoreAccess()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SnapshotIdentifier", SNAPSHOT_IDENTIFIER_FIELD);
        map.put("SnapshotArn", SNAPSHOT_ARN_FIELD);
        map.put("SnapshotClusterIdentifier", SNAPSHOT_CLUSTER_IDENTIFIER_FIELD);
        map.put("AccountWithRestoreAccess", ACCOUNT_WITH_RESTORE_ACCESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthorizeSnapshotAccessRequest, T> g) {
        return obj -> g.apply((AuthorizeSnapshotAccessRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, AuthorizeSnapshotAccessRequest> {
        /**
         * <p>
         * The identifier of the snapshot the account is authorized to restore.
         * </p>
         * 
         * @param snapshotIdentifier
         *        The identifier of the snapshot the account is authorized to restore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotIdentifier(String snapshotIdentifier);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the snapshot to authorize access to.
         * </p>
         * 
         * @param snapshotArn
         *        The Amazon Resource Name (ARN) of the snapshot to authorize access to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotArn(String snapshotArn);

        /**
         * <p>
         * The identifier of the cluster the snapshot was created from.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <i>If the snapshot to access doesn't exist and the associated IAM policy doesn't allow access to all (*)
         * snapshots</i> - This parameter is required. Otherwise, permissions aren't available to check if the snapshot
         * exists.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>If the snapshot to access exists</i> - This parameter isn't required. Redshift can retrieve the cluster
         * identifier and use it to validate snapshot authorization.
         * </p>
         * </li>
         * </ul>
         * 
         * @param snapshotClusterIdentifier
         *        The identifier of the cluster the snapshot was created from.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <i>If the snapshot to access doesn't exist and the associated IAM policy doesn't allow access to all
         *        (*) snapshots</i> - This parameter is required. Otherwise, permissions aren't available to check if
         *        the snapshot exists.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>If the snapshot to access exists</i> - This parameter isn't required. Redshift can retrieve the
         *        cluster identifier and use it to validate snapshot authorization.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotClusterIdentifier(String snapshotClusterIdentifier);

        /**
         * <p>
         * The identifier of the Amazon Web Services account authorized to restore the specified snapshot.
         * </p>
         * <p>
         * To share a snapshot with Amazon Web Services Support, specify amazon-redshift-support.
         * </p>
         * 
         * @param accountWithRestoreAccess
         *        The identifier of the Amazon Web Services account authorized to restore the specified snapshot.</p>
         *        <p>
         *        To share a snapshot with Amazon Web Services Support, specify amazon-redshift-support.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountWithRestoreAccess(String accountWithRestoreAccess);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String snapshotIdentifier;

        private String snapshotArn;

        private String snapshotClusterIdentifier;

        private String accountWithRestoreAccess;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizeSnapshotAccessRequest model) {
            super(model);
            snapshotIdentifier(model.snapshotIdentifier);
            snapshotArn(model.snapshotArn);
            snapshotClusterIdentifier(model.snapshotClusterIdentifier);
            accountWithRestoreAccess(model.accountWithRestoreAccess);
        }

        public final String getSnapshotIdentifier() {
            return snapshotIdentifier;
        }

        public final void setSnapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
        }

        @Override
        public final Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        public final String getSnapshotArn() {
            return snapshotArn;
        }

        public final void setSnapshotArn(String snapshotArn) {
            this.snapshotArn = snapshotArn;
        }

        @Override
        public final Builder snapshotArn(String snapshotArn) {
            this.snapshotArn = snapshotArn;
            return this;
        }

        public final String getSnapshotClusterIdentifier() {
            return snapshotClusterIdentifier;
        }

        public final void setSnapshotClusterIdentifier(String snapshotClusterIdentifier) {
            this.snapshotClusterIdentifier = snapshotClusterIdentifier;
        }

        @Override
        public final Builder snapshotClusterIdentifier(String snapshotClusterIdentifier) {
            this.snapshotClusterIdentifier = snapshotClusterIdentifier;
            return this;
        }

        public final String getAccountWithRestoreAccess() {
            return accountWithRestoreAccess;
        }

        public final void setAccountWithRestoreAccess(String accountWithRestoreAccess) {
            this.accountWithRestoreAccess = accountWithRestoreAccess;
        }

        @Override
        public final Builder accountWithRestoreAccess(String accountWithRestoreAccess) {
            this.accountWithRestoreAccess = accountWithRestoreAccess;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AuthorizeSnapshotAccessRequest build() {
            return new AuthorizeSnapshotAccessRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
