/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeClusterDbRevisionsResponse extends RedshiftResponse implements
        ToCopyableBuilder<DescribeClusterDbRevisionsResponse.Builder, DescribeClusterDbRevisionsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeClusterDbRevisionsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<ClusterDbRevision>> CLUSTER_DB_REVISIONS_FIELD = SdkField
            .<List<ClusterDbRevision>> builder(MarshallingType.LIST)
            .memberName("ClusterDbRevisions")
            .getter(getter(DescribeClusterDbRevisionsResponse::clusterDbRevisions))
            .setter(setter(Builder::clusterDbRevisions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterDbRevisions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ClusterDbRevision")
                            .memberFieldInfo(
                                    SdkField.<ClusterDbRevision> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClusterDbRevision::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ClusterDbRevision").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            CLUSTER_DB_REVISIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String marker;

    private final List<ClusterDbRevision> clusterDbRevisions;

    private DescribeClusterDbRevisionsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.clusterDbRevisions = builder.clusterDbRevisions;
    }

    /**
     * <p>
     * A string representing the starting point for the next set of revisions. If a value is returned in a response, you
     * can retrieve the next set of revisions by providing the value in the <code>marker</code> parameter and retrying
     * the command. If the <code>marker</code> field is empty, all revisions have already been returned.
     * </p>
     * 
     * @return A string representing the starting point for the next set of revisions. If a value is returned in a
     *         response, you can retrieve the next set of revisions by providing the value in the <code>marker</code>
     *         parameter and retrying the command. If the <code>marker</code> field is empty, all revisions have already
     *         been returned.
     */
    public final String marker() {
        return marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClusterDbRevisions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasClusterDbRevisions() {
        return clusterDbRevisions != null && !(clusterDbRevisions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of revisions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClusterDbRevisions} method.
     * </p>
     * 
     * @return A list of revisions.
     */
    public final List<ClusterDbRevision> clusterDbRevisions() {
        return clusterDbRevisions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasClusterDbRevisions() ? clusterDbRevisions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterDbRevisionsResponse)) {
            return false;
        }
        DescribeClusterDbRevisionsResponse other = (DescribeClusterDbRevisionsResponse) obj;
        return Objects.equals(marker(), other.marker()) && hasClusterDbRevisions() == other.hasClusterDbRevisions()
                && Objects.equals(clusterDbRevisions(), other.clusterDbRevisions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeClusterDbRevisionsResponse").add("Marker", marker())
                .add("ClusterDbRevisions", hasClusterDbRevisions() ? clusterDbRevisions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "ClusterDbRevisions":
            return Optional.ofNullable(clazz.cast(clusterDbRevisions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Marker", MARKER_FIELD);
        map.put("ClusterDbRevisions", CLUSTER_DB_REVISIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeClusterDbRevisionsResponse, T> g) {
        return obj -> g.apply((DescribeClusterDbRevisionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeClusterDbRevisionsResponse> {
        /**
         * <p>
         * A string representing the starting point for the next set of revisions. If a value is returned in a response,
         * you can retrieve the next set of revisions by providing the value in the <code>marker</code> parameter and
         * retrying the command. If the <code>marker</code> field is empty, all revisions have already been returned.
         * </p>
         * 
         * @param marker
         *        A string representing the starting point for the next set of revisions. If a value is returned in a
         *        response, you can retrieve the next set of revisions by providing the value in the <code>marker</code>
         *        parameter and retrying the command. If the <code>marker</code> field is empty, all revisions have
         *        already been returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A list of revisions.
         * </p>
         * 
         * @param clusterDbRevisions
         *        A list of revisions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterDbRevisions(Collection<ClusterDbRevision> clusterDbRevisions);

        /**
         * <p>
         * A list of revisions.
         * </p>
         * 
         * @param clusterDbRevisions
         *        A list of revisions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterDbRevisions(ClusterDbRevision... clusterDbRevisions);

        /**
         * <p>
         * A list of revisions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshift.model.ClusterDbRevision.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.redshift.model.ClusterDbRevision#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshift.model.ClusterDbRevision.Builder#build()} is called
         * immediately and its result is passed to {@link #clusterDbRevisions(List<ClusterDbRevision>)}.
         * 
         * @param clusterDbRevisions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshift.model.ClusterDbRevision.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterDbRevisions(java.util.Collection<ClusterDbRevision>)
         */
        Builder clusterDbRevisions(Consumer<ClusterDbRevision.Builder>... clusterDbRevisions);
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private String marker;

        private List<ClusterDbRevision> clusterDbRevisions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterDbRevisionsResponse model) {
            super(model);
            marker(model.marker);
            clusterDbRevisions(model.clusterDbRevisions);
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<ClusterDbRevision.Builder> getClusterDbRevisions() {
            List<ClusterDbRevision.Builder> result = ClusterDbRevisionsListCopier.copyToBuilder(this.clusterDbRevisions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusterDbRevisions(Collection<ClusterDbRevision.BuilderImpl> clusterDbRevisions) {
            this.clusterDbRevisions = ClusterDbRevisionsListCopier.copyFromBuilder(clusterDbRevisions);
        }

        @Override
        public final Builder clusterDbRevisions(Collection<ClusterDbRevision> clusterDbRevisions) {
            this.clusterDbRevisions = ClusterDbRevisionsListCopier.copy(clusterDbRevisions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterDbRevisions(ClusterDbRevision... clusterDbRevisions) {
            clusterDbRevisions(Arrays.asList(clusterDbRevisions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterDbRevisions(Consumer<ClusterDbRevision.Builder>... clusterDbRevisions) {
            clusterDbRevisions(Stream.of(clusterDbRevisions).map(c -> ClusterDbRevision.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeClusterDbRevisionsResponse build() {
            return new DescribeClusterDbRevisionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
