/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReservedNodeExchangeStatusResponse extends RedshiftResponse implements
        ToCopyableBuilder<DescribeReservedNodeExchangeStatusResponse.Builder, DescribeReservedNodeExchangeStatusResponse> {
    private static final SdkField<List<ReservedNodeExchangeStatus>> RESERVED_NODE_EXCHANGE_STATUS_DETAILS_FIELD = SdkField
            .<List<ReservedNodeExchangeStatus>> builder(MarshallingType.LIST)
            .memberName("ReservedNodeExchangeStatusDetails")
            .getter(getter(DescribeReservedNodeExchangeStatusResponse::reservedNodeExchangeStatusDetails))
            .setter(setter(Builder::reservedNodeExchangeStatusDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedNodeExchangeStatusDetails")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ReservedNodeExchangeStatus")
                            .memberFieldInfo(
                                    SdkField.<ReservedNodeExchangeStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReservedNodeExchangeStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ReservedNodeExchangeStatus").build()).build()).build())
            .build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeReservedNodeExchangeStatusResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RESERVED_NODE_EXCHANGE_STATUS_DETAILS_FIELD, MARKER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ReservedNodeExchangeStatus> reservedNodeExchangeStatusDetails;

    private final String marker;

    private DescribeReservedNodeExchangeStatusResponse(BuilderImpl builder) {
        super(builder);
        this.reservedNodeExchangeStatusDetails = builder.reservedNodeExchangeStatusDetails;
        this.marker = builder.marker;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReservedNodeExchangeStatusDetails
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasReservedNodeExchangeStatusDetails() {
        return reservedNodeExchangeStatusDetails != null && !(reservedNodeExchangeStatusDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The details of the reserved-node exchange request, including the status, request time, source reserved-node
     * identifier, and additional details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReservedNodeExchangeStatusDetails}
     * method.
     * </p>
     * 
     * @return The details of the reserved-node exchange request, including the status, request time, source
     *         reserved-node identifier, and additional details.
     */
    public final List<ReservedNodeExchangeStatus> reservedNodeExchangeStatusDetails() {
        return reservedNodeExchangeStatusDetails;
    }

    /**
     * <p>
     * A pagination token provided by a previous <code>DescribeReservedNodeExchangeStatus</code> request.
     * </p>
     * 
     * @return A pagination token provided by a previous <code>DescribeReservedNodeExchangeStatus</code> request.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasReservedNodeExchangeStatusDetails() ? reservedNodeExchangeStatusDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedNodeExchangeStatusResponse)) {
            return false;
        }
        DescribeReservedNodeExchangeStatusResponse other = (DescribeReservedNodeExchangeStatusResponse) obj;
        return hasReservedNodeExchangeStatusDetails() == other.hasReservedNodeExchangeStatusDetails()
                && Objects.equals(reservedNodeExchangeStatusDetails(), other.reservedNodeExchangeStatusDetails())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeReservedNodeExchangeStatusResponse")
                .add("ReservedNodeExchangeStatusDetails",
                        hasReservedNodeExchangeStatusDetails() ? reservedNodeExchangeStatusDetails() : null)
                .add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReservedNodeExchangeStatusDetails":
            return Optional.ofNullable(clazz.cast(reservedNodeExchangeStatusDetails()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ReservedNodeExchangeStatusDetails", RESERVED_NODE_EXCHANGE_STATUS_DETAILS_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedNodeExchangeStatusResponse, T> g) {
        return obj -> g.apply((DescribeReservedNodeExchangeStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeReservedNodeExchangeStatusResponse> {
        /**
         * <p>
         * The details of the reserved-node exchange request, including the status, request time, source reserved-node
         * identifier, and additional details.
         * </p>
         * 
         * @param reservedNodeExchangeStatusDetails
         *        The details of the reserved-node exchange request, including the status, request time, source
         *        reserved-node identifier, and additional details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedNodeExchangeStatusDetails(Collection<ReservedNodeExchangeStatus> reservedNodeExchangeStatusDetails);

        /**
         * <p>
         * The details of the reserved-node exchange request, including the status, request time, source reserved-node
         * identifier, and additional details.
         * </p>
         * 
         * @param reservedNodeExchangeStatusDetails
         *        The details of the reserved-node exchange request, including the status, request time, source
         *        reserved-node identifier, and additional details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedNodeExchangeStatusDetails(ReservedNodeExchangeStatus... reservedNodeExchangeStatusDetails);

        /**
         * <p>
         * The details of the reserved-node exchange request, including the status, request time, source reserved-node
         * identifier, and additional details.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshift.model.ReservedNodeExchangeStatus.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.redshift.model.ReservedNodeExchangeStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshift.model.ReservedNodeExchangeStatus.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #reservedNodeExchangeStatusDetails(List<ReservedNodeExchangeStatus>)}.
         * 
         * @param reservedNodeExchangeStatusDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshift.model.ReservedNodeExchangeStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reservedNodeExchangeStatusDetails(java.util.Collection<ReservedNodeExchangeStatus>)
         */
        Builder reservedNodeExchangeStatusDetails(
                Consumer<ReservedNodeExchangeStatus.Builder>... reservedNodeExchangeStatusDetails);

        /**
         * <p>
         * A pagination token provided by a previous <code>DescribeReservedNodeExchangeStatus</code> request.
         * </p>
         * 
         * @param marker
         *        A pagination token provided by a previous <code>DescribeReservedNodeExchangeStatus</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private List<ReservedNodeExchangeStatus> reservedNodeExchangeStatusDetails = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedNodeExchangeStatusResponse model) {
            super(model);
            reservedNodeExchangeStatusDetails(model.reservedNodeExchangeStatusDetails);
            marker(model.marker);
        }

        public final List<ReservedNodeExchangeStatus.Builder> getReservedNodeExchangeStatusDetails() {
            List<ReservedNodeExchangeStatus.Builder> result = ReservedNodeExchangeStatusListCopier
                    .copyToBuilder(this.reservedNodeExchangeStatusDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReservedNodeExchangeStatusDetails(
                Collection<ReservedNodeExchangeStatus.BuilderImpl> reservedNodeExchangeStatusDetails) {
            this.reservedNodeExchangeStatusDetails = ReservedNodeExchangeStatusListCopier
                    .copyFromBuilder(reservedNodeExchangeStatusDetails);
        }

        @Override
        public final Builder reservedNodeExchangeStatusDetails(
                Collection<ReservedNodeExchangeStatus> reservedNodeExchangeStatusDetails) {
            this.reservedNodeExchangeStatusDetails = ReservedNodeExchangeStatusListCopier.copy(reservedNodeExchangeStatusDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedNodeExchangeStatusDetails(ReservedNodeExchangeStatus... reservedNodeExchangeStatusDetails) {
            reservedNodeExchangeStatusDetails(Arrays.asList(reservedNodeExchangeStatusDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedNodeExchangeStatusDetails(
                Consumer<ReservedNodeExchangeStatus.Builder>... reservedNodeExchangeStatusDetails) {
            reservedNodeExchangeStatusDetails(Stream.of(reservedNodeExchangeStatusDetails)
                    .map(c -> ReservedNodeExchangeStatus.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeReservedNodeExchangeStatusResponse build() {
            return new DescribeReservedNodeExchangeStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
