/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRecommendationsRequest extends RedshiftRequest implements
        ToCopyableBuilder<ListRecommendationsRequest.Builder, ListRecommendationsRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterIdentifier").getter(getter(ListRecommendationsRequest::clusterIdentifier))
            .setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<String> NAMESPACE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NamespaceArn").getter(getter(ListRecommendationsRequest::namespaceArn))
            .setter(setter(Builder::namespaceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamespaceArn").build()).build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRecords").getter(getter(ListRecommendationsRequest::maxRecords)).setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(ListRecommendationsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD,
            NAMESPACE_ARN_FIELD, MAX_RECORDS_FIELD, MARKER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clusterIdentifier;

    private final String namespaceArn;

    private final Integer maxRecords;

    private final String marker;

    private ListRecommendationsRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.namespaceArn = builder.namespaceArn;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * The unique identifier of the Amazon Redshift cluster for which the list of Advisor recommendations is returned.
     * If the neither the cluster identifier and the cluster namespace ARN parameters are specified, then
     * recommendations for all clusters in the account are returned.
     * </p>
     * 
     * @return The unique identifier of the Amazon Redshift cluster for which the list of Advisor recommendations is
     *         returned. If the neither the cluster identifier and the cluster namespace ARN parameters are specified,
     *         then recommendations for all clusters in the account are returned.
     */
    public final String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * The Amazon Redshift cluster namespace Amazon Resource Name (ARN) for which the list of Advisor recommendations is
     * returned. If the neither the cluster identifier and the cluster namespace ARN parameters are specified, then
     * recommendations for all clusters in the account are returned.
     * </p>
     * 
     * @return The Amazon Redshift cluster namespace Amazon Resource Name (ARN) for which the list of Advisor
     *         recommendations is returned. If the neither the cluster identifier and the cluster namespace ARN
     *         parameters are specified, then recommendations for all clusters in the account are returned.
     */
    public final String namespaceArn() {
        return namespaceArn;
    }

    /**
     * <p>
     * The maximum number of response records to return in each call. If the number of remaining response records
     * exceeds the specified MaxRecords value, a value is returned in a marker field of the response. You can retrieve
     * the next set of records by retrying the command with the returned marker value.
     * </p>
     * 
     * @return The maximum number of response records to return in each call. If the number of remaining response
     *         records exceeds the specified MaxRecords value, a value is returned in a marker field of the response.
     *         You can retrieve the next set of records by retrying the command with the returned marker value.
     */
    public final Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * A value that indicates the starting point for the next set of response records in a subsequent request. If a
     * value is returned in a response, you can retrieve the next set of records by providing this returned marker value
     * in the Marker parameter and retrying the command. If the Marker field is empty, all response records have been
     * retrieved for the request.
     * </p>
     * 
     * @return A value that indicates the starting point for the next set of response records in a subsequent request.
     *         If a value is returned in a response, you can retrieve the next set of records by providing this returned
     *         marker value in the Marker parameter and retrying the command. If the Marker field is empty, all response
     *         records have been retrieved for the request.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceArn());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecommendationsRequest)) {
            return false;
        }
        ListRecommendationsRequest other = (ListRecommendationsRequest) obj;
        return Objects.equals(clusterIdentifier(), other.clusterIdentifier())
                && Objects.equals(namespaceArn(), other.namespaceArn()) && Objects.equals(maxRecords(), other.maxRecords())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRecommendationsRequest").add("ClusterIdentifier", clusterIdentifier())
                .add("NamespaceArn", namespaceArn()).add("MaxRecords", maxRecords()).add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "NamespaceArn":
            return Optional.ofNullable(clazz.cast(namespaceArn()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClusterIdentifier", CLUSTER_IDENTIFIER_FIELD);
        map.put("NamespaceArn", NAMESPACE_ARN_FIELD);
        map.put("MaxRecords", MAX_RECORDS_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRecommendationsRequest, T> g) {
        return obj -> g.apply((ListRecommendationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListRecommendationsRequest> {
        /**
         * <p>
         * The unique identifier of the Amazon Redshift cluster for which the list of Advisor recommendations is
         * returned. If the neither the cluster identifier and the cluster namespace ARN parameters are specified, then
         * recommendations for all clusters in the account are returned.
         * </p>
         * 
         * @param clusterIdentifier
         *        The unique identifier of the Amazon Redshift cluster for which the list of Advisor recommendations is
         *        returned. If the neither the cluster identifier and the cluster namespace ARN parameters are
         *        specified, then recommendations for all clusters in the account are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The Amazon Redshift cluster namespace Amazon Resource Name (ARN) for which the list of Advisor
         * recommendations is returned. If the neither the cluster identifier and the cluster namespace ARN parameters
         * are specified, then recommendations for all clusters in the account are returned.
         * </p>
         * 
         * @param namespaceArn
         *        The Amazon Redshift cluster namespace Amazon Resource Name (ARN) for which the list of Advisor
         *        recommendations is returned. If the neither the cluster identifier and the cluster namespace ARN
         *        parameters are specified, then recommendations for all clusters in the account are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceArn(String namespaceArn);

        /**
         * <p>
         * The maximum number of response records to return in each call. If the number of remaining response records
         * exceeds the specified MaxRecords value, a value is returned in a marker field of the response. You can
         * retrieve the next set of records by retrying the command with the returned marker value.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of response records to return in each call. If the number of remaining response
         *        records exceeds the specified MaxRecords value, a value is returned in a marker field of the response.
         *        You can retrieve the next set of records by retrying the command with the returned marker value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * A value that indicates the starting point for the next set of response records in a subsequent request. If a
         * value is returned in a response, you can retrieve the next set of records by providing this returned marker
         * value in the Marker parameter and retrying the command. If the Marker field is empty, all response records
         * have been retrieved for the request.
         * </p>
         * 
         * @param marker
         *        A value that indicates the starting point for the next set of response records in a subsequent
         *        request. If a value is returned in a response, you can retrieve the next set of records by providing
         *        this returned marker value in the Marker parameter and retrying the command. If the Marker field is
         *        empty, all response records have been retrieved for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String clusterIdentifier;

        private String namespaceArn;

        private Integer maxRecords;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecommendationsRequest model) {
            super(model);
            clusterIdentifier(model.clusterIdentifier);
            namespaceArn(model.namespaceArn);
            maxRecords(model.maxRecords);
            marker(model.marker);
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getNamespaceArn() {
            return namespaceArn;
        }

        public final void setNamespaceArn(String namespaceArn) {
            this.namespaceArn = namespaceArn;
        }

        @Override
        public final Builder namespaceArn(String namespaceArn) {
            this.namespaceArn = namespaceArn;
            return this;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRecommendationsRequest build() {
            return new ListRecommendationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
