/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyUsageLimitRequest extends RedshiftRequest implements
        ToCopyableBuilder<ModifyUsageLimitRequest.Builder, ModifyUsageLimitRequest> {
    private static final SdkField<String> USAGE_LIMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UsageLimitId").getter(getter(ModifyUsageLimitRequest::usageLimitId))
            .setter(setter(Builder::usageLimitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageLimitId").build()).build();

    private static final SdkField<Long> AMOUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Amount")
            .getter(getter(ModifyUsageLimitRequest::amount)).setter(setter(Builder::amount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Amount").build()).build();

    private static final SdkField<String> BREACH_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BreachAction").getter(getter(ModifyUsageLimitRequest::breachActionAsString))
            .setter(setter(Builder::breachAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BreachAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USAGE_LIMIT_ID_FIELD,
            AMOUNT_FIELD, BREACH_ACTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String usageLimitId;

    private final Long amount;

    private final String breachAction;

    private ModifyUsageLimitRequest(BuilderImpl builder) {
        super(builder);
        this.usageLimitId = builder.usageLimitId;
        this.amount = builder.amount;
        this.breachAction = builder.breachAction;
    }

    /**
     * <p>
     * The identifier of the usage limit to modify.
     * </p>
     * 
     * @return The identifier of the usage limit to modify.
     */
    public final String usageLimitId() {
        return usageLimitId;
    }

    /**
     * <p>
     * The new limit amount. For more information about this parameter, see <a>UsageLimit</a>.
     * </p>
     * 
     * @return The new limit amount. For more information about this parameter, see <a>UsageLimit</a>.
     */
    public final Long amount() {
        return amount;
    }

    /**
     * <p>
     * The new action that Amazon Redshift takes when the limit is reached. For more information about this parameter,
     * see <a>UsageLimit</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #breachAction} will
     * return {@link UsageLimitBreachAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #breachActionAsString}.
     * </p>
     * 
     * @return The new action that Amazon Redshift takes when the limit is reached. For more information about this
     *         parameter, see <a>UsageLimit</a>.
     * @see UsageLimitBreachAction
     */
    public final UsageLimitBreachAction breachAction() {
        return UsageLimitBreachAction.fromValue(breachAction);
    }

    /**
     * <p>
     * The new action that Amazon Redshift takes when the limit is reached. For more information about this parameter,
     * see <a>UsageLimit</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #breachAction} will
     * return {@link UsageLimitBreachAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #breachActionAsString}.
     * </p>
     * 
     * @return The new action that Amazon Redshift takes when the limit is reached. For more information about this
     *         parameter, see <a>UsageLimit</a>.
     * @see UsageLimitBreachAction
     */
    public final String breachActionAsString() {
        return breachAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(usageLimitId());
        hashCode = 31 * hashCode + Objects.hashCode(amount());
        hashCode = 31 * hashCode + Objects.hashCode(breachActionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyUsageLimitRequest)) {
            return false;
        }
        ModifyUsageLimitRequest other = (ModifyUsageLimitRequest) obj;
        return Objects.equals(usageLimitId(), other.usageLimitId()) && Objects.equals(amount(), other.amount())
                && Objects.equals(breachActionAsString(), other.breachActionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyUsageLimitRequest").add("UsageLimitId", usageLimitId()).add("Amount", amount())
                .add("BreachAction", breachActionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UsageLimitId":
            return Optional.ofNullable(clazz.cast(usageLimitId()));
        case "Amount":
            return Optional.ofNullable(clazz.cast(amount()));
        case "BreachAction":
            return Optional.ofNullable(clazz.cast(breachActionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UsageLimitId", USAGE_LIMIT_ID_FIELD);
        map.put("Amount", AMOUNT_FIELD);
        map.put("BreachAction", BREACH_ACTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyUsageLimitRequest, T> g) {
        return obj -> g.apply((ModifyUsageLimitRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyUsageLimitRequest> {
        /**
         * <p>
         * The identifier of the usage limit to modify.
         * </p>
         * 
         * @param usageLimitId
         *        The identifier of the usage limit to modify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageLimitId(String usageLimitId);

        /**
         * <p>
         * The new limit amount. For more information about this parameter, see <a>UsageLimit</a>.
         * </p>
         * 
         * @param amount
         *        The new limit amount. For more information about this parameter, see <a>UsageLimit</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amount(Long amount);

        /**
         * <p>
         * The new action that Amazon Redshift takes when the limit is reached. For more information about this
         * parameter, see <a>UsageLimit</a>.
         * </p>
         * 
         * @param breachAction
         *        The new action that Amazon Redshift takes when the limit is reached. For more information about this
         *        parameter, see <a>UsageLimit</a>.
         * @see UsageLimitBreachAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageLimitBreachAction
         */
        Builder breachAction(String breachAction);

        /**
         * <p>
         * The new action that Amazon Redshift takes when the limit is reached. For more information about this
         * parameter, see <a>UsageLimit</a>.
         * </p>
         * 
         * @param breachAction
         *        The new action that Amazon Redshift takes when the limit is reached. For more information about this
         *        parameter, see <a>UsageLimit</a>.
         * @see UsageLimitBreachAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageLimitBreachAction
         */
        Builder breachAction(UsageLimitBreachAction breachAction);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String usageLimitId;

        private Long amount;

        private String breachAction;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyUsageLimitRequest model) {
            super(model);
            usageLimitId(model.usageLimitId);
            amount(model.amount);
            breachAction(model.breachAction);
        }

        public final String getUsageLimitId() {
            return usageLimitId;
        }

        public final void setUsageLimitId(String usageLimitId) {
            this.usageLimitId = usageLimitId;
        }

        @Override
        public final Builder usageLimitId(String usageLimitId) {
            this.usageLimitId = usageLimitId;
            return this;
        }

        public final Long getAmount() {
            return amount;
        }

        public final void setAmount(Long amount) {
            this.amount = amount;
        }

        @Override
        public final Builder amount(Long amount) {
            this.amount = amount;
            return this;
        }

        public final String getBreachAction() {
            return breachAction;
        }

        public final void setBreachAction(String breachAction) {
            this.breachAction = breachAction;
        }

        @Override
        public final Builder breachAction(String breachAction) {
            this.breachAction = breachAction;
            return this;
        }

        @Override
        public final Builder breachAction(UsageLimitBreachAction breachAction) {
            this.breachAction(breachAction == null ? null : breachAction.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyUsageLimitRequest build() {
            return new ModifyUsageLimitRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
