/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An Amazon Redshift Advisor recommended action on the Amazon Redshift cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Recommendation implements SdkPojo, Serializable, ToCopyableBuilder<Recommendation.Builder, Recommendation> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(Recommendation::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterIdentifier").getter(getter(Recommendation::clusterIdentifier))
            .setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<String> NAMESPACE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NamespaceArn").getter(getter(Recommendation::namespaceArn)).setter(setter(Builder::namespaceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamespaceArn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(Recommendation::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> RECOMMENDATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecommendationType").getter(getter(Recommendation::recommendationType))
            .setter(setter(Builder::recommendationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationType").build())
            .build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(Recommendation::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Recommendation::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> OBSERVATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Observation").getter(getter(Recommendation::observation)).setter(setter(Builder::observation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Observation").build()).build();

    private static final SdkField<String> IMPACT_RANKING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImpactRanking").getter(getter(Recommendation::impactRankingAsString))
            .setter(setter(Builder::impactRanking))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImpactRanking").build()).build();

    private static final SdkField<String> RECOMMENDATION_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecommendationText").getter(getter(Recommendation::recommendationText))
            .setter(setter(Builder::recommendationText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationText").build())
            .build();

    private static final SdkField<List<RecommendedAction>> RECOMMENDED_ACTIONS_FIELD = SdkField
            .<List<RecommendedAction>> builder(MarshallingType.LIST)
            .memberName("RecommendedActions")
            .getter(getter(Recommendation::recommendedActions))
            .setter(setter(Builder::recommendedActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendedActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("RecommendedAction")
                            .memberFieldInfo(
                                    SdkField.<RecommendedAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecommendedAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("RecommendedAction").build()).build()).build()).build();

    private static final SdkField<List<ReferenceLink>> REFERENCE_LINKS_FIELD = SdkField
            .<List<ReferenceLink>> builder(MarshallingType.LIST)
            .memberName("ReferenceLinks")
            .getter(getter(Recommendation::referenceLinks))
            .setter(setter(Builder::referenceLinks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReferenceLinks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ReferenceLink")
                            .memberFieldInfo(
                                    SdkField.<ReferenceLink> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReferenceLink::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ReferenceLink").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            CLUSTER_IDENTIFIER_FIELD, NAMESPACE_ARN_FIELD, CREATED_AT_FIELD, RECOMMENDATION_TYPE_FIELD, TITLE_FIELD,
            DESCRIPTION_FIELD, OBSERVATION_FIELD, IMPACT_RANKING_FIELD, RECOMMENDATION_TEXT_FIELD, RECOMMENDED_ACTIONS_FIELD,
            REFERENCE_LINKS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String clusterIdentifier;

    private final String namespaceArn;

    private final Instant createdAt;

    private final String recommendationType;

    private final String title;

    private final String description;

    private final String observation;

    private final String impactRanking;

    private final String recommendationText;

    private final List<RecommendedAction> recommendedActions;

    private final List<ReferenceLink> referenceLinks;

    private Recommendation(BuilderImpl builder) {
        this.id = builder.id;
        this.clusterIdentifier = builder.clusterIdentifier;
        this.namespaceArn = builder.namespaceArn;
        this.createdAt = builder.createdAt;
        this.recommendationType = builder.recommendationType;
        this.title = builder.title;
        this.description = builder.description;
        this.observation = builder.observation;
        this.impactRanking = builder.impactRanking;
        this.recommendationText = builder.recommendationText;
        this.recommendedActions = builder.recommendedActions;
        this.referenceLinks = builder.referenceLinks;
    }

    /**
     * <p>
     * A unique identifier of the Advisor recommendation.
     * </p>
     * 
     * @return A unique identifier of the Advisor recommendation.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The unique identifier of the cluster for which the recommendation is returned.
     * </p>
     * 
     * @return The unique identifier of the cluster for which the recommendation is returned.
     */
    public final String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * The Amazon Redshift cluster namespace ARN for which the recommendations is returned.
     * </p>
     * 
     * @return The Amazon Redshift cluster namespace ARN for which the recommendations is returned.
     */
    public final String namespaceArn() {
        return namespaceArn;
    }

    /**
     * <p>
     * The date and time (UTC) that the recommendation was created.
     * </p>
     * 
     * @return The date and time (UTC) that the recommendation was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The type of Advisor recommendation.
     * </p>
     * 
     * @return The type of Advisor recommendation.
     */
    public final String recommendationType() {
        return recommendationType;
    }

    /**
     * <p>
     * The title of the recommendation.
     * </p>
     * 
     * @return The title of the recommendation.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The description of the recommendation.
     * </p>
     * 
     * @return The description of the recommendation.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The description of what was observed about your cluster.
     * </p>
     * 
     * @return The description of what was observed about your cluster.
     */
    public final String observation() {
        return observation;
    }

    /**
     * <p>
     * The scale of the impact that the Advisor recommendation has to the performance and cost of the cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #impactRanking}
     * will return {@link ImpactRankingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #impactRankingAsString}.
     * </p>
     * 
     * @return The scale of the impact that the Advisor recommendation has to the performance and cost of the cluster.
     * @see ImpactRankingType
     */
    public final ImpactRankingType impactRanking() {
        return ImpactRankingType.fromValue(impactRanking);
    }

    /**
     * <p>
     * The scale of the impact that the Advisor recommendation has to the performance and cost of the cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #impactRanking}
     * will return {@link ImpactRankingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #impactRankingAsString}.
     * </p>
     * 
     * @return The scale of the impact that the Advisor recommendation has to the performance and cost of the cluster.
     * @see ImpactRankingType
     */
    public final String impactRankingAsString() {
        return impactRanking;
    }

    /**
     * <p>
     * The description of the recommendation.
     * </p>
     * 
     * @return The description of the recommendation.
     */
    public final String recommendationText() {
        return recommendationText;
    }

    /**
     * For responses, this returns true if the service returned a value for the RecommendedActions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRecommendedActions() {
        return recommendedActions != null && !(recommendedActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of Amazon Redshift recommended actions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecommendedActions} method.
     * </p>
     * 
     * @return List of Amazon Redshift recommended actions.
     */
    public final List<RecommendedAction> recommendedActions() {
        return recommendedActions;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReferenceLinks property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReferenceLinks() {
        return referenceLinks != null && !(referenceLinks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of helpful links for more information about the Advisor recommendation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReferenceLinks} method.
     * </p>
     * 
     * @return List of helpful links for more information about the Advisor recommendation.
     */
    public final List<ReferenceLink> referenceLinks() {
        return referenceLinks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationType());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(observation());
        hashCode = 31 * hashCode + Objects.hashCode(impactRankingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationText());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecommendedActions() ? recommendedActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasReferenceLinks() ? referenceLinks() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Recommendation)) {
            return false;
        }
        Recommendation other = (Recommendation) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(clusterIdentifier(), other.clusterIdentifier())
                && Objects.equals(namespaceArn(), other.namespaceArn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(recommendationType(), other.recommendationType()) && Objects.equals(title(), other.title())
                && Objects.equals(description(), other.description()) && Objects.equals(observation(), other.observation())
                && Objects.equals(impactRankingAsString(), other.impactRankingAsString())
                && Objects.equals(recommendationText(), other.recommendationText())
                && hasRecommendedActions() == other.hasRecommendedActions()
                && Objects.equals(recommendedActions(), other.recommendedActions())
                && hasReferenceLinks() == other.hasReferenceLinks() && Objects.equals(referenceLinks(), other.referenceLinks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Recommendation").add("Id", id()).add("ClusterIdentifier", clusterIdentifier())
                .add("NamespaceArn", namespaceArn()).add("CreatedAt", createdAt())
                .add("RecommendationType", recommendationType()).add("Title", title()).add("Description", description())
                .add("Observation", observation()).add("ImpactRanking", impactRankingAsString())
                .add("RecommendationText", recommendationText())
                .add("RecommendedActions", hasRecommendedActions() ? recommendedActions() : null)
                .add("ReferenceLinks", hasReferenceLinks() ? referenceLinks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "NamespaceArn":
            return Optional.ofNullable(clazz.cast(namespaceArn()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "RecommendationType":
            return Optional.ofNullable(clazz.cast(recommendationType()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Observation":
            return Optional.ofNullable(clazz.cast(observation()));
        case "ImpactRanking":
            return Optional.ofNullable(clazz.cast(impactRankingAsString()));
        case "RecommendationText":
            return Optional.ofNullable(clazz.cast(recommendationText()));
        case "RecommendedActions":
            return Optional.ofNullable(clazz.cast(recommendedActions()));
        case "ReferenceLinks":
            return Optional.ofNullable(clazz.cast(referenceLinks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("ClusterIdentifier", CLUSTER_IDENTIFIER_FIELD);
        map.put("NamespaceArn", NAMESPACE_ARN_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("RecommendationType", RECOMMENDATION_TYPE_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Observation", OBSERVATION_FIELD);
        map.put("ImpactRanking", IMPACT_RANKING_FIELD);
        map.put("RecommendationText", RECOMMENDATION_TEXT_FIELD);
        map.put("RecommendedActions", RECOMMENDED_ACTIONS_FIELD);
        map.put("ReferenceLinks", REFERENCE_LINKS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Recommendation, T> g) {
        return obj -> g.apply((Recommendation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Recommendation> {
        /**
         * <p>
         * A unique identifier of the Advisor recommendation.
         * </p>
         * 
         * @param id
         *        A unique identifier of the Advisor recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The unique identifier of the cluster for which the recommendation is returned.
         * </p>
         * 
         * @param clusterIdentifier
         *        The unique identifier of the cluster for which the recommendation is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The Amazon Redshift cluster namespace ARN for which the recommendations is returned.
         * </p>
         * 
         * @param namespaceArn
         *        The Amazon Redshift cluster namespace ARN for which the recommendations is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceArn(String namespaceArn);

        /**
         * <p>
         * The date and time (UTC) that the recommendation was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time (UTC) that the recommendation was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The type of Advisor recommendation.
         * </p>
         * 
         * @param recommendationType
         *        The type of Advisor recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationType(String recommendationType);

        /**
         * <p>
         * The title of the recommendation.
         * </p>
         * 
         * @param title
         *        The title of the recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The description of the recommendation.
         * </p>
         * 
         * @param description
         *        The description of the recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The description of what was observed about your cluster.
         * </p>
         * 
         * @param observation
         *        The description of what was observed about your cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder observation(String observation);

        /**
         * <p>
         * The scale of the impact that the Advisor recommendation has to the performance and cost of the cluster.
         * </p>
         * 
         * @param impactRanking
         *        The scale of the impact that the Advisor recommendation has to the performance and cost of the
         *        cluster.
         * @see ImpactRankingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImpactRankingType
         */
        Builder impactRanking(String impactRanking);

        /**
         * <p>
         * The scale of the impact that the Advisor recommendation has to the performance and cost of the cluster.
         * </p>
         * 
         * @param impactRanking
         *        The scale of the impact that the Advisor recommendation has to the performance and cost of the
         *        cluster.
         * @see ImpactRankingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImpactRankingType
         */
        Builder impactRanking(ImpactRankingType impactRanking);

        /**
         * <p>
         * The description of the recommendation.
         * </p>
         * 
         * @param recommendationText
         *        The description of the recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationText(String recommendationText);

        /**
         * <p>
         * List of Amazon Redshift recommended actions.
         * </p>
         * 
         * @param recommendedActions
         *        List of Amazon Redshift recommended actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendedActions(Collection<RecommendedAction> recommendedActions);

        /**
         * <p>
         * List of Amazon Redshift recommended actions.
         * </p>
         * 
         * @param recommendedActions
         *        List of Amazon Redshift recommended actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendedActions(RecommendedAction... recommendedActions);

        /**
         * <p>
         * List of Amazon Redshift recommended actions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshift.model.RecommendedAction.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.redshift.model.RecommendedAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshift.model.RecommendedAction.Builder#build()} is called
         * immediately and its result is passed to {@link #recommendedActions(List<RecommendedAction>)}.
         * 
         * @param recommendedActions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshift.model.RecommendedAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recommendedActions(java.util.Collection<RecommendedAction>)
         */
        Builder recommendedActions(Consumer<RecommendedAction.Builder>... recommendedActions);

        /**
         * <p>
         * List of helpful links for more information about the Advisor recommendation.
         * </p>
         * 
         * @param referenceLinks
         *        List of helpful links for more information about the Advisor recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceLinks(Collection<ReferenceLink> referenceLinks);

        /**
         * <p>
         * List of helpful links for more information about the Advisor recommendation.
         * </p>
         * 
         * @param referenceLinks
         *        List of helpful links for more information about the Advisor recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceLinks(ReferenceLink... referenceLinks);

        /**
         * <p>
         * List of helpful links for more information about the Advisor recommendation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshift.model.ReferenceLink.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.redshift.model.ReferenceLink#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshift.model.ReferenceLink.Builder#build()} is called immediately
         * and its result is passed to {@link #referenceLinks(List<ReferenceLink>)}.
         * 
         * @param referenceLinks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshift.model.ReferenceLink.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #referenceLinks(java.util.Collection<ReferenceLink>)
         */
        Builder referenceLinks(Consumer<ReferenceLink.Builder>... referenceLinks);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String clusterIdentifier;

        private String namespaceArn;

        private Instant createdAt;

        private String recommendationType;

        private String title;

        private String description;

        private String observation;

        private String impactRanking;

        private String recommendationText;

        private List<RecommendedAction> recommendedActions = DefaultSdkAutoConstructList.getInstance();

        private List<ReferenceLink> referenceLinks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Recommendation model) {
            id(model.id);
            clusterIdentifier(model.clusterIdentifier);
            namespaceArn(model.namespaceArn);
            createdAt(model.createdAt);
            recommendationType(model.recommendationType);
            title(model.title);
            description(model.description);
            observation(model.observation);
            impactRanking(model.impactRanking);
            recommendationText(model.recommendationText);
            recommendedActions(model.recommendedActions);
            referenceLinks(model.referenceLinks);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getNamespaceArn() {
            return namespaceArn;
        }

        public final void setNamespaceArn(String namespaceArn) {
            this.namespaceArn = namespaceArn;
        }

        @Override
        public final Builder namespaceArn(String namespaceArn) {
            this.namespaceArn = namespaceArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getRecommendationType() {
            return recommendationType;
        }

        public final void setRecommendationType(String recommendationType) {
            this.recommendationType = recommendationType;
        }

        @Override
        public final Builder recommendationType(String recommendationType) {
            this.recommendationType = recommendationType;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getObservation() {
            return observation;
        }

        public final void setObservation(String observation) {
            this.observation = observation;
        }

        @Override
        public final Builder observation(String observation) {
            this.observation = observation;
            return this;
        }

        public final String getImpactRanking() {
            return impactRanking;
        }

        public final void setImpactRanking(String impactRanking) {
            this.impactRanking = impactRanking;
        }

        @Override
        public final Builder impactRanking(String impactRanking) {
            this.impactRanking = impactRanking;
            return this;
        }

        @Override
        public final Builder impactRanking(ImpactRankingType impactRanking) {
            this.impactRanking(impactRanking == null ? null : impactRanking.toString());
            return this;
        }

        public final String getRecommendationText() {
            return recommendationText;
        }

        public final void setRecommendationText(String recommendationText) {
            this.recommendationText = recommendationText;
        }

        @Override
        public final Builder recommendationText(String recommendationText) {
            this.recommendationText = recommendationText;
            return this;
        }

        public final List<RecommendedAction.Builder> getRecommendedActions() {
            List<RecommendedAction.Builder> result = RecommendedActionListCopier.copyToBuilder(this.recommendedActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecommendedActions(Collection<RecommendedAction.BuilderImpl> recommendedActions) {
            this.recommendedActions = RecommendedActionListCopier.copyFromBuilder(recommendedActions);
        }

        @Override
        public final Builder recommendedActions(Collection<RecommendedAction> recommendedActions) {
            this.recommendedActions = RecommendedActionListCopier.copy(recommendedActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendedActions(RecommendedAction... recommendedActions) {
            recommendedActions(Arrays.asList(recommendedActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendedActions(Consumer<RecommendedAction.Builder>... recommendedActions) {
            recommendedActions(Stream.of(recommendedActions).map(c -> RecommendedAction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ReferenceLink.Builder> getReferenceLinks() {
            List<ReferenceLink.Builder> result = ReferenceLinkListCopier.copyToBuilder(this.referenceLinks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReferenceLinks(Collection<ReferenceLink.BuilderImpl> referenceLinks) {
            this.referenceLinks = ReferenceLinkListCopier.copyFromBuilder(referenceLinks);
        }

        @Override
        public final Builder referenceLinks(Collection<ReferenceLink> referenceLinks) {
            this.referenceLinks = ReferenceLinkListCopier.copy(referenceLinks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceLinks(ReferenceLink... referenceLinks) {
            referenceLinks(Arrays.asList(referenceLinks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referenceLinks(Consumer<ReferenceLink.Builder>... referenceLinks) {
            referenceLinks(Stream.of(referenceLinks).map(c -> ReferenceLink.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Recommendation build() {
            return new Recommendation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
