/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreTableFromClusterSnapshotRequest extends RedshiftRequest implements
        ToCopyableBuilder<RestoreTableFromClusterSnapshotRequest.Builder, RestoreTableFromClusterSnapshotRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterIdentifier").getter(getter(RestoreTableFromClusterSnapshotRequest::clusterIdentifier))
            .setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<String> SNAPSHOT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotIdentifier").getter(getter(RestoreTableFromClusterSnapshotRequest::snapshotIdentifier))
            .setter(setter(Builder::snapshotIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotIdentifier").build())
            .build();

    private static final SdkField<String> SOURCE_DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceDatabaseName").getter(getter(RestoreTableFromClusterSnapshotRequest::sourceDatabaseName))
            .setter(setter(Builder::sourceDatabaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDatabaseName").build())
            .build();

    private static final SdkField<String> SOURCE_SCHEMA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceSchemaName").getter(getter(RestoreTableFromClusterSnapshotRequest::sourceSchemaName))
            .setter(setter(Builder::sourceSchemaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceSchemaName").build()).build();

    private static final SdkField<String> SOURCE_TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceTableName").getter(getter(RestoreTableFromClusterSnapshotRequest::sourceTableName))
            .setter(setter(Builder::sourceTableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceTableName").build()).build();

    private static final SdkField<String> TARGET_DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetDatabaseName").getter(getter(RestoreTableFromClusterSnapshotRequest::targetDatabaseName))
            .setter(setter(Builder::targetDatabaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDatabaseName").build())
            .build();

    private static final SdkField<String> TARGET_SCHEMA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetSchemaName").getter(getter(RestoreTableFromClusterSnapshotRequest::targetSchemaName))
            .setter(setter(Builder::targetSchemaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetSchemaName").build()).build();

    private static final SdkField<String> NEW_TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NewTableName").getter(getter(RestoreTableFromClusterSnapshotRequest::newTableName))
            .setter(setter(Builder::newTableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewTableName").build()).build();

    private static final SdkField<Boolean> ENABLE_CASE_SENSITIVE_IDENTIFIER_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableCaseSensitiveIdentifier")
            .getter(getter(RestoreTableFromClusterSnapshotRequest::enableCaseSensitiveIdentifier))
            .setter(setter(Builder::enableCaseSensitiveIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableCaseSensitiveIdentifier")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD,
            SNAPSHOT_IDENTIFIER_FIELD, SOURCE_DATABASE_NAME_FIELD, SOURCE_SCHEMA_NAME_FIELD, SOURCE_TABLE_NAME_FIELD,
            TARGET_DATABASE_NAME_FIELD, TARGET_SCHEMA_NAME_FIELD, NEW_TABLE_NAME_FIELD, ENABLE_CASE_SENSITIVE_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clusterIdentifier;

    private final String snapshotIdentifier;

    private final String sourceDatabaseName;

    private final String sourceSchemaName;

    private final String sourceTableName;

    private final String targetDatabaseName;

    private final String targetSchemaName;

    private final String newTableName;

    private final Boolean enableCaseSensitiveIdentifier;

    private RestoreTableFromClusterSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.snapshotIdentifier = builder.snapshotIdentifier;
        this.sourceDatabaseName = builder.sourceDatabaseName;
        this.sourceSchemaName = builder.sourceSchemaName;
        this.sourceTableName = builder.sourceTableName;
        this.targetDatabaseName = builder.targetDatabaseName;
        this.targetSchemaName = builder.targetSchemaName;
        this.newTableName = builder.newTableName;
        this.enableCaseSensitiveIdentifier = builder.enableCaseSensitiveIdentifier;
    }

    /**
     * <p>
     * The identifier of the Amazon Redshift cluster to restore the table to.
     * </p>
     * 
     * @return The identifier of the Amazon Redshift cluster to restore the table to.
     */
    public final String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * The identifier of the snapshot to restore the table from. This snapshot must have been created from the Amazon
     * Redshift cluster specified by the <code>ClusterIdentifier</code> parameter.
     * </p>
     * 
     * @return The identifier of the snapshot to restore the table from. This snapshot must have been created from the
     *         Amazon Redshift cluster specified by the <code>ClusterIdentifier</code> parameter.
     */
    public final String snapshotIdentifier() {
        return snapshotIdentifier;
    }

    /**
     * <p>
     * The name of the source database that contains the table to restore from.
     * </p>
     * 
     * @return The name of the source database that contains the table to restore from.
     */
    public final String sourceDatabaseName() {
        return sourceDatabaseName;
    }

    /**
     * <p>
     * The name of the source schema that contains the table to restore from. If you do not specify a
     * <code>SourceSchemaName</code> value, the default is <code>public</code>.
     * </p>
     * 
     * @return The name of the source schema that contains the table to restore from. If you do not specify a
     *         <code>SourceSchemaName</code> value, the default is <code>public</code>.
     */
    public final String sourceSchemaName() {
        return sourceSchemaName;
    }

    /**
     * <p>
     * The name of the source table to restore from.
     * </p>
     * 
     * @return The name of the source table to restore from.
     */
    public final String sourceTableName() {
        return sourceTableName;
    }

    /**
     * <p>
     * The name of the database to restore the table to.
     * </p>
     * 
     * @return The name of the database to restore the table to.
     */
    public final String targetDatabaseName() {
        return targetDatabaseName;
    }

    /**
     * <p>
     * The name of the schema to restore the table to.
     * </p>
     * 
     * @return The name of the schema to restore the table to.
     */
    public final String targetSchemaName() {
        return targetSchemaName;
    }

    /**
     * <p>
     * The name of the table to create as a result of the current request.
     * </p>
     * 
     * @return The name of the table to create as a result of the current request.
     */
    public final String newTableName() {
        return newTableName;
    }

    /**
     * <p>
     * Indicates whether name identifiers for database, schema, and table are case sensitive. If <code>true</code>, the
     * names are case sensitive. If <code>false</code> (default), the names are not case sensitive.
     * </p>
     * 
     * @return Indicates whether name identifiers for database, schema, and table are case sensitive. If
     *         <code>true</code>, the names are case sensitive. If <code>false</code> (default), the names are not case
     *         sensitive.
     */
    public final Boolean enableCaseSensitiveIdentifier() {
        return enableCaseSensitiveIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(sourceDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceSchemaName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceTableName());
        hashCode = 31 * hashCode + Objects.hashCode(targetDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(targetSchemaName());
        hashCode = 31 * hashCode + Objects.hashCode(newTableName());
        hashCode = 31 * hashCode + Objects.hashCode(enableCaseSensitiveIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreTableFromClusterSnapshotRequest)) {
            return false;
        }
        RestoreTableFromClusterSnapshotRequest other = (RestoreTableFromClusterSnapshotRequest) obj;
        return Objects.equals(clusterIdentifier(), other.clusterIdentifier())
                && Objects.equals(snapshotIdentifier(), other.snapshotIdentifier())
                && Objects.equals(sourceDatabaseName(), other.sourceDatabaseName())
                && Objects.equals(sourceSchemaName(), other.sourceSchemaName())
                && Objects.equals(sourceTableName(), other.sourceTableName())
                && Objects.equals(targetDatabaseName(), other.targetDatabaseName())
                && Objects.equals(targetSchemaName(), other.targetSchemaName())
                && Objects.equals(newTableName(), other.newTableName())
                && Objects.equals(enableCaseSensitiveIdentifier(), other.enableCaseSensitiveIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RestoreTableFromClusterSnapshotRequest").add("ClusterIdentifier", clusterIdentifier())
                .add("SnapshotIdentifier", snapshotIdentifier()).add("SourceDatabaseName", sourceDatabaseName())
                .add("SourceSchemaName", sourceSchemaName()).add("SourceTableName", sourceTableName())
                .add("TargetDatabaseName", targetDatabaseName()).add("TargetSchemaName", targetSchemaName())
                .add("NewTableName", newTableName()).add("EnableCaseSensitiveIdentifier", enableCaseSensitiveIdentifier())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "SnapshotIdentifier":
            return Optional.ofNullable(clazz.cast(snapshotIdentifier()));
        case "SourceDatabaseName":
            return Optional.ofNullable(clazz.cast(sourceDatabaseName()));
        case "SourceSchemaName":
            return Optional.ofNullable(clazz.cast(sourceSchemaName()));
        case "SourceTableName":
            return Optional.ofNullable(clazz.cast(sourceTableName()));
        case "TargetDatabaseName":
            return Optional.ofNullable(clazz.cast(targetDatabaseName()));
        case "TargetSchemaName":
            return Optional.ofNullable(clazz.cast(targetSchemaName()));
        case "NewTableName":
            return Optional.ofNullable(clazz.cast(newTableName()));
        case "EnableCaseSensitiveIdentifier":
            return Optional.ofNullable(clazz.cast(enableCaseSensitiveIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClusterIdentifier", CLUSTER_IDENTIFIER_FIELD);
        map.put("SnapshotIdentifier", SNAPSHOT_IDENTIFIER_FIELD);
        map.put("SourceDatabaseName", SOURCE_DATABASE_NAME_FIELD);
        map.put("SourceSchemaName", SOURCE_SCHEMA_NAME_FIELD);
        map.put("SourceTableName", SOURCE_TABLE_NAME_FIELD);
        map.put("TargetDatabaseName", TARGET_DATABASE_NAME_FIELD);
        map.put("TargetSchemaName", TARGET_SCHEMA_NAME_FIELD);
        map.put("NewTableName", NEW_TABLE_NAME_FIELD);
        map.put("EnableCaseSensitiveIdentifier", ENABLE_CASE_SENSITIVE_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RestoreTableFromClusterSnapshotRequest, T> g) {
        return obj -> g.apply((RestoreTableFromClusterSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, RestoreTableFromClusterSnapshotRequest> {
        /**
         * <p>
         * The identifier of the Amazon Redshift cluster to restore the table to.
         * </p>
         * 
         * @param clusterIdentifier
         *        The identifier of the Amazon Redshift cluster to restore the table to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The identifier of the snapshot to restore the table from. This snapshot must have been created from the
         * Amazon Redshift cluster specified by the <code>ClusterIdentifier</code> parameter.
         * </p>
         * 
         * @param snapshotIdentifier
         *        The identifier of the snapshot to restore the table from. This snapshot must have been created from
         *        the Amazon Redshift cluster specified by the <code>ClusterIdentifier</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotIdentifier(String snapshotIdentifier);

        /**
         * <p>
         * The name of the source database that contains the table to restore from.
         * </p>
         * 
         * @param sourceDatabaseName
         *        The name of the source database that contains the table to restore from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDatabaseName(String sourceDatabaseName);

        /**
         * <p>
         * The name of the source schema that contains the table to restore from. If you do not specify a
         * <code>SourceSchemaName</code> value, the default is <code>public</code>.
         * </p>
         * 
         * @param sourceSchemaName
         *        The name of the source schema that contains the table to restore from. If you do not specify a
         *        <code>SourceSchemaName</code> value, the default is <code>public</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSchemaName(String sourceSchemaName);

        /**
         * <p>
         * The name of the source table to restore from.
         * </p>
         * 
         * @param sourceTableName
         *        The name of the source table to restore from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceTableName(String sourceTableName);

        /**
         * <p>
         * The name of the database to restore the table to.
         * </p>
         * 
         * @param targetDatabaseName
         *        The name of the database to restore the table to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetDatabaseName(String targetDatabaseName);

        /**
         * <p>
         * The name of the schema to restore the table to.
         * </p>
         * 
         * @param targetSchemaName
         *        The name of the schema to restore the table to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetSchemaName(String targetSchemaName);

        /**
         * <p>
         * The name of the table to create as a result of the current request.
         * </p>
         * 
         * @param newTableName
         *        The name of the table to create as a result of the current request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newTableName(String newTableName);

        /**
         * <p>
         * Indicates whether name identifiers for database, schema, and table are case sensitive. If <code>true</code>,
         * the names are case sensitive. If <code>false</code> (default), the names are not case sensitive.
         * </p>
         * 
         * @param enableCaseSensitiveIdentifier
         *        Indicates whether name identifiers for database, schema, and table are case sensitive. If
         *        <code>true</code>, the names are case sensitive. If <code>false</code> (default), the names are not
         *        case sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableCaseSensitiveIdentifier(Boolean enableCaseSensitiveIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String clusterIdentifier;

        private String snapshotIdentifier;

        private String sourceDatabaseName;

        private String sourceSchemaName;

        private String sourceTableName;

        private String targetDatabaseName;

        private String targetSchemaName;

        private String newTableName;

        private Boolean enableCaseSensitiveIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreTableFromClusterSnapshotRequest model) {
            super(model);
            clusterIdentifier(model.clusterIdentifier);
            snapshotIdentifier(model.snapshotIdentifier);
            sourceDatabaseName(model.sourceDatabaseName);
            sourceSchemaName(model.sourceSchemaName);
            sourceTableName(model.sourceTableName);
            targetDatabaseName(model.targetDatabaseName);
            targetSchemaName(model.targetSchemaName);
            newTableName(model.newTableName);
            enableCaseSensitiveIdentifier(model.enableCaseSensitiveIdentifier);
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getSnapshotIdentifier() {
            return snapshotIdentifier;
        }

        public final void setSnapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
        }

        @Override
        public final Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        public final String getSourceDatabaseName() {
            return sourceDatabaseName;
        }

        public final void setSourceDatabaseName(String sourceDatabaseName) {
            this.sourceDatabaseName = sourceDatabaseName;
        }

        @Override
        public final Builder sourceDatabaseName(String sourceDatabaseName) {
            this.sourceDatabaseName = sourceDatabaseName;
            return this;
        }

        public final String getSourceSchemaName() {
            return sourceSchemaName;
        }

        public final void setSourceSchemaName(String sourceSchemaName) {
            this.sourceSchemaName = sourceSchemaName;
        }

        @Override
        public final Builder sourceSchemaName(String sourceSchemaName) {
            this.sourceSchemaName = sourceSchemaName;
            return this;
        }

        public final String getSourceTableName() {
            return sourceTableName;
        }

        public final void setSourceTableName(String sourceTableName) {
            this.sourceTableName = sourceTableName;
        }

        @Override
        public final Builder sourceTableName(String sourceTableName) {
            this.sourceTableName = sourceTableName;
            return this;
        }

        public final String getTargetDatabaseName() {
            return targetDatabaseName;
        }

        public final void setTargetDatabaseName(String targetDatabaseName) {
            this.targetDatabaseName = targetDatabaseName;
        }

        @Override
        public final Builder targetDatabaseName(String targetDatabaseName) {
            this.targetDatabaseName = targetDatabaseName;
            return this;
        }

        public final String getTargetSchemaName() {
            return targetSchemaName;
        }

        public final void setTargetSchemaName(String targetSchemaName) {
            this.targetSchemaName = targetSchemaName;
        }

        @Override
        public final Builder targetSchemaName(String targetSchemaName) {
            this.targetSchemaName = targetSchemaName;
            return this;
        }

        public final String getNewTableName() {
            return newTableName;
        }

        public final void setNewTableName(String newTableName) {
            this.newTableName = newTableName;
        }

        @Override
        public final Builder newTableName(String newTableName) {
            this.newTableName = newTableName;
            return this;
        }

        public final Boolean getEnableCaseSensitiveIdentifier() {
            return enableCaseSensitiveIdentifier;
        }

        public final void setEnableCaseSensitiveIdentifier(Boolean enableCaseSensitiveIdentifier) {
            this.enableCaseSensitiveIdentifier = enableCaseSensitiveIdentifier;
        }

        @Override
        public final Builder enableCaseSensitiveIdentifier(Boolean enableCaseSensitiveIdentifier) {
            this.enableCaseSensitiveIdentifier = enableCaseSensitiveIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreTableFromClusterSnapshotRequest build() {
            return new RestoreTableFromClusterSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
