/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The identifier for a serverless namespace.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServerlessIdentifier implements SdkPojo, Serializable,
        ToCopyableBuilder<ServerlessIdentifier.Builder, ServerlessIdentifier> {
    private static final SdkField<String> NAMESPACE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NamespaceIdentifier").getter(getter(ServerlessIdentifier::namespaceIdentifier))
            .setter(setter(Builder::namespaceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamespaceIdentifier").build())
            .build();

    private static final SdkField<String> WORKGROUP_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkgroupIdentifier").getter(getter(ServerlessIdentifier::workgroupIdentifier))
            .setter(setter(Builder::workgroupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkgroupIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_IDENTIFIER_FIELD,
            WORKGROUP_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String namespaceIdentifier;

    private final String workgroupIdentifier;

    private ServerlessIdentifier(BuilderImpl builder) {
        this.namespaceIdentifier = builder.namespaceIdentifier;
        this.workgroupIdentifier = builder.workgroupIdentifier;
    }

    /**
     * <p>
     * The unique identifier for the serverless namespace.
     * </p>
     * 
     * @return The unique identifier for the serverless namespace.
     */
    public final String namespaceIdentifier() {
        return namespaceIdentifier;
    }

    /**
     * <p>
     * The unique identifier for the workgroup associated with the serverless namespace.
     * </p>
     * 
     * @return The unique identifier for the workgroup associated with the serverless namespace.
     */
    public final String workgroupIdentifier() {
        return workgroupIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(namespaceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(workgroupIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerlessIdentifier)) {
            return false;
        }
        ServerlessIdentifier other = (ServerlessIdentifier) obj;
        return Objects.equals(namespaceIdentifier(), other.namespaceIdentifier())
                && Objects.equals(workgroupIdentifier(), other.workgroupIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServerlessIdentifier").add("NamespaceIdentifier", namespaceIdentifier())
                .add("WorkgroupIdentifier", workgroupIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NamespaceIdentifier":
            return Optional.ofNullable(clazz.cast(namespaceIdentifier()));
        case "WorkgroupIdentifier":
            return Optional.ofNullable(clazz.cast(workgroupIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NamespaceIdentifier", NAMESPACE_IDENTIFIER_FIELD);
        map.put("WorkgroupIdentifier", WORKGROUP_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServerlessIdentifier, T> g) {
        return obj -> g.apply((ServerlessIdentifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServerlessIdentifier> {
        /**
         * <p>
         * The unique identifier for the serverless namespace.
         * </p>
         * 
         * @param namespaceIdentifier
         *        The unique identifier for the serverless namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceIdentifier(String namespaceIdentifier);

        /**
         * <p>
         * The unique identifier for the workgroup associated with the serverless namespace.
         * </p>
         * 
         * @param workgroupIdentifier
         *        The unique identifier for the workgroup associated with the serverless namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workgroupIdentifier(String workgroupIdentifier);
    }

    static final class BuilderImpl implements Builder {
        private String namespaceIdentifier;

        private String workgroupIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerlessIdentifier model) {
            namespaceIdentifier(model.namespaceIdentifier);
            workgroupIdentifier(model.workgroupIdentifier);
        }

        public final String getNamespaceIdentifier() {
            return namespaceIdentifier;
        }

        public final void setNamespaceIdentifier(String namespaceIdentifier) {
            this.namespaceIdentifier = namespaceIdentifier;
        }

        @Override
        public final Builder namespaceIdentifier(String namespaceIdentifier) {
            this.namespaceIdentifier = namespaceIdentifier;
            return this;
        }

        public final String getWorkgroupIdentifier() {
            return workgroupIdentifier;
        }

        public final void setWorkgroupIdentifier(String workgroupIdentifier) {
            this.workgroupIdentifier = workgroupIdentifier;
        }

        @Override
        public final Builder workgroupIdentifier(String workgroupIdentifier) {
            this.workgroupIdentifier = workgroupIdentifier;
            return this;
        }

        @Override
        public ServerlessIdentifier build() {
            return new ServerlessIdentifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
