/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a snapshot schedule. You can set a regular interval for creating snapshots of a cluster. You can also
 * schedule snapshots for specific dates.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnapshotSchedule implements SdkPojo, Serializable,
        ToCopyableBuilder<SnapshotSchedule.Builder, SnapshotSchedule> {
    private static final SdkField<List<String>> SCHEDULE_DEFINITIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ScheduleDefinitions")
            .getter(getter(SnapshotSchedule::scheduleDefinitions))
            .setter(setter(Builder::scheduleDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ScheduleDefinition")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ScheduleDefinition").build()).build()).build()).build();

    private static final SdkField<String> SCHEDULE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScheduleIdentifier").getter(getter(SnapshotSchedule::scheduleIdentifier))
            .setter(setter(Builder::scheduleIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleIdentifier").build())
            .build();

    private static final SdkField<String> SCHEDULE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScheduleDescription").getter(getter(SnapshotSchedule::scheduleDescription))
            .setter(setter(Builder::scheduleDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleDescription").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(SnapshotSchedule::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final SdkField<List<Instant>> NEXT_INVOCATIONS_FIELD = SdkField
            .<List<Instant>> builder(MarshallingType.LIST)
            .memberName("NextInvocations")
            .getter(getter(SnapshotSchedule::nextInvocations))
            .setter(setter(Builder::nextInvocations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextInvocations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SnapshotTime")
                            .memberFieldInfo(
                                    SdkField.<Instant> builder(MarshallingType.INSTANT)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SnapshotTime").build()).build()).build()).build();

    private static final SdkField<Integer> ASSOCIATED_CLUSTER_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AssociatedClusterCount").getter(getter(SnapshotSchedule::associatedClusterCount))
            .setter(setter(Builder::associatedClusterCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedClusterCount").build())
            .build();

    private static final SdkField<List<ClusterAssociatedToSchedule>> ASSOCIATED_CLUSTERS_FIELD = SdkField
            .<List<ClusterAssociatedToSchedule>> builder(MarshallingType.LIST)
            .memberName("AssociatedClusters")
            .getter(getter(SnapshotSchedule::associatedClusters))
            .setter(setter(Builder::associatedClusters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedClusters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ClusterAssociatedToSchedule")
                            .memberFieldInfo(
                                    SdkField.<ClusterAssociatedToSchedule> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClusterAssociatedToSchedule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ClusterAssociatedToSchedule").build()).build()).build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULE_DEFINITIONS_FIELD,
            SCHEDULE_IDENTIFIER_FIELD, SCHEDULE_DESCRIPTION_FIELD, TAGS_FIELD, NEXT_INVOCATIONS_FIELD,
            ASSOCIATED_CLUSTER_COUNT_FIELD, ASSOCIATED_CLUSTERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> scheduleDefinitions;

    private final String scheduleIdentifier;

    private final String scheduleDescription;

    private final List<Tag> tags;

    private final List<Instant> nextInvocations;

    private final Integer associatedClusterCount;

    private final List<ClusterAssociatedToSchedule> associatedClusters;

    private SnapshotSchedule(BuilderImpl builder) {
        this.scheduleDefinitions = builder.scheduleDefinitions;
        this.scheduleIdentifier = builder.scheduleIdentifier;
        this.scheduleDescription = builder.scheduleDescription;
        this.tags = builder.tags;
        this.nextInvocations = builder.nextInvocations;
        this.associatedClusterCount = builder.associatedClusterCount;
        this.associatedClusters = builder.associatedClusters;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScheduleDefinitions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasScheduleDefinitions() {
        return scheduleDefinitions != null && !(scheduleDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of ScheduleDefinitions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScheduleDefinitions} method.
     * </p>
     * 
     * @return A list of ScheduleDefinitions.
     */
    public final List<String> scheduleDefinitions() {
        return scheduleDefinitions;
    }

    /**
     * <p>
     * A unique identifier for the schedule.
     * </p>
     * 
     * @return A unique identifier for the schedule.
     */
    public final String scheduleIdentifier() {
        return scheduleIdentifier;
    }

    /**
     * <p>
     * The description of the schedule.
     * </p>
     * 
     * @return The description of the schedule.
     */
    public final String scheduleDescription() {
        return scheduleDescription;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An optional set of tags describing the schedule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An optional set of tags describing the schedule.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the NextInvocations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNextInvocations() {
        return nextInvocations != null && !(nextInvocations instanceof SdkAutoConstructList);
    }

    /**
     * <p/>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNextInvocations} method.
     * </p>
     * 
     * @return
     */
    public final List<Instant> nextInvocations() {
        return nextInvocations;
    }

    /**
     * <p>
     * The number of clusters associated with the schedule.
     * </p>
     * 
     * @return The number of clusters associated with the schedule.
     */
    public final Integer associatedClusterCount() {
        return associatedClusterCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociatedClusters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssociatedClusters() {
        return associatedClusters != null && !(associatedClusters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of clusters associated with the schedule. A maximum of 100 clusters is returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociatedClusters} method.
     * </p>
     * 
     * @return A list of clusters associated with the schedule. A maximum of 100 clusters is returned.
     */
    public final List<ClusterAssociatedToSchedule> associatedClusters() {
        return associatedClusters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasScheduleDefinitions() ? scheduleDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(scheduleIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleDescription());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNextInvocations() ? nextInvocations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(associatedClusterCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociatedClusters() ? associatedClusters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotSchedule)) {
            return false;
        }
        SnapshotSchedule other = (SnapshotSchedule) obj;
        return hasScheduleDefinitions() == other.hasScheduleDefinitions()
                && Objects.equals(scheduleDefinitions(), other.scheduleDefinitions())
                && Objects.equals(scheduleIdentifier(), other.scheduleIdentifier())
                && Objects.equals(scheduleDescription(), other.scheduleDescription()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasNextInvocations() == other.hasNextInvocations()
                && Objects.equals(nextInvocations(), other.nextInvocations())
                && Objects.equals(associatedClusterCount(), other.associatedClusterCount())
                && hasAssociatedClusters() == other.hasAssociatedClusters()
                && Objects.equals(associatedClusters(), other.associatedClusters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnapshotSchedule")
                .add("ScheduleDefinitions", hasScheduleDefinitions() ? scheduleDefinitions() : null)
                .add("ScheduleIdentifier", scheduleIdentifier()).add("ScheduleDescription", scheduleDescription())
                .add("Tags", hasTags() ? tags() : null).add("NextInvocations", hasNextInvocations() ? nextInvocations() : null)
                .add("AssociatedClusterCount", associatedClusterCount())
                .add("AssociatedClusters", hasAssociatedClusters() ? associatedClusters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScheduleDefinitions":
            return Optional.ofNullable(clazz.cast(scheduleDefinitions()));
        case "ScheduleIdentifier":
            return Optional.ofNullable(clazz.cast(scheduleIdentifier()));
        case "ScheduleDescription":
            return Optional.ofNullable(clazz.cast(scheduleDescription()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "NextInvocations":
            return Optional.ofNullable(clazz.cast(nextInvocations()));
        case "AssociatedClusterCount":
            return Optional.ofNullable(clazz.cast(associatedClusterCount()));
        case "AssociatedClusters":
            return Optional.ofNullable(clazz.cast(associatedClusters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ScheduleDefinitions", SCHEDULE_DEFINITIONS_FIELD);
        map.put("ScheduleIdentifier", SCHEDULE_IDENTIFIER_FIELD);
        map.put("ScheduleDescription", SCHEDULE_DESCRIPTION_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("NextInvocations", NEXT_INVOCATIONS_FIELD);
        map.put("AssociatedClusterCount", ASSOCIATED_CLUSTER_COUNT_FIELD);
        map.put("AssociatedClusters", ASSOCIATED_CLUSTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SnapshotSchedule, T> g) {
        return obj -> g.apply((SnapshotSchedule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnapshotSchedule> {
        /**
         * <p>
         * A list of ScheduleDefinitions.
         * </p>
         * 
         * @param scheduleDefinitions
         *        A list of ScheduleDefinitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleDefinitions(Collection<String> scheduleDefinitions);

        /**
         * <p>
         * A list of ScheduleDefinitions.
         * </p>
         * 
         * @param scheduleDefinitions
         *        A list of ScheduleDefinitions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleDefinitions(String... scheduleDefinitions);

        /**
         * <p>
         * A unique identifier for the schedule.
         * </p>
         * 
         * @param scheduleIdentifier
         *        A unique identifier for the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleIdentifier(String scheduleIdentifier);

        /**
         * <p>
         * The description of the schedule.
         * </p>
         * 
         * @param scheduleDescription
         *        The description of the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleDescription(String scheduleDescription);

        /**
         * <p>
         * An optional set of tags describing the schedule.
         * </p>
         * 
         * @param tags
         *        An optional set of tags describing the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An optional set of tags describing the schedule.
         * </p>
         * 
         * @param tags
         *        An optional set of tags describing the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An optional set of tags describing the schedule.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshift.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.redshift.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshift.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshift.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p/>
         * 
         * @param nextInvocations
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextInvocations(Collection<Instant> nextInvocations);

        /**
         * <p/>
         * 
         * @param nextInvocations
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextInvocations(Instant... nextInvocations);

        /**
         * <p>
         * The number of clusters associated with the schedule.
         * </p>
         * 
         * @param associatedClusterCount
         *        The number of clusters associated with the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedClusterCount(Integer associatedClusterCount);

        /**
         * <p>
         * A list of clusters associated with the schedule. A maximum of 100 clusters is returned.
         * </p>
         * 
         * @param associatedClusters
         *        A list of clusters associated with the schedule. A maximum of 100 clusters is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedClusters(Collection<ClusterAssociatedToSchedule> associatedClusters);

        /**
         * <p>
         * A list of clusters associated with the schedule. A maximum of 100 clusters is returned.
         * </p>
         * 
         * @param associatedClusters
         *        A list of clusters associated with the schedule. A maximum of 100 clusters is returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedClusters(ClusterAssociatedToSchedule... associatedClusters);

        /**
         * <p>
         * A list of clusters associated with the schedule. A maximum of 100 clusters is returned.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshift.model.ClusterAssociatedToSchedule.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.redshift.model.ClusterAssociatedToSchedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshift.model.ClusterAssociatedToSchedule.Builder#build()} is called
         * immediately and its result is passed to {@link #associatedClusters(List<ClusterAssociatedToSchedule>)}.
         * 
         * @param associatedClusters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshift.model.ClusterAssociatedToSchedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associatedClusters(java.util.Collection<ClusterAssociatedToSchedule>)
         */
        Builder associatedClusters(Consumer<ClusterAssociatedToSchedule.Builder>... associatedClusters);
    }

    static final class BuilderImpl implements Builder {
        private List<String> scheduleDefinitions = DefaultSdkAutoConstructList.getInstance();

        private String scheduleIdentifier;

        private String scheduleDescription;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private List<Instant> nextInvocations = DefaultSdkAutoConstructList.getInstance();

        private Integer associatedClusterCount;

        private List<ClusterAssociatedToSchedule> associatedClusters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotSchedule model) {
            scheduleDefinitions(model.scheduleDefinitions);
            scheduleIdentifier(model.scheduleIdentifier);
            scheduleDescription(model.scheduleDescription);
            tags(model.tags);
            nextInvocations(model.nextInvocations);
            associatedClusterCount(model.associatedClusterCount);
            associatedClusters(model.associatedClusters);
        }

        public final Collection<String> getScheduleDefinitions() {
            if (scheduleDefinitions instanceof SdkAutoConstructList) {
                return null;
            }
            return scheduleDefinitions;
        }

        public final void setScheduleDefinitions(Collection<String> scheduleDefinitions) {
            this.scheduleDefinitions = ScheduleDefinitionListCopier.copy(scheduleDefinitions);
        }

        @Override
        public final Builder scheduleDefinitions(Collection<String> scheduleDefinitions) {
            this.scheduleDefinitions = ScheduleDefinitionListCopier.copy(scheduleDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduleDefinitions(String... scheduleDefinitions) {
            scheduleDefinitions(Arrays.asList(scheduleDefinitions));
            return this;
        }

        public final String getScheduleIdentifier() {
            return scheduleIdentifier;
        }

        public final void setScheduleIdentifier(String scheduleIdentifier) {
            this.scheduleIdentifier = scheduleIdentifier;
        }

        @Override
        public final Builder scheduleIdentifier(String scheduleIdentifier) {
            this.scheduleIdentifier = scheduleIdentifier;
            return this;
        }

        public final String getScheduleDescription() {
            return scheduleDescription;
        }

        public final void setScheduleDescription(String scheduleDescription) {
            this.scheduleDescription = scheduleDescription;
        }

        @Override
        public final Builder scheduleDescription(String scheduleDescription) {
            this.scheduleDescription = scheduleDescription;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<Instant> getNextInvocations() {
            if (nextInvocations instanceof SdkAutoConstructList) {
                return null;
            }
            return nextInvocations;
        }

        public final void setNextInvocations(Collection<Instant> nextInvocations) {
            this.nextInvocations = ScheduledSnapshotTimeListCopier.copy(nextInvocations);
        }

        @Override
        public final Builder nextInvocations(Collection<Instant> nextInvocations) {
            this.nextInvocations = ScheduledSnapshotTimeListCopier.copy(nextInvocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nextInvocations(Instant... nextInvocations) {
            nextInvocations(Arrays.asList(nextInvocations));
            return this;
        }

        public final Integer getAssociatedClusterCount() {
            return associatedClusterCount;
        }

        public final void setAssociatedClusterCount(Integer associatedClusterCount) {
            this.associatedClusterCount = associatedClusterCount;
        }

        @Override
        public final Builder associatedClusterCount(Integer associatedClusterCount) {
            this.associatedClusterCount = associatedClusterCount;
            return this;
        }

        public final List<ClusterAssociatedToSchedule.Builder> getAssociatedClusters() {
            List<ClusterAssociatedToSchedule.Builder> result = AssociatedClusterListCopier.copyToBuilder(this.associatedClusters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociatedClusters(Collection<ClusterAssociatedToSchedule.BuilderImpl> associatedClusters) {
            this.associatedClusters = AssociatedClusterListCopier.copyFromBuilder(associatedClusters);
        }

        @Override
        public final Builder associatedClusters(Collection<ClusterAssociatedToSchedule> associatedClusters) {
            this.associatedClusters = AssociatedClusterListCopier.copy(associatedClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedClusters(ClusterAssociatedToSchedule... associatedClusters) {
            associatedClusters(Arrays.asList(associatedClusters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedClusters(Consumer<ClusterAssociatedToSchedule.Builder>... associatedClusters) {
            associatedClusters(Stream.of(associatedClusters)
                    .map(c -> ClusterAssociatedToSchedule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SnapshotSchedule build() {
            return new SnapshotSchedule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
