/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.ApplicationType;
import software.amazon.awssdk.services.redshift.model.AuthorizedTokenIssuer;
import software.amazon.awssdk.services.redshift.model.AuthorizedTokenIssuerListCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.services.redshift.model.ServiceIntegrationListCopier;
import software.amazon.awssdk.services.redshift.model.ServiceIntegrationsUnion;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.model.TagKeyListCopier;
import software.amazon.awssdk.services.redshift.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRedshiftIdcApplicationRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, CreateRedshiftIdcApplicationRequest> {
    private static final SdkField<String> IDC_INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdcInstanceArn").getter(CreateRedshiftIdcApplicationRequest.getter(CreateRedshiftIdcApplicationRequest::idcInstanceArn)).setter(CreateRedshiftIdcApplicationRequest.setter(Builder::idcInstanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdcInstanceArn").build()}).build();
    private static final SdkField<String> REDSHIFT_IDC_APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RedshiftIdcApplicationName").getter(CreateRedshiftIdcApplicationRequest.getter(CreateRedshiftIdcApplicationRequest::redshiftIdcApplicationName)).setter(CreateRedshiftIdcApplicationRequest.setter(Builder::redshiftIdcApplicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftIdcApplicationName").build()}).build();
    private static final SdkField<String> IDENTITY_NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityNamespace").getter(CreateRedshiftIdcApplicationRequest.getter(CreateRedshiftIdcApplicationRequest::identityNamespace)).setter(CreateRedshiftIdcApplicationRequest.setter(Builder::identityNamespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityNamespace").build()}).build();
    private static final SdkField<String> IDC_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdcDisplayName").getter(CreateRedshiftIdcApplicationRequest.getter(CreateRedshiftIdcApplicationRequest::idcDisplayName)).setter(CreateRedshiftIdcApplicationRequest.setter(Builder::idcDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdcDisplayName").build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRoleArn").getter(CreateRedshiftIdcApplicationRequest.getter(CreateRedshiftIdcApplicationRequest::iamRoleArn)).setter(CreateRedshiftIdcApplicationRequest.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final SdkField<List<AuthorizedTokenIssuer>> AUTHORIZED_TOKEN_ISSUER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AuthorizedTokenIssuerList").getter(CreateRedshiftIdcApplicationRequest.getter(CreateRedshiftIdcApplicationRequest::authorizedTokenIssuerList)).setter(CreateRedshiftIdcApplicationRequest.setter(Builder::authorizedTokenIssuerList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedTokenIssuerList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AuthorizedTokenIssuer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ServiceIntegrationsUnion>> SERVICE_INTEGRATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ServiceIntegrations").getter(CreateRedshiftIdcApplicationRequest.getter(CreateRedshiftIdcApplicationRequest::serviceIntegrations)).setter(CreateRedshiftIdcApplicationRequest.setter(Builder::serviceIntegrations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceIntegrations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceIntegrationsUnion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> APPLICATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationType").getter(CreateRedshiftIdcApplicationRequest.getter(CreateRedshiftIdcApplicationRequest::applicationTypeAsString)).setter(CreateRedshiftIdcApplicationRequest.setter(Builder::applicationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationType").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateRedshiftIdcApplicationRequest.getter(CreateRedshiftIdcApplicationRequest::tags)).setter(CreateRedshiftIdcApplicationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SSO_TAG_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SsoTagKeys").getter(CreateRedshiftIdcApplicationRequest.getter(CreateRedshiftIdcApplicationRequest::ssoTagKeys)).setter(CreateRedshiftIdcApplicationRequest.setter(Builder::ssoTagKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SsoTagKeys").build(), ListTrait.builder().memberLocationName("TagKey").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagKey").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDC_INSTANCE_ARN_FIELD, REDSHIFT_IDC_APPLICATION_NAME_FIELD, IDENTITY_NAMESPACE_FIELD, IDC_DISPLAY_NAME_FIELD, IAM_ROLE_ARN_FIELD, AUTHORIZED_TOKEN_ISSUER_LIST_FIELD, SERVICE_INTEGRATIONS_FIELD, APPLICATION_TYPE_FIELD, TAGS_FIELD, SSO_TAG_KEYS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateRedshiftIdcApplicationRequest.memberNameToFieldInitializer();
    private final String idcInstanceArn;
    private final String redshiftIdcApplicationName;
    private final String identityNamespace;
    private final String idcDisplayName;
    private final String iamRoleArn;
    private final List<AuthorizedTokenIssuer> authorizedTokenIssuerList;
    private final List<ServiceIntegrationsUnion> serviceIntegrations;
    private final String applicationType;
    private final List<Tag> tags;
    private final List<String> ssoTagKeys;

    private CreateRedshiftIdcApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.idcInstanceArn = builder.idcInstanceArn;
        this.redshiftIdcApplicationName = builder.redshiftIdcApplicationName;
        this.identityNamespace = builder.identityNamespace;
        this.idcDisplayName = builder.idcDisplayName;
        this.iamRoleArn = builder.iamRoleArn;
        this.authorizedTokenIssuerList = builder.authorizedTokenIssuerList;
        this.serviceIntegrations = builder.serviceIntegrations;
        this.applicationType = builder.applicationType;
        this.tags = builder.tags;
        this.ssoTagKeys = builder.ssoTagKeys;
    }

    public final String idcInstanceArn() {
        return this.idcInstanceArn;
    }

    public final String redshiftIdcApplicationName() {
        return this.redshiftIdcApplicationName;
    }

    public final String identityNamespace() {
        return this.identityNamespace;
    }

    public final String idcDisplayName() {
        return this.idcDisplayName;
    }

    public final String iamRoleArn() {
        return this.iamRoleArn;
    }

    public final boolean hasAuthorizedTokenIssuerList() {
        return this.authorizedTokenIssuerList != null && !(this.authorizedTokenIssuerList instanceof SdkAutoConstructList);
    }

    public final List<AuthorizedTokenIssuer> authorizedTokenIssuerList() {
        return this.authorizedTokenIssuerList;
    }

    public final boolean hasServiceIntegrations() {
        return this.serviceIntegrations != null && !(this.serviceIntegrations instanceof SdkAutoConstructList);
    }

    public final List<ServiceIntegrationsUnion> serviceIntegrations() {
        return this.serviceIntegrations;
    }

    public final ApplicationType applicationType() {
        return ApplicationType.fromValue(this.applicationType);
    }

    public final String applicationTypeAsString() {
        return this.applicationType;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final boolean hasSsoTagKeys() {
        return this.ssoTagKeys != null && !(this.ssoTagKeys instanceof SdkAutoConstructList);
    }

    public final List<String> ssoTagKeys() {
        return this.ssoTagKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.idcInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftIdcApplicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.idcDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuthorizedTokenIssuerList() ? this.authorizedTokenIssuerList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceIntegrations() ? this.serviceIntegrations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSsoTagKeys() ? this.ssoTagKeys() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRedshiftIdcApplicationRequest)) {
            return false;
        }
        CreateRedshiftIdcApplicationRequest other = (CreateRedshiftIdcApplicationRequest)((Object)obj);
        return Objects.equals(this.idcInstanceArn(), other.idcInstanceArn()) && Objects.equals(this.redshiftIdcApplicationName(), other.redshiftIdcApplicationName()) && Objects.equals(this.identityNamespace(), other.identityNamespace()) && Objects.equals(this.idcDisplayName(), other.idcDisplayName()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && this.hasAuthorizedTokenIssuerList() == other.hasAuthorizedTokenIssuerList() && Objects.equals(this.authorizedTokenIssuerList(), other.authorizedTokenIssuerList()) && this.hasServiceIntegrations() == other.hasServiceIntegrations() && Objects.equals(this.serviceIntegrations(), other.serviceIntegrations()) && Objects.equals(this.applicationTypeAsString(), other.applicationTypeAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasSsoTagKeys() == other.hasSsoTagKeys() && Objects.equals(this.ssoTagKeys(), other.ssoTagKeys());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRedshiftIdcApplicationRequest").add("IdcInstanceArn", (Object)this.idcInstanceArn()).add("RedshiftIdcApplicationName", (Object)this.redshiftIdcApplicationName()).add("IdentityNamespace", (Object)this.identityNamespace()).add("IdcDisplayName", (Object)this.idcDisplayName()).add("IamRoleArn", (Object)this.iamRoleArn()).add("AuthorizedTokenIssuerList", this.hasAuthorizedTokenIssuerList() ? this.authorizedTokenIssuerList() : null).add("ServiceIntegrations", this.hasServiceIntegrations() ? this.serviceIntegrations() : null).add("ApplicationType", (Object)this.applicationTypeAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("SsoTagKeys", this.hasSsoTagKeys() ? this.ssoTagKeys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IdcInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.idcInstanceArn()));
            }
            case "RedshiftIdcApplicationName": {
                return Optional.ofNullable(clazz.cast(this.redshiftIdcApplicationName()));
            }
            case "IdentityNamespace": {
                return Optional.ofNullable(clazz.cast(this.identityNamespace()));
            }
            case "IdcDisplayName": {
                return Optional.ofNullable(clazz.cast(this.idcDisplayName()));
            }
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "AuthorizedTokenIssuerList": {
                return Optional.ofNullable(clazz.cast(this.authorizedTokenIssuerList()));
            }
            case "ServiceIntegrations": {
                return Optional.ofNullable(clazz.cast(this.serviceIntegrations()));
            }
            case "ApplicationType": {
                return Optional.ofNullable(clazz.cast(this.applicationTypeAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "SsoTagKeys": {
                return Optional.ofNullable(clazz.cast(this.ssoTagKeys()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IdcInstanceArn", IDC_INSTANCE_ARN_FIELD);
        map.put("RedshiftIdcApplicationName", REDSHIFT_IDC_APPLICATION_NAME_FIELD);
        map.put("IdentityNamespace", IDENTITY_NAMESPACE_FIELD);
        map.put("IdcDisplayName", IDC_DISPLAY_NAME_FIELD);
        map.put("IamRoleArn", IAM_ROLE_ARN_FIELD);
        map.put("AuthorizedTokenIssuerList", AUTHORIZED_TOKEN_ISSUER_LIST_FIELD);
        map.put("ServiceIntegrations", SERVICE_INTEGRATIONS_FIELD);
        map.put("ApplicationType", APPLICATION_TYPE_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("SsoTagKeys", SSO_TAG_KEYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRedshiftIdcApplicationRequest, T> g) {
        return obj -> g.apply((CreateRedshiftIdcApplicationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String idcInstanceArn;
        private String redshiftIdcApplicationName;
        private String identityNamespace;
        private String idcDisplayName;
        private String iamRoleArn;
        private List<AuthorizedTokenIssuer> authorizedTokenIssuerList = DefaultSdkAutoConstructList.getInstance();
        private List<ServiceIntegrationsUnion> serviceIntegrations = DefaultSdkAutoConstructList.getInstance();
        private String applicationType;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<String> ssoTagKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRedshiftIdcApplicationRequest model) {
            super(model);
            this.idcInstanceArn(model.idcInstanceArn);
            this.redshiftIdcApplicationName(model.redshiftIdcApplicationName);
            this.identityNamespace(model.identityNamespace);
            this.idcDisplayName(model.idcDisplayName);
            this.iamRoleArn(model.iamRoleArn);
            this.authorizedTokenIssuerList(model.authorizedTokenIssuerList);
            this.serviceIntegrations(model.serviceIntegrations);
            this.applicationType(model.applicationType);
            this.tags(model.tags);
            this.ssoTagKeys(model.ssoTagKeys);
        }

        public final String getIdcInstanceArn() {
            return this.idcInstanceArn;
        }

        public final void setIdcInstanceArn(String idcInstanceArn) {
            this.idcInstanceArn = idcInstanceArn;
        }

        @Override
        public final Builder idcInstanceArn(String idcInstanceArn) {
            this.idcInstanceArn = idcInstanceArn;
            return this;
        }

        public final String getRedshiftIdcApplicationName() {
            return this.redshiftIdcApplicationName;
        }

        public final void setRedshiftIdcApplicationName(String redshiftIdcApplicationName) {
            this.redshiftIdcApplicationName = redshiftIdcApplicationName;
        }

        @Override
        public final Builder redshiftIdcApplicationName(String redshiftIdcApplicationName) {
            this.redshiftIdcApplicationName = redshiftIdcApplicationName;
            return this;
        }

        public final String getIdentityNamespace() {
            return this.identityNamespace;
        }

        public final void setIdentityNamespace(String identityNamespace) {
            this.identityNamespace = identityNamespace;
        }

        @Override
        public final Builder identityNamespace(String identityNamespace) {
            this.identityNamespace = identityNamespace;
            return this;
        }

        public final String getIdcDisplayName() {
            return this.idcDisplayName;
        }

        public final void setIdcDisplayName(String idcDisplayName) {
            this.idcDisplayName = idcDisplayName;
        }

        @Override
        public final Builder idcDisplayName(String idcDisplayName) {
            this.idcDisplayName = idcDisplayName;
            return this;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final List<AuthorizedTokenIssuer.Builder> getAuthorizedTokenIssuerList() {
            List<AuthorizedTokenIssuer.Builder> result = AuthorizedTokenIssuerListCopier.copyToBuilder(this.authorizedTokenIssuerList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAuthorizedTokenIssuerList(Collection<AuthorizedTokenIssuer.BuilderImpl> authorizedTokenIssuerList) {
            this.authorizedTokenIssuerList = AuthorizedTokenIssuerListCopier.copyFromBuilder(authorizedTokenIssuerList);
        }

        @Override
        public final Builder authorizedTokenIssuerList(Collection<AuthorizedTokenIssuer> authorizedTokenIssuerList) {
            this.authorizedTokenIssuerList = AuthorizedTokenIssuerListCopier.copy(authorizedTokenIssuerList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedTokenIssuerList(AuthorizedTokenIssuer ... authorizedTokenIssuerList) {
            this.authorizedTokenIssuerList(Arrays.asList(authorizedTokenIssuerList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedTokenIssuerList(Consumer<AuthorizedTokenIssuer.Builder> ... authorizedTokenIssuerList) {
            this.authorizedTokenIssuerList(Stream.of(authorizedTokenIssuerList).map(c -> (AuthorizedTokenIssuer)((AuthorizedTokenIssuer.Builder)AuthorizedTokenIssuer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ServiceIntegrationsUnion.Builder> getServiceIntegrations() {
            List<ServiceIntegrationsUnion.Builder> result = ServiceIntegrationListCopier.copyToBuilder(this.serviceIntegrations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceIntegrations(Collection<ServiceIntegrationsUnion.BuilderImpl> serviceIntegrations) {
            this.serviceIntegrations = ServiceIntegrationListCopier.copyFromBuilder(serviceIntegrations);
        }

        @Override
        public final Builder serviceIntegrations(Collection<ServiceIntegrationsUnion> serviceIntegrations) {
            this.serviceIntegrations = ServiceIntegrationListCopier.copy(serviceIntegrations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceIntegrations(ServiceIntegrationsUnion ... serviceIntegrations) {
            this.serviceIntegrations(Arrays.asList(serviceIntegrations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceIntegrations(Consumer<ServiceIntegrationsUnion.Builder> ... serviceIntegrations) {
            this.serviceIntegrations(Stream.of(serviceIntegrations).map(c -> (ServiceIntegrationsUnion)((ServiceIntegrationsUnion.Builder)ServiceIntegrationsUnion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getApplicationType() {
            return this.applicationType;
        }

        public final void setApplicationType(String applicationType) {
            this.applicationType = applicationType;
        }

        @Override
        public final Builder applicationType(String applicationType) {
            this.applicationType = applicationType;
            return this;
        }

        @Override
        public final Builder applicationType(ApplicationType applicationType) {
            this.applicationType(applicationType == null ? null : applicationType.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSsoTagKeys() {
            if (this.ssoTagKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ssoTagKeys;
        }

        public final void setSsoTagKeys(Collection<String> ssoTagKeys) {
            this.ssoTagKeys = TagKeyListCopier.copy(ssoTagKeys);
        }

        @Override
        public final Builder ssoTagKeys(Collection<String> ssoTagKeys) {
            this.ssoTagKeys = TagKeyListCopier.copy(ssoTagKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ssoTagKeys(String ... ssoTagKeys) {
            this.ssoTagKeys(Arrays.asList(ssoTagKeys));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRedshiftIdcApplicationRequest build() {
            return new CreateRedshiftIdcApplicationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRedshiftIdcApplicationRequest> {
        public Builder idcInstanceArn(String var1);

        public Builder redshiftIdcApplicationName(String var1);

        public Builder identityNamespace(String var1);

        public Builder idcDisplayName(String var1);

        public Builder iamRoleArn(String var1);

        public Builder authorizedTokenIssuerList(Collection<AuthorizedTokenIssuer> var1);

        public Builder authorizedTokenIssuerList(AuthorizedTokenIssuer ... var1);

        public Builder authorizedTokenIssuerList(Consumer<AuthorizedTokenIssuer.Builder> ... var1);

        public Builder serviceIntegrations(Collection<ServiceIntegrationsUnion> var1);

        public Builder serviceIntegrations(ServiceIntegrationsUnion ... var1);

        public Builder serviceIntegrations(Consumer<ServiceIntegrationsUnion.Builder> ... var1);

        public Builder applicationType(String var1);

        public Builder applicationType(ApplicationType var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder ssoTagKeys(Collection<String> var1);

        public Builder ssoTagKeys(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

