/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.ClusterNode;
import software.amazon.awssdk.services.redshift.model.ClusterNodesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SecondaryClusterInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SecondaryClusterInfo> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(SecondaryClusterInfo.getter(SecondaryClusterInfo::availabilityZone)).setter(SecondaryClusterInfo.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final SdkField<List<ClusterNode>> CLUSTER_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ClusterNodes").getter(SecondaryClusterInfo.getter(SecondaryClusterInfo::clusterNodes)).setter(SecondaryClusterInfo.setter(Builder::clusterNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterNodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterNode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD, CLUSTER_NODES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SecondaryClusterInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String availabilityZone;
    private final List<ClusterNode> clusterNodes;

    private SecondaryClusterInfo(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.clusterNodes = builder.clusterNodes;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final boolean hasClusterNodes() {
        return this.clusterNodes != null && !(this.clusterNodes instanceof SdkAutoConstructList);
    }

    public final List<ClusterNode> clusterNodes() {
        return this.clusterNodes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClusterNodes() ? this.clusterNodes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecondaryClusterInfo)) {
            return false;
        }
        SecondaryClusterInfo other = (SecondaryClusterInfo)obj;
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && this.hasClusterNodes() == other.hasClusterNodes() && Objects.equals(this.clusterNodes(), other.clusterNodes());
    }

    public final String toString() {
        return ToString.builder((String)"SecondaryClusterInfo").add("AvailabilityZone", (Object)this.availabilityZone()).add("ClusterNodes", this.hasClusterNodes() ? this.clusterNodes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "ClusterNodes": {
                return Optional.ofNullable(clazz.cast(this.clusterNodes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("ClusterNodes", CLUSTER_NODES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SecondaryClusterInfo, T> g) {
        return obj -> g.apply((SecondaryClusterInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String availabilityZone;
        private List<ClusterNode> clusterNodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SecondaryClusterInfo model) {
            this.availabilityZone(model.availabilityZone);
            this.clusterNodes(model.clusterNodes);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final List<ClusterNode.Builder> getClusterNodes() {
            List<ClusterNode.Builder> result = ClusterNodesListCopier.copyToBuilder(this.clusterNodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusterNodes(Collection<ClusterNode.BuilderImpl> clusterNodes) {
            this.clusterNodes = ClusterNodesListCopier.copyFromBuilder(clusterNodes);
        }

        @Override
        public final Builder clusterNodes(Collection<ClusterNode> clusterNodes) {
            this.clusterNodes = ClusterNodesListCopier.copy(clusterNodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterNodes(ClusterNode ... clusterNodes) {
            this.clusterNodes(Arrays.asList(clusterNodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterNodes(Consumer<ClusterNode.Builder> ... clusterNodes) {
            this.clusterNodes(Stream.of(clusterNodes).map(c -> (ClusterNode)((ClusterNode.Builder)ClusterNode.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SecondaryClusterInfo build() {
            return new SecondaryClusterInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SecondaryClusterInfo> {
        public Builder availabilityZone(String var1);

        public Builder clusterNodes(Collection<ClusterNode> var1);

        public Builder clusterNodes(ClusterNode ... var1);

        public Builder clusterNodes(Consumer<ClusterNode.Builder> ... var1);
    }
}

