/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftdata.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshiftdata.RedshiftDataClient;
import software.amazon.awssdk.services.redshiftdata.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshiftdata.model.GetStatementResultV2Request;
import software.amazon.awssdk.services.redshiftdata.model.GetStatementResultV2Response;
import software.amazon.awssdk.services.redshiftdata.model.QueryRecords;

public class GetStatementResultV2Iterable
implements SdkIterable<GetStatementResultV2Response> {
    private final RedshiftDataClient client;
    private final GetStatementResultV2Request firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetStatementResultV2Iterable(RedshiftDataClient client, GetStatementResultV2Request firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetStatementResultV2ResponseFetcher();
    }

    public Iterator<GetStatementResultV2Response> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<QueryRecords> records() {
        Function<GetStatementResultV2Response, Iterator> getIterator = response -> {
            if (response != null && response.records() != null) {
                return response.records().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetStatementResultV2ResponseFetcher
    implements SyncPageFetcher<GetStatementResultV2Response> {
        private GetStatementResultV2ResponseFetcher() {
        }

        public boolean hasNextPage(GetStatementResultV2Response previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetStatementResultV2Response nextPage(GetStatementResultV2Response previousPage) {
            if (previousPage == null) {
                return GetStatementResultV2Iterable.this.client.getStatementResultV2(GetStatementResultV2Iterable.this.firstRequest);
            }
            return GetStatementResultV2Iterable.this.client.getStatementResultV2((GetStatementResultV2Request)((Object)GetStatementResultV2Iterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

