/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshiftserverless.model.LakehouseIdcRegistration;
import software.amazon.awssdk.services.redshiftserverless.model.LakehouseRegistration;
import software.amazon.awssdk.services.redshiftserverless.model.RedshiftServerlessRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateLakehouseConfigurationRequest
extends RedshiftServerlessRequest
implements ToCopyableBuilder<Builder, UpdateLakehouseConfigurationRequest> {
    private static final SdkField<String> CATALOG_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("catalogName").getter(UpdateLakehouseConfigurationRequest.getter(UpdateLakehouseConfigurationRequest::catalogName)).setter(UpdateLakehouseConfigurationRequest.setter(Builder::catalogName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("catalogName").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("dryRun").getter(UpdateLakehouseConfigurationRequest.getter(UpdateLakehouseConfigurationRequest::dryRun)).setter(UpdateLakehouseConfigurationRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dryRun").build()}).build();
    private static final SdkField<String> LAKEHOUSE_IDC_APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lakehouseIdcApplicationArn").getter(UpdateLakehouseConfigurationRequest.getter(UpdateLakehouseConfigurationRequest::lakehouseIdcApplicationArn)).setter(UpdateLakehouseConfigurationRequest.setter(Builder::lakehouseIdcApplicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lakehouseIdcApplicationArn").build()}).build();
    private static final SdkField<String> LAKEHOUSE_IDC_REGISTRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lakehouseIdcRegistration").getter(UpdateLakehouseConfigurationRequest.getter(UpdateLakehouseConfigurationRequest::lakehouseIdcRegistrationAsString)).setter(UpdateLakehouseConfigurationRequest.setter(Builder::lakehouseIdcRegistration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lakehouseIdcRegistration").build()}).build();
    private static final SdkField<String> LAKEHOUSE_REGISTRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lakehouseRegistration").getter(UpdateLakehouseConfigurationRequest.getter(UpdateLakehouseConfigurationRequest::lakehouseRegistrationAsString)).setter(UpdateLakehouseConfigurationRequest.setter(Builder::lakehouseRegistration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lakehouseRegistration").build()}).build();
    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespaceName").getter(UpdateLakehouseConfigurationRequest.getter(UpdateLakehouseConfigurationRequest::namespaceName)).setter(UpdateLakehouseConfigurationRequest.setter(Builder::namespaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_NAME_FIELD, DRY_RUN_FIELD, LAKEHOUSE_IDC_APPLICATION_ARN_FIELD, LAKEHOUSE_IDC_REGISTRATION_FIELD, LAKEHOUSE_REGISTRATION_FIELD, NAMESPACE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateLakehouseConfigurationRequest.memberNameToFieldInitializer();
    private final String catalogName;
    private final Boolean dryRun;
    private final String lakehouseIdcApplicationArn;
    private final String lakehouseIdcRegistration;
    private final String lakehouseRegistration;
    private final String namespaceName;

    private UpdateLakehouseConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.catalogName = builder.catalogName;
        this.dryRun = builder.dryRun;
        this.lakehouseIdcApplicationArn = builder.lakehouseIdcApplicationArn;
        this.lakehouseIdcRegistration = builder.lakehouseIdcRegistration;
        this.lakehouseRegistration = builder.lakehouseRegistration;
        this.namespaceName = builder.namespaceName;
    }

    public final String catalogName() {
        return this.catalogName;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String lakehouseIdcApplicationArn() {
        return this.lakehouseIdcApplicationArn;
    }

    public final LakehouseIdcRegistration lakehouseIdcRegistration() {
        return LakehouseIdcRegistration.fromValue(this.lakehouseIdcRegistration);
    }

    public final String lakehouseIdcRegistrationAsString() {
        return this.lakehouseIdcRegistration;
    }

    public final LakehouseRegistration lakehouseRegistration() {
        return LakehouseRegistration.fromValue(this.lakehouseRegistration);
    }

    public final String lakehouseRegistrationAsString() {
        return this.lakehouseRegistration;
    }

    public final String namespaceName() {
        return this.namespaceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.lakehouseIdcApplicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lakehouseIdcRegistrationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lakehouseRegistrationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLakehouseConfigurationRequest)) {
            return false;
        }
        UpdateLakehouseConfigurationRequest other = (UpdateLakehouseConfigurationRequest)((Object)obj);
        return Objects.equals(this.catalogName(), other.catalogName()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.lakehouseIdcApplicationArn(), other.lakehouseIdcApplicationArn()) && Objects.equals(this.lakehouseIdcRegistrationAsString(), other.lakehouseIdcRegistrationAsString()) && Objects.equals(this.lakehouseRegistrationAsString(), other.lakehouseRegistrationAsString()) && Objects.equals(this.namespaceName(), other.namespaceName());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateLakehouseConfigurationRequest").add("CatalogName", (Object)this.catalogName()).add("DryRun", (Object)this.dryRun()).add("LakehouseIdcApplicationArn", (Object)this.lakehouseIdcApplicationArn()).add("LakehouseIdcRegistration", (Object)this.lakehouseIdcRegistrationAsString()).add("LakehouseRegistration", (Object)this.lakehouseRegistrationAsString()).add("NamespaceName", (Object)this.namespaceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "catalogName": {
                return Optional.ofNullable(clazz.cast(this.catalogName()));
            }
            case "dryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "lakehouseIdcApplicationArn": {
                return Optional.ofNullable(clazz.cast(this.lakehouseIdcApplicationArn()));
            }
            case "lakehouseIdcRegistration": {
                return Optional.ofNullable(clazz.cast(this.lakehouseIdcRegistrationAsString()));
            }
            case "lakehouseRegistration": {
                return Optional.ofNullable(clazz.cast(this.lakehouseRegistrationAsString()));
            }
            case "namespaceName": {
                return Optional.ofNullable(clazz.cast(this.namespaceName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("catalogName", CATALOG_NAME_FIELD);
        map.put("dryRun", DRY_RUN_FIELD);
        map.put("lakehouseIdcApplicationArn", LAKEHOUSE_IDC_APPLICATION_ARN_FIELD);
        map.put("lakehouseIdcRegistration", LAKEHOUSE_IDC_REGISTRATION_FIELD);
        map.put("lakehouseRegistration", LAKEHOUSE_REGISTRATION_FIELD);
        map.put("namespaceName", NAMESPACE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateLakehouseConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateLakehouseConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftServerlessRequest.BuilderImpl
    implements Builder {
        private String catalogName;
        private Boolean dryRun;
        private String lakehouseIdcApplicationArn;
        private String lakehouseIdcRegistration;
        private String lakehouseRegistration;
        private String namespaceName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLakehouseConfigurationRequest model) {
            super(model);
            this.catalogName(model.catalogName);
            this.dryRun(model.dryRun);
            this.lakehouseIdcApplicationArn(model.lakehouseIdcApplicationArn);
            this.lakehouseIdcRegistration(model.lakehouseIdcRegistration);
            this.lakehouseRegistration(model.lakehouseRegistration);
            this.namespaceName(model.namespaceName);
        }

        public final String getCatalogName() {
            return this.catalogName;
        }

        public final void setCatalogName(String catalogName) {
            this.catalogName = catalogName;
        }

        @Override
        public final Builder catalogName(String catalogName) {
            this.catalogName = catalogName;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getLakehouseIdcApplicationArn() {
            return this.lakehouseIdcApplicationArn;
        }

        public final void setLakehouseIdcApplicationArn(String lakehouseIdcApplicationArn) {
            this.lakehouseIdcApplicationArn = lakehouseIdcApplicationArn;
        }

        @Override
        public final Builder lakehouseIdcApplicationArn(String lakehouseIdcApplicationArn) {
            this.lakehouseIdcApplicationArn = lakehouseIdcApplicationArn;
            return this;
        }

        public final String getLakehouseIdcRegistration() {
            return this.lakehouseIdcRegistration;
        }

        public final void setLakehouseIdcRegistration(String lakehouseIdcRegistration) {
            this.lakehouseIdcRegistration = lakehouseIdcRegistration;
        }

        @Override
        public final Builder lakehouseIdcRegistration(String lakehouseIdcRegistration) {
            this.lakehouseIdcRegistration = lakehouseIdcRegistration;
            return this;
        }

        @Override
        public final Builder lakehouseIdcRegistration(LakehouseIdcRegistration lakehouseIdcRegistration) {
            this.lakehouseIdcRegistration(lakehouseIdcRegistration == null ? null : lakehouseIdcRegistration.toString());
            return this;
        }

        public final String getLakehouseRegistration() {
            return this.lakehouseRegistration;
        }

        public final void setLakehouseRegistration(String lakehouseRegistration) {
            this.lakehouseRegistration = lakehouseRegistration;
        }

        @Override
        public final Builder lakehouseRegistration(String lakehouseRegistration) {
            this.lakehouseRegistration = lakehouseRegistration;
            return this;
        }

        @Override
        public final Builder lakehouseRegistration(LakehouseRegistration lakehouseRegistration) {
            this.lakehouseRegistration(lakehouseRegistration == null ? null : lakehouseRegistration.toString());
            return this;
        }

        public final String getNamespaceName() {
            return this.namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLakehouseConfigurationRequest build() {
            return new UpdateLakehouseConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RedshiftServerlessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateLakehouseConfigurationRequest> {
        public Builder catalogName(String var1);

        public Builder dryRun(Boolean var1);

        public Builder lakehouseIdcApplicationArn(String var1);

        public Builder lakehouseIdcRegistration(String var1);

        public Builder lakehouseIdcRegistration(LakehouseIdcRegistration var1);

        public Builder lakehouseRegistration(String var1);

        public Builder lakehouseRegistration(LakehouseRegistration var1);

        public Builder namespaceName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

