/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.resiliencehub.model.PhysicalResource;
import software.amazon.awssdk.services.resiliencehub.model.PhysicalResourceListCopier;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencehubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAppVersionResourcesResponse
extends ResiliencehubResponse
implements ToCopyableBuilder<Builder, ListAppVersionResourcesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAppVersionResourcesResponse.getter(ListAppVersionResourcesResponse::nextToken)).setter(ListAppVersionResourcesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<PhysicalResource>> PHYSICAL_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("physicalResources").getter(ListAppVersionResourcesResponse.getter(ListAppVersionResourcesResponse::physicalResources)).setter(ListAppVersionResourcesResponse.setter(Builder::physicalResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("physicalResources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PhysicalResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESOLUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resolutionId").getter(ListAppVersionResourcesResponse.getter(ListAppVersionResourcesResponse::resolutionId)).setter(ListAppVersionResourcesResponse.setter(Builder::resolutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolutionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, PHYSICAL_RESOURCES_FIELD, RESOLUTION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAppVersionResourcesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<PhysicalResource> physicalResources;
    private final String resolutionId;

    private ListAppVersionResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.physicalResources = builder.physicalResources;
        this.resolutionId = builder.resolutionId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasPhysicalResources() {
        return this.physicalResources != null && !(this.physicalResources instanceof SdkAutoConstructList);
    }

    public final List<PhysicalResource> physicalResources() {
        return this.physicalResources;
    }

    public final String resolutionId() {
        return this.resolutionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPhysicalResources() ? this.physicalResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resolutionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAppVersionResourcesResponse)) {
            return false;
        }
        ListAppVersionResourcesResponse other = (ListAppVersionResourcesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasPhysicalResources() == other.hasPhysicalResources() && Objects.equals(this.physicalResources(), other.physicalResources()) && Objects.equals(this.resolutionId(), other.resolutionId());
    }

    public final String toString() {
        return ToString.builder((String)"ListAppVersionResourcesResponse").add("NextToken", (Object)this.nextToken()).add("PhysicalResources", this.hasPhysicalResources() ? this.physicalResources() : null).add("ResolutionId", (Object)this.resolutionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "physicalResources": {
                return Optional.ofNullable(clazz.cast(this.physicalResources()));
            }
            case "resolutionId": {
                return Optional.ofNullable(clazz.cast(this.resolutionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("physicalResources", PHYSICAL_RESOURCES_FIELD);
        map.put("resolutionId", RESOLUTION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAppVersionResourcesResponse, T> g) {
        return obj -> g.apply((ListAppVersionResourcesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ResiliencehubResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<PhysicalResource> physicalResources = DefaultSdkAutoConstructList.getInstance();
        private String resolutionId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAppVersionResourcesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.physicalResources(model.physicalResources);
            this.resolutionId(model.resolutionId);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<PhysicalResource.Builder> getPhysicalResources() {
            List<PhysicalResource.Builder> result = PhysicalResourceListCopier.copyToBuilder(this.physicalResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPhysicalResources(Collection<PhysicalResource.BuilderImpl> physicalResources) {
            this.physicalResources = PhysicalResourceListCopier.copyFromBuilder(physicalResources);
        }

        @Override
        public final Builder physicalResources(Collection<PhysicalResource> physicalResources) {
            this.physicalResources = PhysicalResourceListCopier.copy(physicalResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder physicalResources(PhysicalResource ... physicalResources) {
            this.physicalResources(Arrays.asList(physicalResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder physicalResources(Consumer<PhysicalResource.Builder> ... physicalResources) {
            this.physicalResources(Stream.of(physicalResources).map(c -> (PhysicalResource)((PhysicalResource.Builder)PhysicalResource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getResolutionId() {
            return this.resolutionId;
        }

        public final void setResolutionId(String resolutionId) {
            this.resolutionId = resolutionId;
        }

        @Override
        public final Builder resolutionId(String resolutionId) {
            this.resolutionId = resolutionId;
            return this;
        }

        @Override
        public ListAppVersionResourcesResponse build() {
            return new ListAppVersionResourcesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ResiliencehubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAppVersionResourcesResponse> {
        public Builder nextToken(String var1);

        public Builder physicalResources(Collection<PhysicalResource> var1);

        public Builder physicalResources(PhysicalResource ... var1);

        public Builder physicalResources(Consumer<PhysicalResource.Builder> ... var1);

        public Builder resolutionId(String var1);
    }
}

