/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resiliencehub.ResiliencehubClient;
import software.amazon.awssdk.services.resiliencehub.internal.UserAgentUtils;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListAppVersionsResponse;

public class ListAppVersionsIterable
implements SdkIterable<ListAppVersionsResponse> {
    private final ResiliencehubClient client;
    private final ListAppVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAppVersionsIterable(ResiliencehubClient client, ListAppVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAppVersionsResponseFetcher();
    }

    public Iterator<ListAppVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAppVersionsResponseFetcher
    implements SyncPageFetcher<ListAppVersionsResponse> {
        private ListAppVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListAppVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAppVersionsResponse nextPage(ListAppVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListAppVersionsIterable.this.client.listAppVersions(ListAppVersionsIterable.this.firstRequest);
            }
            return ListAppVersionsIterable.this.client.listAppVersions((ListAppVersionsRequest)((Object)ListAppVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

