/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resiliencehub.ResiliencehubClient;
import software.amazon.awssdk.services.resiliencehub.internal.UserAgentUtils;
import software.amazon.awssdk.services.resiliencehub.model.GroupingRecommendation;
import software.amazon.awssdk.services.resiliencehub.model.ListResourceGroupingRecommendationsRequest;
import software.amazon.awssdk.services.resiliencehub.model.ListResourceGroupingRecommendationsResponse;

public class ListResourceGroupingRecommendationsIterable
implements SdkIterable<ListResourceGroupingRecommendationsResponse> {
    private final ResiliencehubClient client;
    private final ListResourceGroupingRecommendationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListResourceGroupingRecommendationsIterable(ResiliencehubClient client, ListResourceGroupingRecommendationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListResourceGroupingRecommendationsResponseFetcher();
    }

    public Iterator<ListResourceGroupingRecommendationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<GroupingRecommendation> groupingRecommendations() {
        Function<ListResourceGroupingRecommendationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.groupingRecommendations() != null) {
                return response.groupingRecommendations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListResourceGroupingRecommendationsResponseFetcher
    implements SyncPageFetcher<ListResourceGroupingRecommendationsResponse> {
        private ListResourceGroupingRecommendationsResponseFetcher() {
        }

        public boolean hasNextPage(ListResourceGroupingRecommendationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListResourceGroupingRecommendationsResponse nextPage(ListResourceGroupingRecommendationsResponse previousPage) {
            if (previousPage == null) {
                return ListResourceGroupingRecommendationsIterable.this.client.listResourceGroupingRecommendations(ListResourceGroupingRecommendationsIterable.this.firstRequest);
            }
            return ListResourceGroupingRecommendationsIterable.this.client.listResourceGroupingRecommendations((ListResourceGroupingRecommendationsRequest)((Object)ListResourceGroupingRecommendationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

