/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.resiliencehub.model.AssessmentComplianceCopier;
import software.amazon.awssdk.services.resiliencehub.model.ComplianceStatus;
import software.amazon.awssdk.services.resiliencehub.model.Cost;
import software.amazon.awssdk.services.resiliencehub.model.DisruptionCompliance;
import software.amazon.awssdk.services.resiliencehub.model.DisruptionType;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencyScore;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AppComponentCompliance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AppComponentCompliance> {
    private static final SdkField<String> APP_COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appComponentName").getter(AppComponentCompliance.getter(AppComponentCompliance::appComponentName)).setter(AppComponentCompliance.setter(Builder::appComponentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appComponentName").build()}).build();
    private static final SdkField<Map<String, DisruptionCompliance>> COMPLIANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("compliance").getter(AppComponentCompliance.getter(AppComponentCompliance::complianceAsStrings)).setter(AppComponentCompliance.setter(Builder::complianceWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compliance").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DisruptionCompliance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Cost> COST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cost").getter(AppComponentCompliance.getter(AppComponentCompliance::cost)).setter(AppComponentCompliance.setter(Builder::cost)).constructor(Cost::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cost").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(AppComponentCompliance.getter(AppComponentCompliance::message)).setter(AppComponentCompliance.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<ResiliencyScore> RESILIENCY_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resiliencyScore").getter(AppComponentCompliance.getter(AppComponentCompliance::resiliencyScore)).setter(AppComponentCompliance.setter(Builder::resiliencyScore)).constructor(ResiliencyScore::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resiliencyScore").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(AppComponentCompliance.getter(AppComponentCompliance::statusAsString)).setter(AppComponentCompliance.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_COMPONENT_NAME_FIELD, COMPLIANCE_FIELD, COST_FIELD, MESSAGE_FIELD, RESILIENCY_SCORE_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AppComponentCompliance.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String appComponentName;
    private final Map<String, DisruptionCompliance> compliance;
    private final Cost cost;
    private final String message;
    private final ResiliencyScore resiliencyScore;
    private final String status;

    private AppComponentCompliance(BuilderImpl builder) {
        this.appComponentName = builder.appComponentName;
        this.compliance = builder.compliance;
        this.cost = builder.cost;
        this.message = builder.message;
        this.resiliencyScore = builder.resiliencyScore;
        this.status = builder.status;
    }

    public final String appComponentName() {
        return this.appComponentName;
    }

    public final Map<DisruptionType, DisruptionCompliance> compliance() {
        return AssessmentComplianceCopier.copyStringToEnum(this.compliance);
    }

    public final boolean hasCompliance() {
        return this.compliance != null && !(this.compliance instanceof SdkAutoConstructMap);
    }

    public final Map<String, DisruptionCompliance> complianceAsStrings() {
        return this.compliance;
    }

    public final Cost cost() {
        return this.cost;
    }

    public final String message() {
        return this.message;
    }

    public final ResiliencyScore resiliencyScore() {
        return this.resiliencyScore;
    }

    public final ComplianceStatus status() {
        return ComplianceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appComponentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCompliance() ? this.complianceAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.cost());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.resiliencyScore());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppComponentCompliance)) {
            return false;
        }
        AppComponentCompliance other = (AppComponentCompliance)obj;
        return Objects.equals(this.appComponentName(), other.appComponentName()) && this.hasCompliance() == other.hasCompliance() && Objects.equals(this.complianceAsStrings(), other.complianceAsStrings()) && Objects.equals(this.cost(), other.cost()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.resiliencyScore(), other.resiliencyScore()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AppComponentCompliance").add("AppComponentName", (Object)this.appComponentName()).add("Compliance", this.hasCompliance() ? this.complianceAsStrings() : null).add("Cost", (Object)this.cost()).add("Message", (Object)this.message()).add("ResiliencyScore", (Object)this.resiliencyScore()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appComponentName": {
                return Optional.ofNullable(clazz.cast(this.appComponentName()));
            }
            case "compliance": {
                return Optional.ofNullable(clazz.cast(this.complianceAsStrings()));
            }
            case "cost": {
                return Optional.ofNullable(clazz.cast(this.cost()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "resiliencyScore": {
                return Optional.ofNullable(clazz.cast(this.resiliencyScore()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appComponentName", APP_COMPONENT_NAME_FIELD);
        map.put("compliance", COMPLIANCE_FIELD);
        map.put("cost", COST_FIELD);
        map.put("message", MESSAGE_FIELD);
        map.put("resiliencyScore", RESILIENCY_SCORE_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AppComponentCompliance, T> g) {
        return obj -> g.apply((AppComponentCompliance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String appComponentName;
        private Map<String, DisruptionCompliance> compliance = DefaultSdkAutoConstructMap.getInstance();
        private Cost cost;
        private String message;
        private ResiliencyScore resiliencyScore;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(AppComponentCompliance model) {
            this.appComponentName(model.appComponentName);
            this.complianceWithStrings(model.compliance);
            this.cost(model.cost);
            this.message(model.message);
            this.resiliencyScore(model.resiliencyScore);
            this.status(model.status);
        }

        public final String getAppComponentName() {
            return this.appComponentName;
        }

        public final void setAppComponentName(String appComponentName) {
            this.appComponentName = appComponentName;
        }

        @Override
        public final Builder appComponentName(String appComponentName) {
            this.appComponentName = appComponentName;
            return this;
        }

        public final Map<String, DisruptionCompliance.Builder> getCompliance() {
            Map<String, DisruptionCompliance.Builder> result = AssessmentComplianceCopier.copyToBuilder(this.compliance);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setCompliance(Map<String, DisruptionCompliance.BuilderImpl> compliance) {
            this.compliance = AssessmentComplianceCopier.copyFromBuilder(compliance);
        }

        @Override
        public final Builder complianceWithStrings(Map<String, DisruptionCompliance> compliance) {
            this.compliance = AssessmentComplianceCopier.copy(compliance);
            return this;
        }

        @Override
        public final Builder compliance(Map<DisruptionType, DisruptionCompliance> compliance) {
            this.compliance = AssessmentComplianceCopier.copyEnumToString(compliance);
            return this;
        }

        public final Cost.Builder getCost() {
            return this.cost != null ? this.cost.toBuilder() : null;
        }

        public final void setCost(Cost.BuilderImpl cost) {
            this.cost = cost != null ? cost.build() : null;
        }

        @Override
        public final Builder cost(Cost cost) {
            this.cost = cost;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final ResiliencyScore.Builder getResiliencyScore() {
            return this.resiliencyScore != null ? this.resiliencyScore.toBuilder() : null;
        }

        public final void setResiliencyScore(ResiliencyScore.BuilderImpl resiliencyScore) {
            this.resiliencyScore = resiliencyScore != null ? resiliencyScore.build() : null;
        }

        @Override
        public final Builder resiliencyScore(ResiliencyScore resiliencyScore) {
            this.resiliencyScore = resiliencyScore;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ComplianceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public AppComponentCompliance build() {
            return new AppComponentCompliance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AppComponentCompliance> {
        public Builder appComponentName(String var1);

        public Builder complianceWithStrings(Map<String, DisruptionCompliance> var1);

        public Builder compliance(Map<DisruptionType, DisruptionCompliance> var1);

        public Builder cost(Cost var1);

        default public Builder cost(Consumer<Cost.Builder> cost) {
            return this.cost((Cost)((Cost.Builder)Cost.builder().applyMutation(cost)).build());
        }

        public Builder message(String var1);

        public Builder resiliencyScore(ResiliencyScore var1);

        default public Builder resiliencyScore(Consumer<ResiliencyScore.Builder> resiliencyScore) {
            return this.resiliencyScore((ResiliencyScore)((ResiliencyScore.Builder)ResiliencyScore.builder().applyMutation(resiliencyScore)).build());
        }

        public Builder status(String var1);

        public Builder status(ComplianceStatus var1);
    }
}

