/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourceexplorer2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SupportedResourceType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SupportedResourceType> {
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(SupportedResourceType.getter(SupportedResourceType::resourceType)).setter(SupportedResourceType.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Service").getter(SupportedResourceType.getter(SupportedResourceType::service)).setter(SupportedResourceType.setter(Builder::service)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Service").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TYPE_FIELD, SERVICE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SupportedResourceType.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String resourceType;
    private final String service;

    private SupportedResourceType(BuilderImpl builder) {
        this.resourceType = builder.resourceType;
        this.service = builder.service;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final String service() {
        return this.service;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.service());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SupportedResourceType)) {
            return false;
        }
        SupportedResourceType other = (SupportedResourceType)obj;
        return Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.service(), other.service());
    }

    public final String toString() {
        return ToString.builder((String)"SupportedResourceType").add("ResourceType", (Object)this.resourceType()).add("Service", (Object)this.service()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "Service": {
                return Optional.ofNullable(clazz.cast(this.service()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("Service", SERVICE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SupportedResourceType, T> g) {
        return obj -> g.apply((SupportedResourceType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceType;
        private String service;

        private BuilderImpl() {
        }

        private BuilderImpl(SupportedResourceType model) {
            this.resourceType(model.resourceType);
            this.service(model.service);
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getService() {
            return this.service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public SupportedResourceType build() {
            return new SupportedResourceType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SupportedResourceType> {
        public Builder resourceType(String var1);

        public Builder service(String var1);
    }
}

