/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourceexplorer2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resourceexplorer2.ResourceExplorer2AsyncClient;
import software.amazon.awssdk.services.resourceexplorer2.internal.UserAgentUtils;
import software.amazon.awssdk.services.resourceexplorer2.model.ListManagedViewsRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.ListManagedViewsResponse;

public class ListManagedViewsPublisher
implements SdkPublisher<ListManagedViewsResponse> {
    private final ResourceExplorer2AsyncClient client;
    private final ListManagedViewsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListManagedViewsPublisher(ResourceExplorer2AsyncClient client, ListManagedViewsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListManagedViewsPublisher(ResourceExplorer2AsyncClient client, ListManagedViewsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListManagedViewsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListManagedViewsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> managedViews() {
        Function<ListManagedViewsResponse, Iterator> getIterator = response -> {
            if (response != null && response.managedViews() != null) {
                return response.managedViews().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListManagedViewsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListManagedViewsResponseFetcher
    implements AsyncPageFetcher<ListManagedViewsResponse> {
        private ListManagedViewsResponseFetcher() {
        }

        public boolean hasNextPage(ListManagedViewsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListManagedViewsResponse> nextPage(ListManagedViewsResponse previousPage) {
            if (previousPage == null) {
                return ListManagedViewsPublisher.this.client.listManagedViews(ListManagedViewsPublisher.this.firstRequest);
            }
            return ListManagedViewsPublisher.this.client.listManagedViews((ListManagedViewsRequest)((Object)ListManagedViewsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

