/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourceexplorer2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resourceexplorer2.ResourceExplorer2AsyncClient;
import software.amazon.awssdk.services.resourceexplorer2.internal.UserAgentUtils;
import software.amazon.awssdk.services.resourceexplorer2.model.Index;
import software.amazon.awssdk.services.resourceexplorer2.model.ListServiceIndexesRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.ListServiceIndexesResponse;

public class ListServiceIndexesPublisher
implements SdkPublisher<ListServiceIndexesResponse> {
    private final ResourceExplorer2AsyncClient client;
    private final ListServiceIndexesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListServiceIndexesPublisher(ResourceExplorer2AsyncClient client, ListServiceIndexesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListServiceIndexesPublisher(ResourceExplorer2AsyncClient client, ListServiceIndexesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListServiceIndexesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListServiceIndexesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Index> indexes() {
        Function<ListServiceIndexesResponse, Iterator> getIterator = response -> {
            if (response != null && response.indexes() != null) {
                return response.indexes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListServiceIndexesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListServiceIndexesResponseFetcher
    implements AsyncPageFetcher<ListServiceIndexesResponse> {
        private ListServiceIndexesResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceIndexesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListServiceIndexesResponse> nextPage(ListServiceIndexesResponse previousPage) {
            if (previousPage == null) {
                return ListServiceIndexesPublisher.this.client.listServiceIndexes(ListServiceIndexesPublisher.this.firstRequest);
            }
            return ListServiceIndexesPublisher.this.client.listServiceIndexes((ListServiceIndexesRequest)((Object)ListServiceIndexesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

