/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourceexplorer2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resourceexplorer2.ResourceExplorer2Client;
import software.amazon.awssdk.services.resourceexplorer2.internal.UserAgentUtils;
import software.amazon.awssdk.services.resourceexplorer2.model.ListStreamingAccessForServicesRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.ListStreamingAccessForServicesResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.StreamingAccessDetails;

public class ListStreamingAccessForServicesIterable
implements SdkIterable<ListStreamingAccessForServicesResponse> {
    private final ResourceExplorer2Client client;
    private final ListStreamingAccessForServicesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStreamingAccessForServicesIterable(ResourceExplorer2Client client, ListStreamingAccessForServicesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListStreamingAccessForServicesResponseFetcher();
    }

    public Iterator<ListStreamingAccessForServicesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<StreamingAccessDetails> streamingAccessForServices() {
        Function<ListStreamingAccessForServicesResponse, Iterator> getIterator = response -> {
            if (response != null && response.streamingAccessForServices() != null) {
                return response.streamingAccessForServices().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListStreamingAccessForServicesResponseFetcher
    implements SyncPageFetcher<ListStreamingAccessForServicesResponse> {
        private ListStreamingAccessForServicesResponseFetcher() {
        }

        public boolean hasNextPage(ListStreamingAccessForServicesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStreamingAccessForServicesResponse nextPage(ListStreamingAccessForServicesResponse previousPage) {
            if (previousPage == null) {
                return ListStreamingAccessForServicesIterable.this.client.listStreamingAccessForServices(ListStreamingAccessForServicesIterable.this.firstRequest);
            }
            return ListStreamingAccessForServicesIterable.this.client.listStreamingAccessForServices((ListStreamingAccessForServicesRequest)((Object)ListStreamingAccessForServicesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

