/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourceexplorer2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resourceexplorer2.ResourceExplorer2AsyncClient;
import software.amazon.awssdk.services.resourceexplorer2.internal.UserAgentUtils;
import software.amazon.awssdk.services.resourceexplorer2.model.ListServiceViewsRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.ListServiceViewsResponse;

public class ListServiceViewsPublisher
implements SdkPublisher<ListServiceViewsResponse> {
    private final ResourceExplorer2AsyncClient client;
    private final ListServiceViewsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListServiceViewsPublisher(ResourceExplorer2AsyncClient client, ListServiceViewsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListServiceViewsPublisher(ResourceExplorer2AsyncClient client, ListServiceViewsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListServiceViewsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListServiceViewsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> serviceViews() {
        Function<ListServiceViewsResponse, Iterator> getIterator = response -> {
            if (response != null && response.serviceViews() != null) {
                return response.serviceViews().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListServiceViewsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListServiceViewsResponseFetcher
    implements AsyncPageFetcher<ListServiceViewsResponse> {
        private ListServiceViewsResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceViewsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListServiceViewsResponse> nextPage(ListServiceViewsResponse previousPage) {
            if (previousPage == null) {
                return ListServiceViewsPublisher.this.client.listServiceViews(ListServiceViewsPublisher.this.firstRequest);
            }
            return ListServiceViewsPublisher.this.client.listServiceViews((ListServiceViewsRequest)((Object)ListServiceViewsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

