/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.retries.api.internal.backoff;

import java.time.Duration;
import java.util.Random;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.retries.api.internal.backoff.BackoffStrategiesConstants;
import software.amazon.awssdk.utils.NumericUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class ExponentialDelayWithJitter
implements BackoffStrategy {
    private final Supplier<Random> randomSupplier;
    private final Duration baseDelay;
    private final Duration maxDelay;

    public ExponentialDelayWithJitter(Supplier<Random> randomSupplier, Duration baseDelay, Duration maxDelay) {
        this.randomSupplier = (Supplier)Validate.paramNotNull(randomSupplier, (String)"random");
        this.baseDelay = NumericUtils.min((Duration)Validate.isPositive((Duration)baseDelay, (String)"baseDelay"), (Duration)BackoffStrategiesConstants.BASE_DELAY_CEILING);
        this.maxDelay = NumericUtils.min((Duration)Validate.isPositive((Duration)maxDelay, (String)"maxDelay"), (Duration)BackoffStrategiesConstants.MAX_BACKOFF_CEILING);
    }

    @Override
    public Duration computeDelay(int attempt) {
        Validate.isPositive((int)attempt, (String)"attempt");
        if (attempt == 1) {
            return Duration.ZERO;
        }
        int delay = BackoffStrategiesConstants.calculateExponentialDelay(attempt, this.baseDelay, this.maxDelay);
        int randInt = this.randomSupplier.get().nextInt(delay);
        return Duration.ofMillis(randInt);
    }

    public String toString() {
        return ToString.builder((String)"ExponentialDelayWithJitter").add("baseDelay", (Object)this.baseDelay).add("maxDelay", (Object)this.maxDelay).build();
    }
}

