/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.robomaker.RoboMakerAsyncClient;
import software.amazon.awssdk.services.robomaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.robomaker.model.ListWorldsRequest;
import software.amazon.awssdk.services.robomaker.model.ListWorldsResponse;
import software.amazon.awssdk.services.robomaker.model.WorldSummary;

public class ListWorldsPublisher
implements SdkPublisher<ListWorldsResponse> {
    private final RoboMakerAsyncClient client;
    private final ListWorldsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWorldsPublisher(RoboMakerAsyncClient client, ListWorldsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWorldsPublisher(RoboMakerAsyncClient client, ListWorldsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWorldsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWorldsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<WorldSummary> worldSummaries() {
        Function<ListWorldsResponse, Iterator> getIterator = response -> {
            if (response != null && response.worldSummaries() != null) {
                return response.worldSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListWorldsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListWorldsResponseFetcher
    implements AsyncPageFetcher<ListWorldsResponse> {
        private ListWorldsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorldsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWorldsResponse> nextPage(ListWorldsResponse previousPage) {
            if (previousPage == null) {
                return ListWorldsPublisher.this.client.listWorlds(ListWorldsPublisher.this.firstRequest);
            }
            return ListWorldsPublisher.this.client.listWorlds((ListWorldsRequest)((Object)ListWorldsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

