/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorldCount
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorldCount> {
    private static final SdkField<Integer> FLOORPLAN_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("floorplanCount").getter(WorldCount.getter(WorldCount::floorplanCount)).setter(WorldCount.setter(Builder::floorplanCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("floorplanCount").build()}).build();
    private static final SdkField<Integer> INTERIOR_COUNT_PER_FLOORPLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("interiorCountPerFloorplan").getter(WorldCount.getter(WorldCount::interiorCountPerFloorplan)).setter(WorldCount.setter(Builder::interiorCountPerFloorplan)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interiorCountPerFloorplan").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOORPLAN_COUNT_FIELD, INTERIOR_COUNT_PER_FLOORPLAN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WorldCount.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer floorplanCount;
    private final Integer interiorCountPerFloorplan;

    private WorldCount(BuilderImpl builder) {
        this.floorplanCount = builder.floorplanCount;
        this.interiorCountPerFloorplan = builder.interiorCountPerFloorplan;
    }

    public final Integer floorplanCount() {
        return this.floorplanCount;
    }

    public final Integer interiorCountPerFloorplan() {
        return this.interiorCountPerFloorplan;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.floorplanCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.interiorCountPerFloorplan());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorldCount)) {
            return false;
        }
        WorldCount other = (WorldCount)obj;
        return Objects.equals(this.floorplanCount(), other.floorplanCount()) && Objects.equals(this.interiorCountPerFloorplan(), other.interiorCountPerFloorplan());
    }

    public final String toString() {
        return ToString.builder((String)"WorldCount").add("FloorplanCount", (Object)this.floorplanCount()).add("InteriorCountPerFloorplan", (Object)this.interiorCountPerFloorplan()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "floorplanCount": {
                return Optional.ofNullable(clazz.cast(this.floorplanCount()));
            }
            case "interiorCountPerFloorplan": {
                return Optional.ofNullable(clazz.cast(this.interiorCountPerFloorplan()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Integer>> map = new HashMap<String, SdkField<Integer>>();
        map.put("floorplanCount", FLOORPLAN_COUNT_FIELD);
        map.put("interiorCountPerFloorplan", INTERIOR_COUNT_PER_FLOORPLAN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorldCount, T> g) {
        return obj -> g.apply((WorldCount)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer floorplanCount;
        private Integer interiorCountPerFloorplan;

        private BuilderImpl() {
        }

        private BuilderImpl(WorldCount model) {
            this.floorplanCount(model.floorplanCount);
            this.interiorCountPerFloorplan(model.interiorCountPerFloorplan);
        }

        public final Integer getFloorplanCount() {
            return this.floorplanCount;
        }

        public final void setFloorplanCount(Integer floorplanCount) {
            this.floorplanCount = floorplanCount;
        }

        @Override
        public final Builder floorplanCount(Integer floorplanCount) {
            this.floorplanCount = floorplanCount;
            return this;
        }

        public final Integer getInteriorCountPerFloorplan() {
            return this.interiorCountPerFloorplan;
        }

        public final void setInteriorCountPerFloorplan(Integer interiorCountPerFloorplan) {
            this.interiorCountPerFloorplan = interiorCountPerFloorplan;
        }

        @Override
        public final Builder interiorCountPerFloorplan(Integer interiorCountPerFloorplan) {
            this.interiorCountPerFloorplan = interiorCountPerFloorplan;
            return this;
        }

        public WorldCount build() {
            return new WorldCount(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorldCount> {
        public Builder floorplanCount(Integer var1);

        public Builder interiorCountPerFloorplan(Integer var1);
    }
}

