/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rolesanywhere.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rolesanywhere.model.NotificationSettingDetail;
import software.amazon.awssdk.services.rolesanywhere.model.NotificationSettingDetailsCopier;
import software.amazon.awssdk.services.rolesanywhere.model.Source;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrustAnchorDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrustAnchorDetail> {
    private static final SdkField<String> TRUST_ANCHOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trustAnchorId").getter(TrustAnchorDetail.getter(TrustAnchorDetail::trustAnchorId)).setter(TrustAnchorDetail.setter(Builder::trustAnchorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trustAnchorId").build()}).build();
    private static final SdkField<String> TRUST_ANCHOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trustAnchorArn").getter(TrustAnchorDetail.getter(TrustAnchorDetail::trustAnchorArn)).setter(TrustAnchorDetail.setter(Builder::trustAnchorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trustAnchorArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(TrustAnchorDetail.getter(TrustAnchorDetail::name)).setter(TrustAnchorDetail.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Source> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("source").getter(TrustAnchorDetail.getter(TrustAnchorDetail::source)).setter(TrustAnchorDetail.setter(Builder::source)).constructor(Source::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enabled").getter(TrustAnchorDetail.getter(TrustAnchorDetail::enabled)).setter(TrustAnchorDetail.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(TrustAnchorDetail.getter(TrustAnchorDetail::createdAt)).setter(TrustAnchorDetail.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(TrustAnchorDetail.getter(TrustAnchorDetail::updatedAt)).setter(TrustAnchorDetail.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<List<NotificationSettingDetail>> NOTIFICATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("notificationSettings").getter(TrustAnchorDetail.getter(TrustAnchorDetail::notificationSettings)).setter(TrustAnchorDetail.setter(Builder::notificationSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NotificationSettingDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRUST_ANCHOR_ID_FIELD, TRUST_ANCHOR_ARN_FIELD, NAME_FIELD, SOURCE_FIELD, ENABLED_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, NOTIFICATION_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TrustAnchorDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String trustAnchorId;
    private final String trustAnchorArn;
    private final String name;
    private final Source source;
    private final Boolean enabled;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final List<NotificationSettingDetail> notificationSettings;

    private TrustAnchorDetail(BuilderImpl builder) {
        this.trustAnchorId = builder.trustAnchorId;
        this.trustAnchorArn = builder.trustAnchorArn;
        this.name = builder.name;
        this.source = builder.source;
        this.enabled = builder.enabled;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.notificationSettings = builder.notificationSettings;
    }

    public final String trustAnchorId() {
        return this.trustAnchorId;
    }

    public final String trustAnchorArn() {
        return this.trustAnchorArn;
    }

    public final String name() {
        return this.name;
    }

    public final Source source() {
        return this.source;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final boolean hasNotificationSettings() {
        return this.notificationSettings != null && !(this.notificationSettings instanceof SdkAutoConstructList);
    }

    public final List<NotificationSettingDetail> notificationSettings() {
        return this.notificationSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trustAnchorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.trustAnchorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotificationSettings() ? this.notificationSettings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrustAnchorDetail)) {
            return false;
        }
        TrustAnchorDetail other = (TrustAnchorDetail)obj;
        return Objects.equals(this.trustAnchorId(), other.trustAnchorId()) && Objects.equals(this.trustAnchorArn(), other.trustAnchorArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && this.hasNotificationSettings() == other.hasNotificationSettings() && Objects.equals(this.notificationSettings(), other.notificationSettings());
    }

    public final String toString() {
        return ToString.builder((String)"TrustAnchorDetail").add("TrustAnchorId", (Object)this.trustAnchorId()).add("TrustAnchorArn", (Object)this.trustAnchorArn()).add("Name", (Object)this.name()).add("Source", (Object)this.source()).add("Enabled", (Object)this.enabled()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("NotificationSettings", this.hasNotificationSettings() ? this.notificationSettings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "trustAnchorId": {
                return Optional.ofNullable(clazz.cast(this.trustAnchorId()));
            }
            case "trustAnchorArn": {
                return Optional.ofNullable(clazz.cast(this.trustAnchorArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "notificationSettings": {
                return Optional.ofNullable(clazz.cast(this.notificationSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("trustAnchorId", TRUST_ANCHOR_ID_FIELD);
        map.put("trustAnchorArn", TRUST_ANCHOR_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("enabled", ENABLED_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("notificationSettings", NOTIFICATION_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrustAnchorDetail, T> g) {
        return obj -> g.apply((TrustAnchorDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String trustAnchorId;
        private String trustAnchorArn;
        private String name;
        private Source source;
        private Boolean enabled;
        private Instant createdAt;
        private Instant updatedAt;
        private List<NotificationSettingDetail> notificationSettings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TrustAnchorDetail model) {
            this.trustAnchorId(model.trustAnchorId);
            this.trustAnchorArn(model.trustAnchorArn);
            this.name(model.name);
            this.source(model.source);
            this.enabled(model.enabled);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.notificationSettings(model.notificationSettings);
        }

        public final String getTrustAnchorId() {
            return this.trustAnchorId;
        }

        public final void setTrustAnchorId(String trustAnchorId) {
            this.trustAnchorId = trustAnchorId;
        }

        @Override
        public final Builder trustAnchorId(String trustAnchorId) {
            this.trustAnchorId = trustAnchorId;
            return this;
        }

        public final String getTrustAnchorArn() {
            return this.trustAnchorArn;
        }

        public final void setTrustAnchorArn(String trustAnchorArn) {
            this.trustAnchorArn = trustAnchorArn;
        }

        @Override
        public final Builder trustAnchorArn(String trustAnchorArn) {
            this.trustAnchorArn = trustAnchorArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Source.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(Source.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(Source source) {
            this.source = source;
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final List<NotificationSettingDetail.Builder> getNotificationSettings() {
            List<NotificationSettingDetail.Builder> result = NotificationSettingDetailsCopier.copyToBuilder(this.notificationSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNotificationSettings(Collection<NotificationSettingDetail.BuilderImpl> notificationSettings) {
            this.notificationSettings = NotificationSettingDetailsCopier.copyFromBuilder(notificationSettings);
        }

        @Override
        public final Builder notificationSettings(Collection<NotificationSettingDetail> notificationSettings) {
            this.notificationSettings = NotificationSettingDetailsCopier.copy(notificationSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationSettings(NotificationSettingDetail ... notificationSettings) {
            this.notificationSettings(Arrays.asList(notificationSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationSettings(Consumer<NotificationSettingDetail.Builder> ... notificationSettings) {
            this.notificationSettings(Stream.of(notificationSettings).map(c -> (NotificationSettingDetail)((NotificationSettingDetail.Builder)NotificationSettingDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TrustAnchorDetail build() {
            return new TrustAnchorDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrustAnchorDetail> {
        public Builder trustAnchorId(String var1);

        public Builder trustAnchorArn(String var1);

        public Builder name(String var1);

        public Builder source(Source var1);

        default public Builder source(Consumer<Source.Builder> source) {
            return this.source((Source)((Source.Builder)Source.builder().applyMutation(source)).build());
        }

        public Builder enabled(Boolean var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder notificationSettings(Collection<NotificationSettingDetail> var1);

        public Builder notificationSettings(NotificationSettingDetail ... var1);

        public Builder notificationSettings(Consumer<NotificationSettingDetail.Builder> ... var1);
    }
}

