/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rolesanywhere.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rolesanywhere.model.RolesAnywhereRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCrlRequest
extends RolesAnywhereRequest
implements ToCopyableBuilder<Builder, UpdateCrlRequest> {
    private static final SdkField<String> CRL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("crlId").getter(UpdateCrlRequest.getter(UpdateCrlRequest::crlId)).setter(UpdateCrlRequest.setter(Builder::crlId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("crlId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateCrlRequest.getter(UpdateCrlRequest::name)).setter(UpdateCrlRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<SdkBytes> CRL_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("crlData").getter(UpdateCrlRequest.getter(UpdateCrlRequest::crlData)).setter(UpdateCrlRequest.setter(Builder::crlData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crlData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRL_ID_FIELD, NAME_FIELD, CRL_DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateCrlRequest.memberNameToFieldInitializer();
    private final String crlId;
    private final String name;
    private final SdkBytes crlData;

    private UpdateCrlRequest(BuilderImpl builder) {
        super(builder);
        this.crlId = builder.crlId;
        this.name = builder.name;
        this.crlData = builder.crlData;
    }

    public final String crlId() {
        return this.crlId;
    }

    public final String name() {
        return this.name;
    }

    public final SdkBytes crlData() {
        return this.crlData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.crlId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.crlData());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCrlRequest)) {
            return false;
        }
        UpdateCrlRequest other = (UpdateCrlRequest)((Object)obj);
        return Objects.equals(this.crlId(), other.crlId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.crlData(), other.crlData());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateCrlRequest").add("CrlId", (Object)this.crlId()).add("Name", (Object)this.name()).add("CrlData", (Object)this.crlData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "crlId": {
                return Optional.ofNullable(clazz.cast(this.crlId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "crlData": {
                return Optional.ofNullable(clazz.cast(this.crlData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("crlId", CRL_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("crlData", CRL_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCrlRequest, T> g) {
        return obj -> g.apply((UpdateCrlRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RolesAnywhereRequest.BuilderImpl
    implements Builder {
        private String crlId;
        private String name;
        private SdkBytes crlData;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCrlRequest model) {
            super(model);
            this.crlId(model.crlId);
            this.name(model.name);
            this.crlData(model.crlData);
        }

        public final String getCrlId() {
            return this.crlId;
        }

        public final void setCrlId(String crlId) {
            this.crlId = crlId;
        }

        @Override
        public final Builder crlId(String crlId) {
            this.crlId = crlId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ByteBuffer getCrlData() {
            return this.crlData == null ? null : this.crlData.asByteBuffer();
        }

        public final void setCrlData(ByteBuffer crlData) {
            this.crlData(crlData == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)crlData));
        }

        @Override
        public final Builder crlData(SdkBytes crlData) {
            this.crlData = crlData;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCrlRequest build() {
            return new UpdateCrlRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RolesAnywhereRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateCrlRequest> {
        public Builder crlId(String var1);

        public Builder name(String var1);

        public Builder crlData(SdkBytes var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

