/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53.model.Route53Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateHostedZoneFeaturesRequest
extends Route53Request
implements ToCopyableBuilder<Builder, UpdateHostedZoneFeaturesRequest> {
    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostedZoneId").getter(UpdateHostedZoneFeaturesRequest.getter(UpdateHostedZoneFeaturesRequest::hostedZoneId)).setter(UpdateHostedZoneFeaturesRequest.setter(Builder::hostedZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").unmarshallLocationName("Id").build()}).build();
    private static final SdkField<Boolean> ENABLE_ACCELERATED_RECOVERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableAcceleratedRecovery").getter(UpdateHostedZoneFeaturesRequest.getter(UpdateHostedZoneFeaturesRequest::enableAcceleratedRecovery)).setter(UpdateHostedZoneFeaturesRequest.setter(Builder::enableAcceleratedRecovery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableAcceleratedRecovery").unmarshallLocationName("EnableAcceleratedRecovery").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTED_ZONE_ID_FIELD, ENABLE_ACCELERATED_RECOVERY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateHostedZoneFeaturesRequest.memberNameToFieldInitializer();
    private final String hostedZoneId;
    private final Boolean enableAcceleratedRecovery;

    private UpdateHostedZoneFeaturesRequest(BuilderImpl builder) {
        super(builder);
        this.hostedZoneId = builder.hostedZoneId;
        this.enableAcceleratedRecovery = builder.enableAcceleratedRecovery;
    }

    public final String hostedZoneId() {
        return this.hostedZoneId;
    }

    public final Boolean enableAcceleratedRecovery() {
        return this.enableAcceleratedRecovery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableAcceleratedRecovery());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateHostedZoneFeaturesRequest)) {
            return false;
        }
        UpdateHostedZoneFeaturesRequest other = (UpdateHostedZoneFeaturesRequest)((Object)obj);
        return Objects.equals(this.hostedZoneId(), other.hostedZoneId()) && Objects.equals(this.enableAcceleratedRecovery(), other.enableAcceleratedRecovery());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateHostedZoneFeaturesRequest").add("HostedZoneId", (Object)this.hostedZoneId()).add("EnableAcceleratedRecovery", (Object)this.enableAcceleratedRecovery()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostedZoneId": {
                return Optional.ofNullable(clazz.cast(this.hostedZoneId()));
            }
            case "EnableAcceleratedRecovery": {
                return Optional.ofNullable(clazz.cast(this.enableAcceleratedRecovery()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", HOSTED_ZONE_ID_FIELD);
        map.put("EnableAcceleratedRecovery", ENABLE_ACCELERATED_RECOVERY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateHostedZoneFeaturesRequest, T> g) {
        return obj -> g.apply((UpdateHostedZoneFeaturesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Request.BuilderImpl
    implements Builder {
        private String hostedZoneId;
        private Boolean enableAcceleratedRecovery;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateHostedZoneFeaturesRequest model) {
            super(model);
            this.hostedZoneId(model.hostedZoneId);
            this.enableAcceleratedRecovery(model.enableAcceleratedRecovery);
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final Boolean getEnableAcceleratedRecovery() {
            return this.enableAcceleratedRecovery;
        }

        public final void setEnableAcceleratedRecovery(Boolean enableAcceleratedRecovery) {
            this.enableAcceleratedRecovery = enableAcceleratedRecovery;
        }

        @Override
        public final Builder enableAcceleratedRecovery(Boolean enableAcceleratedRecovery) {
            this.enableAcceleratedRecovery = enableAcceleratedRecovery;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateHostedZoneFeaturesRequest build() {
            return new UpdateHostedZoneFeaturesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Route53Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateHostedZoneFeaturesRequest> {
        public Builder hostedZoneId(String var1);

        public Builder enableAcceleratedRecovery(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

