/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.route53domains.Route53DomainsClient;
import software.amazon.awssdk.services.route53domains.Route53DomainsServiceClientConfiguration;
import software.amazon.awssdk.services.route53domains.internal.Route53DomainsServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.route53domains.model.AcceptDomainTransferFromAnotherAwsAccountRequest;
import software.amazon.awssdk.services.route53domains.model.AcceptDomainTransferFromAnotherAwsAccountResponse;
import software.amazon.awssdk.services.route53domains.model.AssociateDelegationSignerToDomainRequest;
import software.amazon.awssdk.services.route53domains.model.AssociateDelegationSignerToDomainResponse;
import software.amazon.awssdk.services.route53domains.model.CancelDomainTransferToAnotherAwsAccountRequest;
import software.amazon.awssdk.services.route53domains.model.CancelDomainTransferToAnotherAwsAccountResponse;
import software.amazon.awssdk.services.route53domains.model.CheckDomainAvailabilityRequest;
import software.amazon.awssdk.services.route53domains.model.CheckDomainAvailabilityResponse;
import software.amazon.awssdk.services.route53domains.model.CheckDomainTransferabilityRequest;
import software.amazon.awssdk.services.route53domains.model.CheckDomainTransferabilityResponse;
import software.amazon.awssdk.services.route53domains.model.DeleteDomainRequest;
import software.amazon.awssdk.services.route53domains.model.DeleteDomainResponse;
import software.amazon.awssdk.services.route53domains.model.DeleteTagsForDomainRequest;
import software.amazon.awssdk.services.route53domains.model.DeleteTagsForDomainResponse;
import software.amazon.awssdk.services.route53domains.model.DisableDomainAutoRenewRequest;
import software.amazon.awssdk.services.route53domains.model.DisableDomainAutoRenewResponse;
import software.amazon.awssdk.services.route53domains.model.DisableDomainTransferLockRequest;
import software.amazon.awssdk.services.route53domains.model.DisableDomainTransferLockResponse;
import software.amazon.awssdk.services.route53domains.model.DisassociateDelegationSignerFromDomainRequest;
import software.amazon.awssdk.services.route53domains.model.DisassociateDelegationSignerFromDomainResponse;
import software.amazon.awssdk.services.route53domains.model.DnssecLimitExceededException;
import software.amazon.awssdk.services.route53domains.model.DomainLimitExceededException;
import software.amazon.awssdk.services.route53domains.model.DuplicateRequestException;
import software.amazon.awssdk.services.route53domains.model.EnableDomainAutoRenewRequest;
import software.amazon.awssdk.services.route53domains.model.EnableDomainAutoRenewResponse;
import software.amazon.awssdk.services.route53domains.model.EnableDomainTransferLockRequest;
import software.amazon.awssdk.services.route53domains.model.EnableDomainTransferLockResponse;
import software.amazon.awssdk.services.route53domains.model.GetContactReachabilityStatusRequest;
import software.amazon.awssdk.services.route53domains.model.GetContactReachabilityStatusResponse;
import software.amazon.awssdk.services.route53domains.model.GetDomainDetailRequest;
import software.amazon.awssdk.services.route53domains.model.GetDomainDetailResponse;
import software.amazon.awssdk.services.route53domains.model.GetDomainSuggestionsRequest;
import software.amazon.awssdk.services.route53domains.model.GetDomainSuggestionsResponse;
import software.amazon.awssdk.services.route53domains.model.GetOperationDetailRequest;
import software.amazon.awssdk.services.route53domains.model.GetOperationDetailResponse;
import software.amazon.awssdk.services.route53domains.model.InvalidInputException;
import software.amazon.awssdk.services.route53domains.model.ListDomainsRequest;
import software.amazon.awssdk.services.route53domains.model.ListDomainsResponse;
import software.amazon.awssdk.services.route53domains.model.ListOperationsRequest;
import software.amazon.awssdk.services.route53domains.model.ListOperationsResponse;
import software.amazon.awssdk.services.route53domains.model.ListPricesRequest;
import software.amazon.awssdk.services.route53domains.model.ListPricesResponse;
import software.amazon.awssdk.services.route53domains.model.ListTagsForDomainRequest;
import software.amazon.awssdk.services.route53domains.model.ListTagsForDomainResponse;
import software.amazon.awssdk.services.route53domains.model.OperationLimitExceededException;
import software.amazon.awssdk.services.route53domains.model.PushDomainRequest;
import software.amazon.awssdk.services.route53domains.model.PushDomainResponse;
import software.amazon.awssdk.services.route53domains.model.RegisterDomainRequest;
import software.amazon.awssdk.services.route53domains.model.RegisterDomainResponse;
import software.amazon.awssdk.services.route53domains.model.RejectDomainTransferFromAnotherAwsAccountRequest;
import software.amazon.awssdk.services.route53domains.model.RejectDomainTransferFromAnotherAwsAccountResponse;
import software.amazon.awssdk.services.route53domains.model.RenewDomainRequest;
import software.amazon.awssdk.services.route53domains.model.RenewDomainResponse;
import software.amazon.awssdk.services.route53domains.model.ResendContactReachabilityEmailRequest;
import software.amazon.awssdk.services.route53domains.model.ResendContactReachabilityEmailResponse;
import software.amazon.awssdk.services.route53domains.model.ResendOperationAuthorizationRequest;
import software.amazon.awssdk.services.route53domains.model.ResendOperationAuthorizationResponse;
import software.amazon.awssdk.services.route53domains.model.RetrieveDomainAuthCodeRequest;
import software.amazon.awssdk.services.route53domains.model.RetrieveDomainAuthCodeResponse;
import software.amazon.awssdk.services.route53domains.model.Route53DomainsException;
import software.amazon.awssdk.services.route53domains.model.TldRulesViolationException;
import software.amazon.awssdk.services.route53domains.model.TransferDomainRequest;
import software.amazon.awssdk.services.route53domains.model.TransferDomainResponse;
import software.amazon.awssdk.services.route53domains.model.TransferDomainToAnotherAwsAccountRequest;
import software.amazon.awssdk.services.route53domains.model.TransferDomainToAnotherAwsAccountResponse;
import software.amazon.awssdk.services.route53domains.model.UnsupportedTldException;
import software.amazon.awssdk.services.route53domains.model.UpdateDomainContactPrivacyRequest;
import software.amazon.awssdk.services.route53domains.model.UpdateDomainContactPrivacyResponse;
import software.amazon.awssdk.services.route53domains.model.UpdateDomainContactRequest;
import software.amazon.awssdk.services.route53domains.model.UpdateDomainContactResponse;
import software.amazon.awssdk.services.route53domains.model.UpdateDomainNameserversRequest;
import software.amazon.awssdk.services.route53domains.model.UpdateDomainNameserversResponse;
import software.amazon.awssdk.services.route53domains.model.UpdateTagsForDomainRequest;
import software.amazon.awssdk.services.route53domains.model.UpdateTagsForDomainResponse;
import software.amazon.awssdk.services.route53domains.model.ViewBillingRequest;
import software.amazon.awssdk.services.route53domains.model.ViewBillingResponse;
import software.amazon.awssdk.services.route53domains.transform.AcceptDomainTransferFromAnotherAwsAccountRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.AssociateDelegationSignerToDomainRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.CancelDomainTransferToAnotherAwsAccountRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.CheckDomainAvailabilityRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.CheckDomainTransferabilityRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.DeleteDomainRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.DeleteTagsForDomainRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.DisableDomainAutoRenewRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.DisableDomainTransferLockRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.DisassociateDelegationSignerFromDomainRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.EnableDomainAutoRenewRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.EnableDomainTransferLockRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.GetContactReachabilityStatusRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.GetDomainDetailRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.GetDomainSuggestionsRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.GetOperationDetailRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.ListDomainsRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.ListOperationsRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.ListPricesRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.ListTagsForDomainRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.PushDomainRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.RegisterDomainRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.RejectDomainTransferFromAnotherAwsAccountRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.RenewDomainRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.ResendContactReachabilityEmailRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.ResendOperationAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.RetrieveDomainAuthCodeRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.TransferDomainRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.TransferDomainToAnotherAwsAccountRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.UpdateDomainContactPrivacyRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.UpdateDomainContactRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.UpdateDomainNameserversRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.UpdateTagsForDomainRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.ViewBillingRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultRoute53DomainsClient
implements Route53DomainsClient {
    private static final Logger log = Logger.loggerFor(DefaultRoute53DomainsClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultRoute53DomainsClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Route_53_Domains#2.40.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AcceptDomainTransferFromAnotherAwsAccountResponse acceptDomainTransferFromAnotherAwsAccount(AcceptDomainTransferFromAnotherAwsAccountRequest acceptDomainTransferFromAnotherAwsAccountRequest) throws InvalidInputException, OperationLimitExceededException, DomainLimitExceededException, UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AcceptDomainTransferFromAnotherAwsAccountResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "OperationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationLimitExceededException::builder).build());
                }
                case "UnsupportedTLD": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTLD").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTldException::builder).build());
                }
                case "DnssecLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DnssecLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DnssecLimitExceededException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "DomainLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainLimitExceededException::builder).build());
                }
                case "TLDRulesViolation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TLDRulesViolation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TldRulesViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)acceptDomainTransferFromAnotherAwsAccountRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53DomainsClient.resolveMetricPublishers(clientConfiguration, acceptDomainTransferFromAnotherAwsAccountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53 Domains");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AcceptDomainTransferFromAnotherAwsAccount");
            AcceptDomainTransferFromAnotherAwsAccountResponse acceptDomainTransferFromAnotherAwsAccountResponse = (AcceptDomainTransferFromAnotherAwsAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AcceptDomainTransferFromAnotherAwsAccount").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)acceptDomainTransferFromAnotherAwsAccountRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AcceptDomainTransferFromAnotherAwsAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return acceptDomainTransferFromAnotherAwsAccountResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53DomainsClient.lambda$acceptDomainTransferFromAnotherAwsAccount$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateDelegationSignerToDomainResponse associateDelegationSignerToDomain(AssociateDelegationSignerToDomainRequest associateDelegationSignerToDomainRequest) throws DuplicateRequestException, InvalidInputException, OperationLimitExceededException, TldRulesViolationException, UnsupportedTldException, DnssecLimitExceededException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateDelegationSignerToDomainResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "OperationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationLimitExceededException::builder).build());
                }
                case "UnsupportedTLD": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTLD").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTldException::builder).build());
                }
                case "DnssecLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DnssecLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DnssecLimitExceededException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "DomainLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainLimitExceededException::builder).build());
                }
                case "TLDRulesViolation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TLDRulesViolation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TldRulesViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)associateDelegationSignerToDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53DomainsClient.resolveMetricPublishers(clientConfiguration, associateDelegationSignerToDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53 Domains");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateDelegationSignerToDomain");
            AssociateDelegationSignerToDomainResponse associateDelegationSignerToDomainResponse = (AssociateDelegationSignerToDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateDelegationSignerToDomain").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)associateDelegationSignerToDomainRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateDelegationSignerToDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateDelegationSignerToDomainResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53DomainsClient.lambda$associateDelegationSignerToDomain$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelDomainTransferToAnotherAwsAccountResponse cancelDomainTransferToAnotherAwsAccount(CancelDomainTransferToAnotherAwsAccountRequest cancelDomainTransferToAnotherAwsAccountRequest) throws InvalidInputException, OperationLimitExceededException, UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelDomainTransferToAnotherAwsAccountResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "OperationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationLimitExceededException::builder).build());
                }
                case "UnsupportedTLD": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTLD").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTldException::builder).build());
                }
                case "DnssecLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DnssecLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DnssecLimitExceededException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "DomainLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainLimitExceededException::builder).build());
                }
                case "TLDRulesViolation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TLDRulesViolation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TldRulesViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelDomainTransferToAnotherAwsAccountRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53DomainsClient.resolveMetricPublishers(clientConfiguration, cancelDomainTransferToAnotherAwsAccountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53 Domains");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelDomainTransferToAnotherAwsAccount");
            CancelDomainTransferToAnotherAwsAccountResponse cancelDomainTransferToAnotherAwsAccountResponse = (CancelDomainTransferToAnotherAwsAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelDomainTransferToAnotherAwsAccount").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)cancelDomainTransferToAnotherAwsAccountRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelDomainTransferToAnotherAwsAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelDomainTransferToAnotherAwsAccountResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53DomainsClient.lambda$cancelDomainTransferToAnotherAwsAccount$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CheckDomainAvailabilityResponse checkDomainAvailability(CheckDomainAvailabilityRequest checkDomainAvailabilityRequest) throws InvalidInputException, UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CheckDomainAvailabilityResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "OperationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationLimitExceededException::builder).build());
                }
                case "UnsupportedTLD": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTLD").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTldException::builder).build());
                }
                case "DnssecLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DnssecLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DnssecLimitExceededException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "DomainLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainLimitExceededException::builder).build());
                }
                case "TLDRulesViolation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TLDRulesViolation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TldRulesViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)checkDomainAvailabilityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53DomainsClient.resolveMetricPublishers(clientConfiguration, checkDomainAvailabilityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53 Domains");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CheckDomainAvailability");
            CheckDomainAvailabilityResponse checkDomainAvailabilityResponse = (CheckDomainAvailabilityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CheckDomainAvailability").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)checkDomainAvailabilityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CheckDomainAvailabilityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return checkDomainAvailabilityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53DomainsClient.lambda$checkDomainAvailability$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CheckDomainTransferabilityResponse checkDomainTransferability(CheckDomainTransferabilityRequest checkDomainTransferabilityRequest) throws InvalidInputException, UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CheckDomainTransferabilityResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "OperationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationLimitExceededException::builder).build());
                }
                case "UnsupportedTLD": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTLD").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTldException::builder).build());
                }
                case "DnssecLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DnssecLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DnssecLimitExceededException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "DomainLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainLimitExceededException::builder).build());
                }
                case "TLDRulesViolation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TLDRulesViolation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TldRulesViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)checkDomainTransferabilityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53DomainsClient.resolveMetricPublishers(clientConfiguration, checkDomainTransferabilityRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53 Domains");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CheckDomainTransferability");
            CheckDomainTransferabilityResponse checkDomainTransferabilityResponse = (CheckDomainTransferabilityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CheckDomainTransferability").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)checkDomainTransferabilityRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CheckDomainTransferabilityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return checkDomainTransferabilityResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53DomainsClient.lambda$checkDomainTransferability$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDomainResponse deleteDomain(DeleteDomainRequest deleteDomainRequest) throws InvalidInputException, DuplicateRequestException, TldRulesViolationException, UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDomainResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "OperationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationLimitExceededException::builder).build());
                }
                case "UnsupportedTLD": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTLD").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTldException::builder).build());
                }
                case "DnssecLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DnssecLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DnssecLimitExceededException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "DomainLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainLimitExceededException::builder).build());
                }
                case "TLDRulesViolation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TLDRulesViolation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TldRulesViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53DomainsClient.resolveMetricPublishers(clientConfiguration, deleteDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53 Domains");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDomain");
            DeleteDomainResponse deleteDomainResponse = (DeleteDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDomain").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteDomainRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDomainResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53DomainsClient.lambda$deleteDomain$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTagsForDomainResponse deleteTagsForDomain(DeleteTagsForDomainRequest deleteTagsForDomainRequest) throws InvalidInputException, OperationLimitExceededException, UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTagsForDomainResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "OperationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationLimitExceededException::builder).build());
                }
                case "UnsupportedTLD": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTLD").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTldException::builder).build());
                }
                case "DnssecLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DnssecLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DnssecLimitExceededException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "DomainLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainLimitExceededException::builder).build());
                }
                case "TLDRulesViolation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TLDRulesViolation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TldRulesViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTagsForDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53DomainsClient.resolveMetricPublishers(clientConfiguration, deleteTagsForDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53 Domains");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTagsForDomain");
            DeleteTagsForDomainResponse deleteTagsForDomainResponse = (DeleteTagsForDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTagsForDomain").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteTagsForDomainRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTagsForDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteTagsForDomainResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53DomainsClient.lambda$deleteTagsForDomain$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableDomainAutoRenewResponse disableDomainAutoRenew(DisableDomainAutoRenewRequest disableDomainAutoRenewRequest) throws InvalidInputException, UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableDomainAutoRenewResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "OperationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationLimitExceededException::builder).build());
                }
                case "UnsupportedTLD": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTLD").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTldException::builder).build());
                }
                case "DnssecLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DnssecLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DnssecLimitExceededException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "DomainLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainLimitExceededException::builder).build());
                }
                case "TLDRulesViolation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TLDRulesViolation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TldRulesViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disableDomainAutoRenewRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53DomainsClient.resolveMetricPublishers(clientConfiguration, disableDomainAutoRenewRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53 Domains");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableDomainAutoRenew");
            DisableDomainAutoRenewResponse disableDomainAutoRenewResponse = (DisableDomainAutoRenewResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableDomainAutoRenew").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disableDomainAutoRenewRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisableDomainAutoRenewRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disableDomainAutoRenewResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53DomainsClient.lambda$disableDomainAutoRenew$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableDomainTransferLockResponse disableDomainTransferLock(DisableDomainTransferLockRequest disableDomainTransferLockRequest) throws InvalidInputException, DuplicateRequestException, TldRulesViolationException, OperationLimitExceededException, UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableDomainTransferLockResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "OperationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationLimitExceededException::builder).build());
                }
                case "UnsupportedTLD": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTLD").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTldException::builder).build());
                }
                case "DnssecLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DnssecLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DnssecLimitExceededException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "DomainLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainLimitExceededException::builder).build());
                }
                case "TLDRulesViolation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TLDRulesViolation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TldRulesViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disableDomainTransferLockRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53DomainsClient.resolveMetricPublishers(clientConfiguration, disableDomainTransferLockRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53 Domains");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableDomainTransferLock");
            DisableDomainTransferLockResponse disableDomainTransferLockResponse = (DisableDomainTransferLockResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableDomainTransferLock").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disableDomainTransferLockRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisableDomainTransferLockRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disableDomainTransferLockResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53DomainsClient.lambda$disableDomainTransferLock$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateDelegationSignerFromDomainResponse disassociateDelegationSignerFromDomain(DisassociateDelegationSignerFromDomainRequest disassociateDelegationSignerFromDomainRequest) throws DuplicateRequestException, InvalidInputException, OperationLimitExceededException, TldRulesViolationException, UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateDelegationSignerFromDomainResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "OperationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationLimitExceededException::builder).build());
                }
                case "UnsupportedTLD": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTLD").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTldException::builder).build());
                }
                case "DnssecLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DnssecLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DnssecLimitExceededException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "DomainLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainLimitExceededException::builder).build());
                }
                case "TLDRulesViolation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TLDRulesViolation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TldRulesViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disassociateDelegationSignerFromDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53DomainsClient.resolveMetricPublishers(clientConfiguration, disassociateDelegationSignerFromDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53 Domains");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateDelegationSignerFromDomain");
            DisassociateDelegationSignerFromDomainResponse disassociateDelegationSignerFromDomainResponse = (DisassociateDelegationSignerFromDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateDelegationSignerFromDomain").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disassociateDelegationSignerFromDomainRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateDelegationSignerFromDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateDelegationSignerFromDomainResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53DomainsClient.lambda$disassociateDelegationSignerFromDomain$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableDomainAutoRenewResponse enableDomainAutoRenew(EnableDomainAutoRenewRequest enableDomainAutoRenewRequest) throws InvalidInputException, UnsupportedTldException, TldRulesViolationException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableDomainAutoRenewResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "OperationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationLimitExceededException::builder).build());
                }
                case "UnsupportedTLD": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTLD").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTldException::builder).build());
                }
                case "DnssecLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DnssecLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DnssecLimitExceededException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "DomainLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainLimitExceededException::builder).build());
                }
                case "TLDRulesViolation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TLDRulesViolation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TldRulesViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)enableDomainAutoRenewRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53DomainsClient.resolveMetricPublishers(clientConfiguration, enableDomainAutoRenewRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53 Domains");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableDomainAutoRenew");
            EnableDomainAutoRenewResponse enableDomainAutoRenewResponse = (EnableDomainAutoRenewResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableDomainAutoRenew").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)enableDomainAutoRenewRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EnableDomainAutoRenewRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return enableDomainAutoRenewResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53DomainsClient.lambda$enableDomainAutoRenew$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableDomainTransferLockResponse enableDomainTransferLock(EnableDomainTransferLockRequest enableDomainTransferLockRequest) throws InvalidInputException, DuplicateRequestException, TldRulesViolationException, OperationLimitExceededException, UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableDomainTransferLockResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "OperationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationLimitExceededException::builder).build());
                }
                case "UnsupportedTLD": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTLD").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTldException::builder).build());
                }
                case "DnssecLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DnssecLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DnssecLimitExceededException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "DomainLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainLimitExceededException::builder).build());
                }
                case "TLDRulesViolation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TLDRulesViolation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TldRulesViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)enableDomainTransferLockRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53DomainsClient.resolveMetricPublishers(clientConfiguration, enableDomainTransferLockRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53 Domains");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableDomainTransferLock");
            EnableDomainTransferLockResponse enableDomainTransferLockResponse = (EnableDomainTransferLockResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableDomainTransferLock").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)enableDomainTransferLockRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EnableDomainTransferLockRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return enableDomainTransferLockResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53DomainsClient.lambda$enableDomainTransferLock$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetContactReachabilityStatusResponse getContactReachabilityStatus(GetContactReachabilityStatusRequest getContactReachabilityStatusRequest) throws InvalidInputException, OperationLimitExceededException, UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetContactReachabilityStatusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "OperationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationLimitExceededException::builder).build());
                }
                case "UnsupportedTLD": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTLD").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTldException::builder).build());
                }
                case "DnssecLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DnssecLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DnssecLimitExceededException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "DomainLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainLimitExceededException::builder).build());
                }
                case "TLDRulesViolation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TLDRulesViolation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TldRulesViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getContactReachabilityStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53DomainsClient.resolveMetricPublishers(clientConfiguration, getContactReachabilityStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53 Domains");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetContactReachabilityStatus");
            GetContactReachabilityStatusResponse getContactReachabilityStatusResponse = (GetContactReachabilityStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetContactReachabilityStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getContactReachabilityStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetContactReachabilityStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getContactReachabilityStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53DomainsClient.lambda$getContactReachabilityStatus$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDomainDetailResponse getDomainDetail(GetDomainDetailRequest getDomainDetailRequest) throws InvalidInputException, UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDomainDetailResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "OperationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationLimitExceededException::builder).build());
                }
                case "UnsupportedTLD": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTLD").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTldException::builder).build());
                }
                case "DnssecLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DnssecLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DnssecLimitExceededException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "DomainLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainLimitExceededException::builder).build());
                }
                case "TLDRulesViolation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TLDRulesViolation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TldRulesViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDomainDetailRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53DomainsClient.resolveMetricPublishers(clientConfiguration, getDomainDetailRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53 Domains");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDomainDetail");
            GetDomainDetailResponse getDomainDetailResponse = (GetDomainDetailResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDomainDetail").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDomainDetailRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDomainDetailRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDomainDetailResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53DomainsClient.lambda$getDomainDetail$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDomainSuggestionsResponse getDomainSuggestions(GetDomainSuggestionsRequest getDomainSuggestionsRequest) throws InvalidInputException, UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDomainSuggestionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "OperationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationLimitExceededException::builder).build());
                }
                case "UnsupportedTLD": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTLD").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTldException::builder).build());
                }
                case "DnssecLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DnssecLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DnssecLimitExceededException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "DomainLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainLimitExceededException::builder).build());
                }
                case "TLDRulesViolation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TLDRulesViolation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TldRulesViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDomainSuggestionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53DomainsClient.resolveMetricPublishers(clientConfiguration, getDomainSuggestionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53 Domains");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDomainSuggestions");
            GetDomainSuggestionsResponse getDomainSuggestionsResponse = (GetDomainSuggestionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDomainSuggestions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDomainSuggestionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDomainSuggestionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDomainSuggestionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53DomainsClient.lambda$getDomainSuggestions$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetOperationDetailResponse getOperationDetail(GetOperationDetailRequest getOperationDetailRequest) throws InvalidInputException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetOperationDetailResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "OperationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationLimitExceededException::builder).build());
                }
                case "UnsupportedTLD": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTLD").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTldException::builder).build());
                }
                case "DnssecLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DnssecLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DnssecLimitExceededException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "DomainLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainLimitExceededException::builder).build());
                }
                case "TLDRulesViolation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TLDRulesViolation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TldRulesViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getOperationDetailRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53DomainsClient.resolveMetricPublishers(clientConfiguration, getOperationDetailRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53 Domains");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetOperationDetail");
            GetOperationDetailResponse getOperationDetailResponse = (GetOperationDetailResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetOperationDetail").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getOperationDetailRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetOperationDetailRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getOperationDetailResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53DomainsClient.lambda$getOperationDetail$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDomainsResponse listDomains(ListDomainsRequest listDomainsRequest) throws InvalidInputException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDomainsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "OperationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationLimitExceededException::builder).build());
                }
                case "UnsupportedTLD": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTLD").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTldException::builder).build());
                }
                case "DnssecLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DnssecLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DnssecLimitExceededException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "DomainLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainLimitExceededException::builder).build());
                }
                case "TLDRulesViolation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TLDRulesViolation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TldRulesViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDomainsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53DomainsClient.resolveMetricPublishers(clientConfiguration, listDomainsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53 Domains");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDomains");
            ListDomainsResponse listDomainsResponse = (ListDomainsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDomains").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listDomainsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDomainsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDomainsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53DomainsClient.lambda$listDomains$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListOperationsResponse listOperations(ListOperationsRequest listOperationsRequest) throws InvalidInputException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListOperationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "OperationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationLimitExceededException::builder).build());
                }
                case "UnsupportedTLD": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTLD").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTldException::builder).build());
                }
                case "DnssecLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DnssecLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DnssecLimitExceededException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "DomainLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainLimitExceededException::builder).build());
                }
                case "TLDRulesViolation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TLDRulesViolation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TldRulesViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listOperationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53DomainsClient.resolveMetricPublishers(clientConfiguration, listOperationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53 Domains");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListOperations");
            ListOperationsResponse listOperationsResponse = (ListOperationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListOperations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listOperationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListOperationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listOperationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53DomainsClient.lambda$listOperations$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPricesResponse listPrices(ListPricesRequest listPricesRequest) throws InvalidInputException, UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPricesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "OperationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationLimitExceededException::builder).build());
                }
                case "UnsupportedTLD": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTLD").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTldException::builder).build());
                }
                case "DnssecLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DnssecLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DnssecLimitExceededException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "DomainLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainLimitExceededException::builder).build());
                }
                case "TLDRulesViolation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TLDRulesViolation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TldRulesViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listPricesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53DomainsClient.resolveMetricPublishers(clientConfiguration, listPricesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53 Domains");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListPrices");
            ListPricesResponse listPricesResponse = (ListPricesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPrices").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listPricesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListPricesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listPricesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53DomainsClient.lambda$listPrices$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForDomainResponse listTagsForDomain(ListTagsForDomainRequest listTagsForDomainRequest) throws InvalidInputException, OperationLimitExceededException, UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForDomainResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "OperationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationLimitExceededException::builder).build());
                }
                case "UnsupportedTLD": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTLD").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTldException::builder).build());
                }
                case "DnssecLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DnssecLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DnssecLimitExceededException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "DomainLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainLimitExceededException::builder).build());
                }
                case "TLDRulesViolation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TLDRulesViolation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TldRulesViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53DomainsClient.resolveMetricPublishers(clientConfiguration, listTagsForDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53 Domains");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForDomain");
            ListTagsForDomainResponse listTagsForDomainResponse = (ListTagsForDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForDomain").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForDomainRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForDomainResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53DomainsClient.lambda$listTagsForDomain$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PushDomainResponse pushDomain(PushDomainRequest pushDomainRequest) throws InvalidInputException, OperationLimitExceededException, UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PushDomainResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "OperationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationLimitExceededException::builder).build());
                }
                case "UnsupportedTLD": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTLD").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTldException::builder).build());
                }
                case "DnssecLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DnssecLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DnssecLimitExceededException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "DomainLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainLimitExceededException::builder).build());
                }
                case "TLDRulesViolation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TLDRulesViolation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TldRulesViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)pushDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53DomainsClient.resolveMetricPublishers(clientConfiguration, pushDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53 Domains");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PushDomain");
            PushDomainResponse pushDomainResponse = (PushDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PushDomain").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)pushDomainRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PushDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return pushDomainResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53DomainsClient.lambda$pushDomain$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterDomainResponse registerDomain(RegisterDomainRequest registerDomainRequest) throws InvalidInputException, UnsupportedTldException, DuplicateRequestException, TldRulesViolationException, DomainLimitExceededException, OperationLimitExceededException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterDomainResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "OperationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationLimitExceededException::builder).build());
                }
                case "UnsupportedTLD": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTLD").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTldException::builder).build());
                }
                case "DnssecLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DnssecLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DnssecLimitExceededException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "DomainLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainLimitExceededException::builder).build());
                }
                case "TLDRulesViolation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TLDRulesViolation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TldRulesViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)registerDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53DomainsClient.resolveMetricPublishers(clientConfiguration, registerDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53 Domains");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterDomain");
            RegisterDomainResponse registerDomainResponse = (RegisterDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterDomain").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)registerDomainRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RegisterDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return registerDomainResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53DomainsClient.lambda$registerDomain$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RejectDomainTransferFromAnotherAwsAccountResponse rejectDomainTransferFromAnotherAwsAccount(RejectDomainTransferFromAnotherAwsAccountRequest rejectDomainTransferFromAnotherAwsAccountRequest) throws InvalidInputException, OperationLimitExceededException, UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RejectDomainTransferFromAnotherAwsAccountResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "OperationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationLimitExceededException::builder).build());
                }
                case "UnsupportedTLD": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTLD").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTldException::builder).build());
                }
                case "DnssecLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DnssecLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DnssecLimitExceededException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "DomainLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainLimitExceededException::builder).build());
                }
                case "TLDRulesViolation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TLDRulesViolation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TldRulesViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)rejectDomainTransferFromAnotherAwsAccountRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53DomainsClient.resolveMetricPublishers(clientConfiguration, rejectDomainTransferFromAnotherAwsAccountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53 Domains");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RejectDomainTransferFromAnotherAwsAccount");
            RejectDomainTransferFromAnotherAwsAccountResponse rejectDomainTransferFromAnotherAwsAccountResponse = (RejectDomainTransferFromAnotherAwsAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RejectDomainTransferFromAnotherAwsAccount").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)rejectDomainTransferFromAnotherAwsAccountRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RejectDomainTransferFromAnotherAwsAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return rejectDomainTransferFromAnotherAwsAccountResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53DomainsClient.lambda$rejectDomainTransferFromAnotherAwsAccount$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RenewDomainResponse renewDomain(RenewDomainRequest renewDomainRequest) throws InvalidInputException, UnsupportedTldException, DuplicateRequestException, TldRulesViolationException, OperationLimitExceededException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RenewDomainResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "OperationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationLimitExceededException::builder).build());
                }
                case "UnsupportedTLD": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTLD").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTldException::builder).build());
                }
                case "DnssecLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DnssecLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DnssecLimitExceededException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "DomainLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainLimitExceededException::builder).build());
                }
                case "TLDRulesViolation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TLDRulesViolation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TldRulesViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)renewDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53DomainsClient.resolveMetricPublishers(clientConfiguration, renewDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53 Domains");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RenewDomain");
            RenewDomainResponse renewDomainResponse = (RenewDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RenewDomain").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)renewDomainRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RenewDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return renewDomainResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53DomainsClient.lambda$renewDomain$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResendContactReachabilityEmailResponse resendContactReachabilityEmail(ResendContactReachabilityEmailRequest resendContactReachabilityEmailRequest) throws InvalidInputException, OperationLimitExceededException, UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ResendContactReachabilityEmailResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "OperationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationLimitExceededException::builder).build());
                }
                case "UnsupportedTLD": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTLD").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTldException::builder).build());
                }
                case "DnssecLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DnssecLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DnssecLimitExceededException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "DomainLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainLimitExceededException::builder).build());
                }
                case "TLDRulesViolation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TLDRulesViolation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TldRulesViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)resendContactReachabilityEmailRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53DomainsClient.resolveMetricPublishers(clientConfiguration, resendContactReachabilityEmailRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53 Domains");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResendContactReachabilityEmail");
            ResendContactReachabilityEmailResponse resendContactReachabilityEmailResponse = (ResendContactReachabilityEmailResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResendContactReachabilityEmail").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)resendContactReachabilityEmailRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ResendContactReachabilityEmailRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return resendContactReachabilityEmailResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53DomainsClient.lambda$resendContactReachabilityEmail$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResendOperationAuthorizationResponse resendOperationAuthorization(ResendOperationAuthorizationRequest resendOperationAuthorizationRequest) throws InvalidInputException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ResendOperationAuthorizationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "OperationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationLimitExceededException::builder).build());
                }
                case "UnsupportedTLD": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTLD").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTldException::builder).build());
                }
                case "DnssecLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DnssecLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DnssecLimitExceededException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "DomainLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainLimitExceededException::builder).build());
                }
                case "TLDRulesViolation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TLDRulesViolation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TldRulesViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)resendOperationAuthorizationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53DomainsClient.resolveMetricPublishers(clientConfiguration, resendOperationAuthorizationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53 Domains");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ResendOperationAuthorization");
            ResendOperationAuthorizationResponse resendOperationAuthorizationResponse = (ResendOperationAuthorizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResendOperationAuthorization").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)resendOperationAuthorizationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ResendOperationAuthorizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return resendOperationAuthorizationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53DomainsClient.lambda$resendOperationAuthorization$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RetrieveDomainAuthCodeResponse retrieveDomainAuthCode(RetrieveDomainAuthCodeRequest retrieveDomainAuthCodeRequest) throws InvalidInputException, UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RetrieveDomainAuthCodeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "OperationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationLimitExceededException::builder).build());
                }
                case "UnsupportedTLD": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTLD").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTldException::builder).build());
                }
                case "DnssecLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DnssecLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DnssecLimitExceededException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "DomainLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainLimitExceededException::builder).build());
                }
                case "TLDRulesViolation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TLDRulesViolation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TldRulesViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)retrieveDomainAuthCodeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53DomainsClient.resolveMetricPublishers(clientConfiguration, retrieveDomainAuthCodeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53 Domains");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RetrieveDomainAuthCode");
            RetrieveDomainAuthCodeResponse retrieveDomainAuthCodeResponse = (RetrieveDomainAuthCodeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RetrieveDomainAuthCode").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)retrieveDomainAuthCodeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RetrieveDomainAuthCodeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return retrieveDomainAuthCodeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53DomainsClient.lambda$retrieveDomainAuthCode$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransferDomainResponse transferDomain(TransferDomainRequest transferDomainRequest) throws InvalidInputException, UnsupportedTldException, DuplicateRequestException, TldRulesViolationException, DomainLimitExceededException, OperationLimitExceededException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TransferDomainResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "OperationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationLimitExceededException::builder).build());
                }
                case "UnsupportedTLD": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTLD").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTldException::builder).build());
                }
                case "DnssecLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DnssecLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DnssecLimitExceededException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "DomainLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainLimitExceededException::builder).build());
                }
                case "TLDRulesViolation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TLDRulesViolation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TldRulesViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)transferDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53DomainsClient.resolveMetricPublishers(clientConfiguration, transferDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53 Domains");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TransferDomain");
            TransferDomainResponse transferDomainResponse = (TransferDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TransferDomain").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)transferDomainRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TransferDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return transferDomainResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53DomainsClient.lambda$transferDomain$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransferDomainToAnotherAwsAccountResponse transferDomainToAnotherAwsAccount(TransferDomainToAnotherAwsAccountRequest transferDomainToAnotherAwsAccountRequest) throws InvalidInputException, OperationLimitExceededException, DuplicateRequestException, UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TransferDomainToAnotherAwsAccountResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "OperationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationLimitExceededException::builder).build());
                }
                case "UnsupportedTLD": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTLD").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTldException::builder).build());
                }
                case "DnssecLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DnssecLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DnssecLimitExceededException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "DomainLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainLimitExceededException::builder).build());
                }
                case "TLDRulesViolation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TLDRulesViolation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TldRulesViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)transferDomainToAnotherAwsAccountRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53DomainsClient.resolveMetricPublishers(clientConfiguration, transferDomainToAnotherAwsAccountRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53 Domains");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TransferDomainToAnotherAwsAccount");
            TransferDomainToAnotherAwsAccountResponse transferDomainToAnotherAwsAccountResponse = (TransferDomainToAnotherAwsAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TransferDomainToAnotherAwsAccount").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)transferDomainToAnotherAwsAccountRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TransferDomainToAnotherAwsAccountRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return transferDomainToAnotherAwsAccountResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53DomainsClient.lambda$transferDomainToAnotherAwsAccount$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDomainContactResponse updateDomainContact(UpdateDomainContactRequest updateDomainContactRequest) throws InvalidInputException, DuplicateRequestException, TldRulesViolationException, OperationLimitExceededException, UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDomainContactResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "OperationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationLimitExceededException::builder).build());
                }
                case "UnsupportedTLD": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTLD").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTldException::builder).build());
                }
                case "DnssecLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DnssecLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DnssecLimitExceededException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "DomainLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainLimitExceededException::builder).build());
                }
                case "TLDRulesViolation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TLDRulesViolation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TldRulesViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateDomainContactRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53DomainsClient.resolveMetricPublishers(clientConfiguration, updateDomainContactRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53 Domains");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDomainContact");
            UpdateDomainContactResponse updateDomainContactResponse = (UpdateDomainContactResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDomainContact").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateDomainContactRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateDomainContactRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateDomainContactResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53DomainsClient.lambda$updateDomainContact$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDomainContactPrivacyResponse updateDomainContactPrivacy(UpdateDomainContactPrivacyRequest updateDomainContactPrivacyRequest) throws InvalidInputException, DuplicateRequestException, TldRulesViolationException, OperationLimitExceededException, UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDomainContactPrivacyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "OperationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationLimitExceededException::builder).build());
                }
                case "UnsupportedTLD": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTLD").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTldException::builder).build());
                }
                case "DnssecLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DnssecLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DnssecLimitExceededException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "DomainLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainLimitExceededException::builder).build());
                }
                case "TLDRulesViolation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TLDRulesViolation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TldRulesViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateDomainContactPrivacyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53DomainsClient.resolveMetricPublishers(clientConfiguration, updateDomainContactPrivacyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53 Domains");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDomainContactPrivacy");
            UpdateDomainContactPrivacyResponse updateDomainContactPrivacyResponse = (UpdateDomainContactPrivacyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDomainContactPrivacy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateDomainContactPrivacyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateDomainContactPrivacyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateDomainContactPrivacyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53DomainsClient.lambda$updateDomainContactPrivacy$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDomainNameserversResponse updateDomainNameservers(UpdateDomainNameserversRequest updateDomainNameserversRequest) throws InvalidInputException, DuplicateRequestException, TldRulesViolationException, OperationLimitExceededException, UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDomainNameserversResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "OperationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationLimitExceededException::builder).build());
                }
                case "UnsupportedTLD": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTLD").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTldException::builder).build());
                }
                case "DnssecLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DnssecLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DnssecLimitExceededException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "DomainLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainLimitExceededException::builder).build());
                }
                case "TLDRulesViolation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TLDRulesViolation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TldRulesViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateDomainNameserversRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53DomainsClient.resolveMetricPublishers(clientConfiguration, updateDomainNameserversRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53 Domains");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDomainNameservers");
            UpdateDomainNameserversResponse updateDomainNameserversResponse = (UpdateDomainNameserversResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDomainNameservers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateDomainNameserversRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateDomainNameserversRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateDomainNameserversResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53DomainsClient.lambda$updateDomainNameservers$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateTagsForDomainResponse updateTagsForDomain(UpdateTagsForDomainRequest updateTagsForDomainRequest) throws InvalidInputException, OperationLimitExceededException, UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTagsForDomainResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "OperationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationLimitExceededException::builder).build());
                }
                case "UnsupportedTLD": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTLD").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTldException::builder).build());
                }
                case "DnssecLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DnssecLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DnssecLimitExceededException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "DomainLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainLimitExceededException::builder).build());
                }
                case "TLDRulesViolation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TLDRulesViolation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TldRulesViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateTagsForDomainRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53DomainsClient.resolveMetricPublishers(clientConfiguration, updateTagsForDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53 Domains");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTagsForDomain");
            UpdateTagsForDomainResponse updateTagsForDomainResponse = (UpdateTagsForDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTagsForDomain").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateTagsForDomainRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateTagsForDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateTagsForDomainResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53DomainsClient.lambda$updateTagsForDomain$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ViewBillingResponse viewBilling(ViewBillingRequest viewBillingRequest) throws InvalidInputException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ViewBillingResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "DuplicateRequest": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DuplicateRequest").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DuplicateRequestException::builder).build());
                }
                case "OperationLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationLimitExceededException::builder).build());
                }
                case "UnsupportedTLD": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedTLD").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedTldException::builder).build());
                }
                case "DnssecLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DnssecLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DnssecLimitExceededException::builder).build());
                }
                case "InvalidInput": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInput").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInputException::builder).build());
                }
                case "DomainLimitExceeded": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DomainLimitExceeded").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DomainLimitExceededException::builder).build());
                }
                case "TLDRulesViolation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TLDRulesViolation").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TldRulesViolationException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)viewBillingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRoute53DomainsClient.resolveMetricPublishers(clientConfiguration, viewBillingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53 Domains");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ViewBilling");
            ViewBillingResponse viewBillingResponse = (ViewBillingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ViewBilling").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)viewBillingRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ViewBillingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return viewBillingResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRoute53DomainsClient.lambda$viewBilling$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "route53domains";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        Route53DomainsServiceClientConfigurationBuilder serviceConfigBuilder = new Route53DomainsServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(Route53DomainsException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    @Override
    public final Route53DomainsServiceClientConfiguration serviceClientConfiguration() {
        return new Route53DomainsServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$viewBilling$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateTagsForDomain$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDomainNameservers$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDomainContactPrivacy$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDomainContact$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$transferDomainToAnotherAwsAccount$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$transferDomain$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$retrieveDomainAuthCode$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$resendOperationAuthorization$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$resendContactReachabilityEmail$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$renewDomain$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$rejectDomainTransferFromAnotherAwsAccount$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerDomain$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$pushDomain$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForDomain$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listPrices$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listOperations$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDomains$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getOperationDetail$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDomainSuggestions$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDomainDetail$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getContactReachabilityStatus$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableDomainTransferLock$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableDomainAutoRenew$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateDelegationSignerFromDomain$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disableDomainTransferLock$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disableDomainAutoRenew$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTagsForDomain$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDomain$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$checkDomainTransferability$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$checkDomainAvailability$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelDomainTransferToAnotherAwsAccount$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateDelegationSignerToDomain$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$acceptDomainTransferFromAnotherAwsAccount$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

