/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53domains.Route53DomainsAsyncClient;
import software.amazon.awssdk.services.route53domains.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53domains.model.DomainPrice;
import software.amazon.awssdk.services.route53domains.model.ListPricesRequest;
import software.amazon.awssdk.services.route53domains.model.ListPricesResponse;

public class ListPricesPublisher
implements SdkPublisher<ListPricesResponse> {
    private final Route53DomainsAsyncClient client;
    private final ListPricesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPricesPublisher(Route53DomainsAsyncClient client, ListPricesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPricesPublisher(Route53DomainsAsyncClient client, ListPricesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPricesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPricesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DomainPrice> prices() {
        Function<ListPricesResponse, Iterator> getIterator = response -> {
            if (response != null && response.prices() != null) {
                return response.prices().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPricesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPricesResponseFetcher
    implements AsyncPageFetcher<ListPricesResponse> {
        private ListPricesResponseFetcher() {
        }

        public boolean hasNextPage(ListPricesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageMarker());
        }

        public CompletableFuture<ListPricesResponse> nextPage(ListPricesResponse previousPage) {
            if (previousPage == null) {
                return ListPricesPublisher.this.client.listPrices(ListPricesPublisher.this.firstRequest);
            }
            return ListPricesPublisher.this.client.listPrices((ListPricesRequest)((Object)ListPricesPublisher.this.firstRequest.toBuilder().marker(previousPage.nextPageMarker()).build()));
        }
    }
}

