/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53globalresolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.route53globalresolver.model.DnsSecValidationType;
import software.amazon.awssdk.services.route53globalresolver.model.EdnsClientSubnetType;
import software.amazon.awssdk.services.route53globalresolver.model.FirewallRulesFailOpenType;
import software.amazon.awssdk.services.route53globalresolver.model.Route53GlobalResolverRequest;
import software.amazon.awssdk.services.route53globalresolver.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDnsViewRequest
extends Route53GlobalResolverRequest
implements ToCopyableBuilder<Builder, CreateDnsViewRequest> {
    private static final SdkField<String> GLOBAL_RESOLVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("globalResolverId").getter(CreateDnsViewRequest.getter(CreateDnsViewRequest::globalResolverId)).setter(CreateDnsViewRequest.setter(Builder::globalResolverId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("globalResolverId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateDnsViewRequest.getter(CreateDnsViewRequest::clientToken)).setter(CreateDnsViewRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateDnsViewRequest.getter(CreateDnsViewRequest::name)).setter(CreateDnsViewRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DNSSEC_VALIDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dnssecValidation").getter(CreateDnsViewRequest.getter(CreateDnsViewRequest::dnssecValidationAsString)).setter(CreateDnsViewRequest.setter(Builder::dnssecValidation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnssecValidation").build()}).build();
    private static final SdkField<String> EDNS_CLIENT_SUBNET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ednsClientSubnet").getter(CreateDnsViewRequest.getter(CreateDnsViewRequest::ednsClientSubnetAsString)).setter(CreateDnsViewRequest.setter(Builder::ednsClientSubnet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ednsClientSubnet").build()}).build();
    private static final SdkField<String> FIREWALL_RULES_FAIL_OPEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("firewallRulesFailOpen").getter(CreateDnsViewRequest.getter(CreateDnsViewRequest::firewallRulesFailOpenAsString)).setter(CreateDnsViewRequest.setter(Builder::firewallRulesFailOpen)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firewallRulesFailOpen").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateDnsViewRequest.getter(CreateDnsViewRequest::description)).setter(CreateDnsViewRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateDnsViewRequest.getter(CreateDnsViewRequest::tags)).setter(CreateDnsViewRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_RESOLVER_ID_FIELD, CLIENT_TOKEN_FIELD, NAME_FIELD, DNSSEC_VALIDATION_FIELD, EDNS_CLIENT_SUBNET_FIELD, FIREWALL_RULES_FAIL_OPEN_FIELD, DESCRIPTION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDnsViewRequest.memberNameToFieldInitializer();
    private final String globalResolverId;
    private final String clientToken;
    private final String name;
    private final String dnssecValidation;
    private final String ednsClientSubnet;
    private final String firewallRulesFailOpen;
    private final String description;
    private final Map<String, String> tags;

    private CreateDnsViewRequest(BuilderImpl builder) {
        super(builder);
        this.globalResolverId = builder.globalResolverId;
        this.clientToken = builder.clientToken;
        this.name = builder.name;
        this.dnssecValidation = builder.dnssecValidation;
        this.ednsClientSubnet = builder.ednsClientSubnet;
        this.firewallRulesFailOpen = builder.firewallRulesFailOpen;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    public final String globalResolverId() {
        return this.globalResolverId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String name() {
        return this.name;
    }

    public final DnsSecValidationType dnssecValidation() {
        return DnsSecValidationType.fromValue(this.dnssecValidation);
    }

    public final String dnssecValidationAsString() {
        return this.dnssecValidation;
    }

    public final EdnsClientSubnetType ednsClientSubnet() {
        return EdnsClientSubnetType.fromValue(this.ednsClientSubnet);
    }

    public final String ednsClientSubnetAsString() {
        return this.ednsClientSubnet;
    }

    public final FirewallRulesFailOpenType firewallRulesFailOpen() {
        return FirewallRulesFailOpenType.fromValue(this.firewallRulesFailOpen);
    }

    public final String firewallRulesFailOpenAsString() {
        return this.firewallRulesFailOpen;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.globalResolverId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnssecValidationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ednsClientSubnetAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.firewallRulesFailOpenAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDnsViewRequest)) {
            return false;
        }
        CreateDnsViewRequest other = (CreateDnsViewRequest)((Object)obj);
        return Objects.equals(this.globalResolverId(), other.globalResolverId()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.dnssecValidationAsString(), other.dnssecValidationAsString()) && Objects.equals(this.ednsClientSubnetAsString(), other.ednsClientSubnetAsString()) && Objects.equals(this.firewallRulesFailOpenAsString(), other.firewallRulesFailOpenAsString()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDnsViewRequest").add("GlobalResolverId", (Object)this.globalResolverId()).add("ClientToken", (Object)this.clientToken()).add("Name", (Object)this.name()).add("DnssecValidation", (Object)this.dnssecValidationAsString()).add("EdnsClientSubnet", (Object)this.ednsClientSubnetAsString()).add("FirewallRulesFailOpen", (Object)this.firewallRulesFailOpenAsString()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "globalResolverId": {
                return Optional.ofNullable(clazz.cast(this.globalResolverId()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "dnssecValidation": {
                return Optional.ofNullable(clazz.cast(this.dnssecValidationAsString()));
            }
            case "ednsClientSubnet": {
                return Optional.ofNullable(clazz.cast(this.ednsClientSubnetAsString()));
            }
            case "firewallRulesFailOpen": {
                return Optional.ofNullable(clazz.cast(this.firewallRulesFailOpenAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("globalResolverId", GLOBAL_RESOLVER_ID_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("dnssecValidation", DNSSEC_VALIDATION_FIELD);
        map.put("ednsClientSubnet", EDNS_CLIENT_SUBNET_FIELD);
        map.put("firewallRulesFailOpen", FIREWALL_RULES_FAIL_OPEN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDnsViewRequest, T> g) {
        return obj -> g.apply((CreateDnsViewRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53GlobalResolverRequest.BuilderImpl
    implements Builder {
        private String globalResolverId;
        private String clientToken;
        private String name;
        private String dnssecValidation;
        private String ednsClientSubnet;
        private String firewallRulesFailOpen;
        private String description;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDnsViewRequest model) {
            super(model);
            this.globalResolverId(model.globalResolverId);
            this.clientToken(model.clientToken);
            this.name(model.name);
            this.dnssecValidation(model.dnssecValidation);
            this.ednsClientSubnet(model.ednsClientSubnet);
            this.firewallRulesFailOpen(model.firewallRulesFailOpen);
            this.description(model.description);
            this.tags(model.tags);
        }

        public final String getGlobalResolverId() {
            return this.globalResolverId;
        }

        public final void setGlobalResolverId(String globalResolverId) {
            this.globalResolverId = globalResolverId;
        }

        @Override
        public final Builder globalResolverId(String globalResolverId) {
            this.globalResolverId = globalResolverId;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDnssecValidation() {
            return this.dnssecValidation;
        }

        public final void setDnssecValidation(String dnssecValidation) {
            this.dnssecValidation = dnssecValidation;
        }

        @Override
        public final Builder dnssecValidation(String dnssecValidation) {
            this.dnssecValidation = dnssecValidation;
            return this;
        }

        @Override
        public final Builder dnssecValidation(DnsSecValidationType dnssecValidation) {
            this.dnssecValidation(dnssecValidation == null ? null : dnssecValidation.toString());
            return this;
        }

        public final String getEdnsClientSubnet() {
            return this.ednsClientSubnet;
        }

        public final void setEdnsClientSubnet(String ednsClientSubnet) {
            this.ednsClientSubnet = ednsClientSubnet;
        }

        @Override
        public final Builder ednsClientSubnet(String ednsClientSubnet) {
            this.ednsClientSubnet = ednsClientSubnet;
            return this;
        }

        @Override
        public final Builder ednsClientSubnet(EdnsClientSubnetType ednsClientSubnet) {
            this.ednsClientSubnet(ednsClientSubnet == null ? null : ednsClientSubnet.toString());
            return this;
        }

        public final String getFirewallRulesFailOpen() {
            return this.firewallRulesFailOpen;
        }

        public final void setFirewallRulesFailOpen(String firewallRulesFailOpen) {
            this.firewallRulesFailOpen = firewallRulesFailOpen;
        }

        @Override
        public final Builder firewallRulesFailOpen(String firewallRulesFailOpen) {
            this.firewallRulesFailOpen = firewallRulesFailOpen;
            return this;
        }

        @Override
        public final Builder firewallRulesFailOpen(FirewallRulesFailOpenType firewallRulesFailOpen) {
            this.firewallRulesFailOpen(firewallRulesFailOpen == null ? null : firewallRulesFailOpen.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDnsViewRequest build() {
            return new CreateDnsViewRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Route53GlobalResolverRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDnsViewRequest> {
        public Builder globalResolverId(String var1);

        public Builder clientToken(String var1);

        public Builder name(String var1);

        public Builder dnssecValidation(String var1);

        public Builder dnssecValidation(DnsSecValidationType var1);

        public Builder ednsClientSubnet(String var1);

        public Builder ednsClientSubnet(EdnsClientSubnetType var1);

        public Builder firewallRulesFailOpen(String var1);

        public Builder firewallRulesFailOpen(FirewallRulesFailOpenType var1);

        public Builder description(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

