/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53globalresolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.route53globalresolver.model.DnsProtocol;
import software.amazon.awssdk.services.route53globalresolver.model.IpAddressType;
import software.amazon.awssdk.services.route53globalresolver.model.Route53GlobalResolverRequest;
import software.amazon.awssdk.services.route53globalresolver.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAccessSourceRequest
extends Route53GlobalResolverRequest
implements ToCopyableBuilder<Builder, CreateAccessSourceRequest> {
    private static final SdkField<String> CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cidr").getter(CreateAccessSourceRequest.getter(CreateAccessSourceRequest::cidr)).setter(CreateAccessSourceRequest.setter(Builder::cidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cidr").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateAccessSourceRequest.getter(CreateAccessSourceRequest::clientToken)).setter(CreateAccessSourceRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ipAddressType").getter(CreateAccessSourceRequest.getter(CreateAccessSourceRequest::ipAddressTypeAsString)).setter(CreateAccessSourceRequest.setter(Builder::ipAddressType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddressType").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateAccessSourceRequest.getter(CreateAccessSourceRequest::name)).setter(CreateAccessSourceRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DNS_VIEW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dnsViewId").getter(CreateAccessSourceRequest.getter(CreateAccessSourceRequest::dnsViewId)).setter(CreateAccessSourceRequest.setter(Builder::dnsViewId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsViewId").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("protocol").getter(CreateAccessSourceRequest.getter(CreateAccessSourceRequest::protocolAsString)).setter(CreateAccessSourceRequest.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateAccessSourceRequest.getter(CreateAccessSourceRequest::tags)).setter(CreateAccessSourceRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_FIELD, CLIENT_TOKEN_FIELD, IP_ADDRESS_TYPE_FIELD, NAME_FIELD, DNS_VIEW_ID_FIELD, PROTOCOL_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAccessSourceRequest.memberNameToFieldInitializer();
    private final String cidr;
    private final String clientToken;
    private final String ipAddressType;
    private final String name;
    private final String dnsViewId;
    private final String protocol;
    private final Map<String, String> tags;

    private CreateAccessSourceRequest(BuilderImpl builder) {
        super(builder);
        this.cidr = builder.cidr;
        this.clientToken = builder.clientToken;
        this.ipAddressType = builder.ipAddressType;
        this.name = builder.name;
        this.dnsViewId = builder.dnsViewId;
        this.protocol = builder.protocol;
        this.tags = builder.tags;
    }

    public final String cidr() {
        return this.cidr;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(this.ipAddressType);
    }

    public final String ipAddressTypeAsString() {
        return this.ipAddressType;
    }

    public final String name() {
        return this.name;
    }

    public final String dnsViewId() {
        return this.dnsViewId;
    }

    public final DnsProtocol protocol() {
        return DnsProtocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsViewId());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccessSourceRequest)) {
            return false;
        }
        CreateAccessSourceRequest other = (CreateAccessSourceRequest)((Object)obj);
        return Objects.equals(this.cidr(), other.cidr()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.ipAddressTypeAsString(), other.ipAddressTypeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.dnsViewId(), other.dnsViewId()) && Objects.equals(this.protocolAsString(), other.protocolAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAccessSourceRequest").add("Cidr", (Object)this.cidr()).add("ClientToken", (Object)this.clientToken()).add("IpAddressType", (Object)this.ipAddressTypeAsString()).add("Name", (Object)this.name()).add("DnsViewId", (Object)this.dnsViewId()).add("Protocol", (Object)this.protocolAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cidr": {
                return Optional.ofNullable(clazz.cast(this.cidr()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "ipAddressType": {
                return Optional.ofNullable(clazz.cast(this.ipAddressTypeAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "dnsViewId": {
                return Optional.ofNullable(clazz.cast(this.dnsViewId()));
            }
            case "protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cidr", CIDR_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("ipAddressType", IP_ADDRESS_TYPE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("dnsViewId", DNS_VIEW_ID_FIELD);
        map.put("protocol", PROTOCOL_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAccessSourceRequest, T> g) {
        return obj -> g.apply((CreateAccessSourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53GlobalResolverRequest.BuilderImpl
    implements Builder {
        private String cidr;
        private String clientToken;
        private String ipAddressType;
        private String name;
        private String dnsViewId;
        private String protocol;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccessSourceRequest model) {
            super(model);
            this.cidr(model.cidr);
            this.clientToken(model.clientToken);
            this.ipAddressType(model.ipAddressType);
            this.name(model.name);
            this.dnsViewId(model.dnsViewId);
            this.protocol(model.protocol);
            this.tags(model.tags);
        }

        public final String getCidr() {
            return this.cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getIpAddressType() {
            return this.ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDnsViewId() {
            return this.dnsViewId;
        }

        public final void setDnsViewId(String dnsViewId) {
            this.dnsViewId = dnsViewId;
        }

        @Override
        public final Builder dnsViewId(String dnsViewId) {
            this.dnsViewId = dnsViewId;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(DnsProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAccessSourceRequest build() {
            return new CreateAccessSourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Route53GlobalResolverRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAccessSourceRequest> {
        public Builder cidr(String var1);

        public Builder clientToken(String var1);

        public Builder ipAddressType(String var1);

        public Builder ipAddressType(IpAddressType var1);

        public Builder name(String var1);

        public Builder dnsViewId(String var1);

        public Builder protocol(String var1);

        public Builder protocol(DnsProtocol var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

