/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53globalresolver.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53globalresolver.Route53GlobalResolverAsyncClient;
import software.amazon.awssdk.services.route53globalresolver.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53globalresolver.model.ListManagedFirewallDomainListsRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListManagedFirewallDomainListsResponse;
import software.amazon.awssdk.services.route53globalresolver.model.ManagedFirewallDomainListsItem;

public class ListManagedFirewallDomainListsPublisher
implements SdkPublisher<ListManagedFirewallDomainListsResponse> {
    private final Route53GlobalResolverAsyncClient client;
    private final ListManagedFirewallDomainListsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListManagedFirewallDomainListsPublisher(Route53GlobalResolverAsyncClient client, ListManagedFirewallDomainListsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListManagedFirewallDomainListsPublisher(Route53GlobalResolverAsyncClient client, ListManagedFirewallDomainListsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListManagedFirewallDomainListsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListManagedFirewallDomainListsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ManagedFirewallDomainListsItem> managedFirewallDomainLists() {
        Function<ListManagedFirewallDomainListsResponse, Iterator> getIterator = response -> {
            if (response != null && response.managedFirewallDomainLists() != null) {
                return response.managedFirewallDomainLists().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListManagedFirewallDomainListsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListManagedFirewallDomainListsResponseFetcher
    implements AsyncPageFetcher<ListManagedFirewallDomainListsResponse> {
        private ListManagedFirewallDomainListsResponseFetcher() {
        }

        public boolean hasNextPage(ListManagedFirewallDomainListsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListManagedFirewallDomainListsResponse> nextPage(ListManagedFirewallDomainListsResponse previousPage) {
            if (previousPage == null) {
                return ListManagedFirewallDomainListsPublisher.this.client.listManagedFirewallDomainLists(ListManagedFirewallDomainListsPublisher.this.firstRequest);
            }
            return ListManagedFirewallDomainListsPublisher.this.client.listManagedFirewallDomainLists((ListManagedFirewallDomainListsRequest)((Object)ListManagedFirewallDomainListsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

