/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoverycluster.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53recoverycluster.Route53RecoveryClusterClient;
import software.amazon.awssdk.services.route53recoverycluster.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53recoverycluster.model.ListRoutingControlsRequest;
import software.amazon.awssdk.services.route53recoverycluster.model.ListRoutingControlsResponse;
import software.amazon.awssdk.services.route53recoverycluster.model.RoutingControl;

public class ListRoutingControlsIterable
implements SdkIterable<ListRoutingControlsResponse> {
    private final Route53RecoveryClusterClient client;
    private final ListRoutingControlsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRoutingControlsIterable(Route53RecoveryClusterClient client, ListRoutingControlsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRoutingControlsResponseFetcher();
    }

    public Iterator<ListRoutingControlsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RoutingControl> routingControls() {
        Function<ListRoutingControlsResponse, Iterator> getIterator = response -> {
            if (response != null && response.routingControls() != null) {
                return response.routingControls().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRoutingControlsResponseFetcher
    implements SyncPageFetcher<ListRoutingControlsResponse> {
        private ListRoutingControlsResponseFetcher() {
        }

        public boolean hasNextPage(ListRoutingControlsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRoutingControlsResponse nextPage(ListRoutingControlsResponse previousPage) {
            if (previousPage == null) {
                return ListRoutingControlsIterable.this.client.listRoutingControls(ListRoutingControlsIterable.this.firstRequest);
            }
            return ListRoutingControlsIterable.this.client.listRoutingControls((ListRoutingControlsRequest)((Object)ListRoutingControlsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

