/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoverycontrolconfig.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.Route53RecoveryControlConfigResponse;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.Rule;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.___listOfRuleCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSafetyRulesResponse
extends Route53RecoveryControlConfigResponse
implements ToCopyableBuilder<Builder, ListSafetyRulesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListSafetyRulesResponse.getter(ListSafetyRulesResponse::nextToken)).setter(ListSafetyRulesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<Rule>> SAFETY_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SafetyRules").getter(ListSafetyRulesResponse.getter(ListSafetyRulesResponse::safetyRules)).setter(ListSafetyRulesResponse.setter(Builder::safetyRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SafetyRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Rule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SAFETY_RULES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSafetyRulesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<Rule> safetyRules;

    private ListSafetyRulesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.safetyRules = builder.safetyRules;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasSafetyRules() {
        return this.safetyRules != null && !(this.safetyRules instanceof SdkAutoConstructList);
    }

    public final List<Rule> safetyRules() {
        return this.safetyRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSafetyRules() ? this.safetyRules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSafetyRulesResponse)) {
            return false;
        }
        ListSafetyRulesResponse other = (ListSafetyRulesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasSafetyRules() == other.hasSafetyRules() && Objects.equals(this.safetyRules(), other.safetyRules());
    }

    public final String toString() {
        return ToString.builder((String)"ListSafetyRulesResponse").add("NextToken", (Object)this.nextToken()).add("SafetyRules", this.hasSafetyRules() ? this.safetyRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "SafetyRules": {
                return Optional.ofNullable(clazz.cast(this.safetyRules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("SafetyRules", SAFETY_RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSafetyRulesResponse, T> g) {
        return obj -> g.apply((ListSafetyRulesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53RecoveryControlConfigResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<Rule> safetyRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSafetyRulesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.safetyRules(model.safetyRules);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<Rule.Builder> getSafetyRules() {
            List<Rule.Builder> result = ___listOfRuleCopier.copyToBuilder(this.safetyRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSafetyRules(Collection<Rule.BuilderImpl> safetyRules) {
            this.safetyRules = ___listOfRuleCopier.copyFromBuilder(safetyRules);
        }

        @Override
        public final Builder safetyRules(Collection<Rule> safetyRules) {
            this.safetyRules = ___listOfRuleCopier.copy(safetyRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder safetyRules(Rule ... safetyRules) {
            this.safetyRules(Arrays.asList(safetyRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder safetyRules(Consumer<Rule.Builder> ... safetyRules) {
            this.safetyRules(Stream.of(safetyRules).map(c -> (Rule)((Rule.Builder)Rule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSafetyRulesResponse build() {
            return new ListSafetyRulesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Route53RecoveryControlConfigResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSafetyRulesResponse> {
        public Builder nextToken(String var1);

        public Builder safetyRules(Collection<Rule> var1);

        public Builder safetyRules(Rule ... var1);

        public Builder safetyRules(Consumer<Rule.Builder> ... var1);
    }
}

