/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoverycontrolconfig.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53recoverycontrolconfig.Route53RecoveryControlConfigClient;
import software.amazon.awssdk.services.route53recoverycontrolconfig.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ControlPanel;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListControlPanelsRequest;
import software.amazon.awssdk.services.route53recoverycontrolconfig.model.ListControlPanelsResponse;

public class ListControlPanelsIterable
implements SdkIterable<ListControlPanelsResponse> {
    private final Route53RecoveryControlConfigClient client;
    private final ListControlPanelsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListControlPanelsIterable(Route53RecoveryControlConfigClient client, ListControlPanelsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListControlPanelsResponseFetcher();
    }

    public Iterator<ListControlPanelsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ControlPanel> controlPanels() {
        Function<ListControlPanelsResponse, Iterator> getIterator = response -> {
            if (response != null && response.controlPanels() != null) {
                return response.controlPanels().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListControlPanelsResponseFetcher
    implements SyncPageFetcher<ListControlPanelsResponse> {
        private ListControlPanelsResponseFetcher() {
        }

        public boolean hasNextPage(ListControlPanelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListControlPanelsResponse nextPage(ListControlPanelsResponse previousPage) {
            if (previousPage == null) {
                return ListControlPanelsIterable.this.client.listControlPanels(ListControlPanelsIterable.this.firstRequest);
            }
            return ListControlPanelsIterable.this.client.listControlPanels((ListControlPanelsRequest)((Object)ListControlPanelsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

