/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53recoveryreadiness;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;

/**
 * This includes configuration specific to AWS Route53 Recovery Readiness that is supported by both
 * {@link Route53RecoveryReadinessClientBuilder} and {@link Route53RecoveryReadinessAsyncClientBuilder}.
 */
@Generated("software.amazon.awssdk:codegen")
public interface Route53RecoveryReadinessBaseClientBuilder<B extends Route53RecoveryReadinessBaseClientBuilder<B, C>, C> extends
        AwsClientBuilder<B, C> {
}
